/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.apache.royale.compiler.internal.targets.TargetAttributeBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetAttributesMap
extends TargetAttributeBase {
    private static ImmutableSet<String> SPECIAL_ATTRIBUTES = ImmutableSet.of((Object)"preloader", (Object)"runtimeDPIProvider", (Object)"splashScreenImage", (Object)"implements", (Object)"usePreloader", (Object)"clbackgroundColorassName", (Object[])new String[0]);
    private final ImmutableMap<String, String> map;
    private final ImmutableMap<String, String> rootInfoAttributes;

    public TargetAttributesMap(Map<String, String> map) {
        this.map = ImmutableMap.copyOf(map);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (String key : map.keySet()) {
            if (SPECIAL_ATTRIBUTES.contains((Object)key)) continue;
            builder.put((Object)key, (Object)map.get(key));
        }
        this.rootInfoAttributes = builder.build();
    }

    @Override
    Boolean parseBoolean(String key) {
        String value = (String)this.map.get((Object)key);
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    Float parseFloat(String key) {
        String value = (String)this.map.get((Object)key);
        if (value == null) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(value));
    }

    @Override
    Integer parseInteger(String key) {
        String value = (String)this.map.get((Object)key);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    @Override
    String parseString(String key) {
        return (String)this.map.get((Object)key);
    }

    @Override
    Double parsePercentage(String key) {
        String value = (String)this.map.get((Object)key);
        if (value == null) {
            return null;
        }
        return super.parsePercentageValue(value);
    }

    @Override
    boolean isPercentage(String key) {
        String value = (String)this.map.get((Object)key);
        if (value == null) {
            return false;
        }
        return super.isPercentageValue(value);
    }

    @Override
    public Map<String, String> getRootInfoAttributes() {
        return this.rootInfoAttributes;
    }
}

