/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.royale.compiler.internal.targets.ITargetAttributes;

abstract class TargetAttributeBase
implements ITargetAttributes {
    private static final Pattern percentagePattern = Pattern.compile("\\s*((\\d+)(.(\\d)+)?)\\s*%\\s*");

    TargetAttributeBase() {
    }

    public Float getWidth() {
        if (this.isPercentage("width")) {
            return null;
        }
        return this.parseFloat("width");
    }

    public Float getHeight() {
        if (this.isPercentage("height")) {
            return null;
        }
        return this.parseFloat("height");
    }

    public Double getWidthPercentage() {
        if (!this.isPercentage("width")) {
            return null;
        }
        return this.parsePercentage("width");
    }

    public Double getHeightPercentage() {
        if (!this.isPercentage("height")) {
            return null;
        }
        return this.parsePercentage("height");
    }

    public String getBackgroundColor() {
        return this.parseString("clbackgroundColorassName");
    }

    public Float getFrameRate() {
        return this.parseFloat("frameRate");
    }

    public String getPreloaderClassName() {
        return this.parseString("preloader");
    }

    public String getRuntimeDPIProviderClassName() {
        return this.parseString("runtimeDPIProvider");
    }

    public Integer getScriptRecursionLimit() {
        return this.parseInteger("scriptRecursionLimit");
    }

    public Integer getScriptTimeLimit() {
        return this.parseInteger("scriptTimeLimit");
    }

    public String getSplashScreenImage() {
        return this.parseString("splashScreenImage");
    }

    public String getPageTitle() {
        return this.parseString("pageTitle");
    }

    public Boolean getUseDirectBlit() {
        return this.parseBoolean("useDirectBlit");
    }

    public Boolean getUseGPU() {
        return this.parseBoolean("useGPU");
    }

    public Boolean getUsePreloader() {
        return this.parseBoolean("usePreloader");
    }

    final boolean isPercentageValue(String value) {
        assert (value != null) : "isPercentageValue called on a null value";
        return value.indexOf(37) >= 0;
    }

    final Double parsePercentageValue(String value) {
        assert (value != null) : "parsePercentageValue called on a null value";
        Matcher m = percentagePattern.matcher(value);
        if (m.matches()) {
            return Double.valueOf(m.group(1));
        }
        return null;
    }

    abstract Boolean parseBoolean(String var1);

    abstract Float parseFloat(String var1);

    abstract Integer parseInteger(String var1);

    abstract String parseString(String var1);

    abstract Double parsePercentage(String var1);

    abstract boolean isPercentage(String var1);
}

