/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import com.google.common.collect.MapMaker;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IInterfaceDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.internal.definitions.AmbiguousDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinitionBase;
import org.apache.royale.compiler.internal.definitions.ConstantDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.units.ICompilationUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASScopeCache {
    private static final int CONCURRENCY_LEVEL = 4;
    private static final MapMaker mapMaker = new MapMaker().concurrencyLevel(4);
    private final ASScope scope;
    private final CompilerProject project;
    private SoftReference<ConcurrentMap<String, IDefinition>> findPropCache;
    private SoftReference<ConcurrentMap<QName, IDefinition>> findPropQualifiedCache;
    private SoftReference<Set<INamespaceDefinition>> openNamespaceCache = null;
    private SoftReference<ConcurrentMap<String, Set<INamespaceDefinition>>> namespacesForNameCache;
    private SoftReference<ConcurrentMap<IResolvedQualifiersReference, IDefinition>> multinameLookupCache;
    private SoftReference<ConcurrentMap<IDefinition, Object>> constValueLookupCache;
    private Boolean needsEventDispatcherCache;
    private SoftReference<IInterfaceDefinition[]> interfacesCache;
    private SoftReference<Set<IASLanguageConstants.BuiltinType>> builtinTypeDependencyCache;
    private static final Object NO_CONST_VALUE = new Object();

    public ASScopeCache(CompilerProject project, ASScope scope) {
        this.scope = scope;
        this.project = project;
    }

    IDefinition findProperty(String name, DependencyType dt, boolean favorTypes) {
        ConcurrentMap<String, IDefinition> map = this.getScopeChainMap();
        IDefinition result = (IDefinition)map.get(name);
        if (result != null) {
            if (result instanceof ITypeDefinition) {
                ICompilationUnit from = this.scope.getFileScope().getCompilationUnit();
                assert (result.isInProject(this.project));
                String qname = result.getQualifiedName();
                ICompilationUnit to = this.project.getScope().getCompilationUnitForDefinition(result);
                if (to == null && !qname.contentEquals("void") && !qname.contentEquals("*")) {
                    System.out.println("No compilation unit for " + qname);
                }
                if (to != null) {
                    this.project.addDependency(from, to, dt, qname);
                }
            }
            return result;
        }
        boolean wasAmbiguous = false;
        IDefinition def = null;
        Set<INamespaceDefinition> namespaceSet = this.scope.getNamespaceSetForName(this.project, name);
        List<IDefinition> defs = this.scope.findProperty(this.project, name, namespaceSet, dt);
        switch (defs.size()) {
            case 0: {
                def = null;
                break;
            }
            case 1: {
                def = defs.get(0);
                assert (def.isInProject(this.project));
                break;
            }
            default: {
                wasAmbiguous = true;
                IDefinition d = AmbiguousDefinition.resolveAmbiguities(this.project, defs, favorTypes);
                if (d != null) {
                    def = d;
                    break;
                }
                if (defs.size() == 2 && (def = this.project.doubleCheckAmbiguousDefinition(this.scope, name, defs.get(0), defs.get(1))) != null) {
                    return def;
                }
                def = AmbiguousDefinition.get();
            }
        }
        if (def != null) {
            assert (def.isInProject(this.project));
            assert (result == null);
            if (dt != null && !wasAmbiguous) {
                result = map.putIfAbsent(name, def);
                if (result == null) {
                    result = def;
                }
            } else {
                result = def;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<String, IDefinition> getScopeChainMap() {
        ConcurrentMap map;
        ConcurrentMap concurrentMap = map = this.findPropCache != null ? this.findPropCache.get() : null;
        if (map == null) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache waiting for lock in getScopeChainMap");
            }
            ASScopeCache aSScopeCache = this;
            synchronized (aSScopeCache) {
                ConcurrentMap concurrentMap2 = map = this.findPropCache != null ? this.findPropCache.get() : null;
                if (map == null) {
                    map = mapMaker.makeMap();
                    this.findPropCache = new SoftReference<ConcurrentMap>(map);
                }
            }
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache done with lock in getScopeChainMap");
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<QName, IDefinition> getQualifiedScopeChainMap() {
        ConcurrentMap map;
        ConcurrentMap concurrentMap = map = this.findPropQualifiedCache != null ? this.findPropQualifiedCache.get() : null;
        if (map == null) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache waiting for lock in getQualifiedScopeChainMap");
            }
            ASScopeCache aSScopeCache = this;
            synchronized (aSScopeCache) {
                ConcurrentMap concurrentMap2 = map = this.findPropQualifiedCache != null ? this.findPropQualifiedCache.get() : null;
                if (map == null) {
                    map = mapMaker.makeMap();
                    this.findPropQualifiedCache = new SoftReference<ConcurrentMap>(map);
                }
            }
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache done with lock in getQualifiedScopeChainMap");
            }
        }
        return map;
    }

    IDefinition findPropertyQualified(INamespaceDefinition qualifier, String name, DependencyType dt) {
        IDefinition def;
        QName qname = new QName(name, qualifier);
        ConcurrentMap<QName, IDefinition> map = this.getQualifiedScopeChainMap();
        IDefinition result = (IDefinition)map.get(qname);
        if (result != null) {
            assert (result.isInProject(this.project));
            return result;
        }
        Set<INamespaceDefinition> namespaceSet = Collections.singleton(qualifier);
        List<IDefinition> defs = this.scope.findProperty(this.project, name, namespaceSet, dt);
        switch (defs.size()) {
            case 0: {
                def = null;
                break;
            }
            case 1: {
                def = defs.get(0);
                assert (def.isInProject(this.project));
                break;
            }
            default: {
                IDefinition d = AmbiguousDefinition.resolveAmbiguities(this.project, defs, false);
                def = d != null ? d : AmbiguousDefinition.get();
            }
        }
        if (def != null) {
            assert (def.isInProject(this.project));
            assert (result == null);
            if (dt != null) {
                result = map.putIfAbsent(qname, def);
                if (result == null) {
                    result = def;
                }
            } else {
                result = def;
            }
        }
        return result;
    }

    public IDefinition findPropertyMultiname(IResolvedQualifiersReference ref, DependencyType dt) {
        IDefinition def;
        ConcurrentMap<IResolvedQualifiersReference, IDefinition> cache = this.getMultinameLookupMap();
        IDefinition result = (IDefinition)cache.get(ref);
        if (result != null) {
            return result;
        }
        List<IDefinition> defs = this.scope.findProperty(this.project, ref.getName(), (Set<INamespaceDefinition>)ref.getQualifiers(), dt);
        switch (defs.size()) {
            case 0: {
                def = null;
                break;
            }
            case 1: {
                def = defs.get(0);
                assert (def.isInProject(this.project));
                break;
            }
            default: {
                IDefinition d = AmbiguousDefinition.resolveAmbiguities(this.project, defs, false);
                def = d != null ? d : AmbiguousDefinition.get();
            }
        }
        if (def != null) {
            assert (def.isInProject(this.project));
            assert (result == null);
            if (dt != null) {
                result = cache.putIfAbsent(ref, def);
                if (result == null) {
                    result = def;
                }
            } else {
                result = def;
            }
        }
        return result;
    }

    Set<INamespaceDefinition> getNamespaceSet() {
        Set<INamespaceDefinition> nsSet;
        Set<INamespaceDefinition> set = nsSet = this.openNamespaceCache != null ? this.openNamespaceCache.get() : null;
        if (nsSet != null) {
            return nsSet;
        }
        nsSet = this.scope.getNamespaceSetImpl(this.project);
        this.openNamespaceCache = new SoftReference<Set<INamespaceDefinition>>(nsSet);
        return nsSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<String, Set<INamespaceDefinition>> getNamespacesForNameMap() {
        ConcurrentMap map;
        ConcurrentMap concurrentMap = map = this.namespacesForNameCache != null ? this.namespacesForNameCache.get() : null;
        if (map == null) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache waiting for lock in getNamespacesForNameMap");
            }
            ASScopeCache aSScopeCache = this;
            synchronized (aSScopeCache) {
                ConcurrentMap concurrentMap2 = map = this.namespacesForNameCache != null ? this.namespacesForNameCache.get() : null;
                if (map == null) {
                    map = mapMaker.makeMap();
                    this.namespacesForNameCache = new SoftReference<ConcurrentMap>(map);
                }
            }
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache done with lock in getNamespacesForNameMap");
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<IResolvedQualifiersReference, IDefinition> getMultinameLookupMap() {
        ConcurrentMap map;
        ConcurrentMap concurrentMap = map = this.multinameLookupCache != null ? this.multinameLookupCache.get() : null;
        if (map == null) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache waiting for lock in getMultinameLookupMap");
            }
            ASScopeCache aSScopeCache = this;
            synchronized (aSScopeCache) {
                ConcurrentMap concurrentMap2 = map = this.multinameLookupCache != null ? this.multinameLookupCache.get() : null;
                if (map == null) {
                    map = mapMaker.makeMap();
                    this.multinameLookupCache = new SoftReference<ConcurrentMap>(map);
                }
            }
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache done with lock in getMultinameLookupMap");
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<IDefinition, Object> getConstantValueLookupMap() {
        ConcurrentMap map;
        ConcurrentMap concurrentMap = map = this.constValueLookupCache != null ? this.constValueLookupCache.get() : null;
        if (map == null) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache waiting for lock in getConstantValueLookupMap");
            }
            ASScopeCache aSScopeCache = this;
            synchronized (aSScopeCache) {
                ConcurrentMap concurrentMap2 = map = this.constValueLookupCache != null ? this.constValueLookupCache.get() : null;
                if (map == null) {
                    map = mapMaker.makeMap();
                    this.constValueLookupCache = new SoftReference<ConcurrentMap>(map);
                }
            }
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache done with lock in getConstantValueLookupMap");
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IASLanguageConstants.BuiltinType> getBuiltinTypeMap() {
        Set<IASLanguageConstants.BuiltinType> set;
        Set<IASLanguageConstants.BuiltinType> set2 = set = this.builtinTypeDependencyCache != null ? this.builtinTypeDependencyCache.get() : null;
        if (set == null) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache waiting for lock in getBuiltinTypeMap");
            }
            ASScopeCache aSScopeCache = this;
            synchronized (aSScopeCache) {
                Set<IASLanguageConstants.BuiltinType> set3 = set = this.builtinTypeDependencyCache != null ? this.builtinTypeDependencyCache.get() : null;
                if (set == null) {
                    set = Collections.newSetFromMap(mapMaker.makeMap());
                    this.builtinTypeDependencyCache = new SoftReference<Set<IASLanguageConstants.BuiltinType>>(set);
                }
            }
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache done with lock in getBuiltinTypeMap");
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsEventDispatcher() {
        assert (this.scope instanceof TypeScope) : "needsEventDispatcher should only be called on scope cache's for TypeScopes!";
        assert (this.scope.getDefinition() instanceof ClassDefinitionBase) : "needsEventDispatcher should only be called on scope cache's for the scopes contained by classes!";
        Boolean valueObject = this.needsEventDispatcherCache;
        if (valueObject != null) {
            return valueObject;
        }
        if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
            System.out.println("ASScopeCache waiting for lock in needsEventDispatcher");
        }
        ASScopeCache aSScopeCache = this;
        synchronized (aSScopeCache) {
            valueObject = this.needsEventDispatcherCache;
            if (valueObject != null) {
                if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                    System.out.println("ASScopeCache done with lock in needsEventDispatcher");
                }
                return valueObject;
            }
            boolean computedValue = ((ClassDefinitionBase)this.scope.getDefinition()).computeNeedsEventDispatcher(this.project);
            this.needsEventDispatcherCache = computedValue;
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache done with lock in needsEventDispatcher");
            }
            return computedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IInterfaceDefinition[] resolveInterfaces() {
        IInterfaceDefinition[] interfs;
        assert (this.scope instanceof TypeScope) : "resolveInterfacesImpl should only be called on scope cache's for TypeScopes!";
        assert (this.scope.getDefinition() instanceof TypeDefinitionBase) : "resolveInterfacesImpl should only be called on scope cache's for the scopes contained by types!";
        IInterfaceDefinition[] iInterfaceDefinitionArray = interfs = this.interfacesCache != null ? this.interfacesCache.get() : null;
        if (interfs != null) {
            return interfs;
        }
        if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
            System.out.println("ASScopeCache waiting for lock in resolveInterfaces");
        }
        ASScopeCache aSScopeCache = this;
        synchronized (aSScopeCache) {
            IInterfaceDefinition[] iInterfaceDefinitionArray2 = interfs = this.interfacesCache != null ? this.interfacesCache.get() : null;
            if (interfs != null) {
                if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                    System.out.println("ASScopeCache done with lock in resolveInterfaces");
                }
                return interfs;
            }
            interfs = ((TypeDefinitionBase)this.scope.getDefinition()).resolveInterfacesImpl(this.project);
            this.interfacesCache = new SoftReference<IInterfaceDefinition[]>(interfs);
            if ((CompilerDiagnosticsConstants.diagnostics & 0x40) == 64) {
                System.out.println("ASScopeCache done with lock in resolveInterfaces");
            }
            return interfs;
        }
    }

    Set<INamespaceDefinition> getNamespaceSetForName(String name) {
        ConcurrentMap<String, Set<INamespaceDefinition>> map = this.getNamespacesForNameMap();
        Set<INamespaceDefinition> result = (Set<INamespaceDefinition>)map.get(name);
        if (result != null) {
            return result;
        }
        Set<INamespaceDefinition> newResult = this.scope.getNamespaceSetForNameImpl(this.project, name);
        result = map.putIfAbsent(name, newResult);
        if (result == null) {
            result = newResult;
        }
        return result;
    }

    void addDependencyOnBuiltinType(IASLanguageConstants.BuiltinType builtinType, DependencyType dt) {
        Set<IASLanguageConstants.BuiltinType> set = this.getBuiltinTypeMap();
        if (set.contains((Object)builtinType)) {
            return;
        }
        this.scope.addDependencyOnBuiltinTypeImpl(this.project, builtinType, dt);
        set.add(builtinType);
    }

    public Object getConstantValue(ConstantDefinition constDef) {
        ConcurrentMap<IDefinition, Object> map = this.getConstantValueLookupMap();
        Object result = map.get(constDef);
        if (result != null) {
            if (result == NO_CONST_VALUE) {
                return null;
            }
            return result;
        }
        Object newResult = constDef.resolveValueImpl(this.project);
        if (newResult == null) {
            newResult = NO_CONST_VALUE;
        }
        if ((result = map.putIfAbsent(constDef, newResult)) == null) {
            result = newResult;
        }
        if (result == NO_CONST_VALUE) {
            return null;
        }
        return result;
    }

    private static class QName {
        String name;
        INamespaceDefinition ns;

        QName(String name, INamespaceDefinition ns) {
            assert (ns != null);
            this.name = name;
            this.ns = ns;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.ns.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof QName) {
                QName other = (QName)o;
                return this.name.equals(other.name) && this.ns.equals(other.ns);
            }
            return false;
        }
    }
}

