/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.internal.projects.DependencyGraph;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IABCBytesRequestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationBytesCalculator {
    public static Map<ICompilationUnit, Integer> calculateBytesChanged(Collection<ICompilationUnit> units) throws InterruptedException {
        HashMap<ICompilationUnit, Integer> bytesChanged = new HashMap<ICompilationUnit, Integer>();
        for (ICompilationUnit unit : units) {
            assert (unit != null);
            IABCBytesRequestResult res = unit.getABCBytesRequest().get();
            assert (res != null);
            bytesChanged.put(unit, res.getABCBytes().length);
        }
        return bytesChanged;
    }

    public static Map<ICompilationUnit, Integer> calculateTotalInvalidatedBytesChanged(Collection<ICompilationUnit> units) throws InterruptedException {
        Map<ICompilationUnit, Integer> bytesChanged = InvalidationBytesCalculator.calculateBytesChanged(units);
        HashMap<ICompilationUnit, Integer> totalBytesChanged = new HashMap<ICompilationUnit, Integer>();
        ArrayList<ICompilationUnit> singleUnit = new ArrayList<ICompilationUnit>();
        singleUnit.add(null);
        for (ICompilationUnit unit : units) {
            singleUnit.set(0, unit);
            Set<ICompilationUnit> invalidatedUnits = DependencyGraph.computeInvalidationSet(singleUnit);
            int byteTotal = 0;
            for (ICompilationUnit invalidatedUnit : invalidatedUnits) {
                if (!bytesChanged.containsKey(invalidatedUnit)) {
                    bytesChanged.put(invalidatedUnit, invalidatedUnit.getABCBytesRequest().get().getABCBytes().length);
                }
                byteTotal += bytesChanged.get(invalidatedUnit).intValue();
            }
            totalBytesChanged.put(unit, byteTotal);
        }
        return totalBytesChanged;
    }
}

