/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.IScopedDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.INamespaceResolvedReference;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.PackageScope;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.FunctionObjectNode;
import org.apache.royale.compiler.internal.tree.as.QualifiedNamespaceExpressionNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.utils.StringEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamespaceDefinition
extends DefinitionBase
implements INamespaceDefinition,
INamespaceResolvedReference {
    private static PublicNamespaceDefinition PUBLIC = new PublicNamespaceDefinition();
    private static UserDefinedNamespaceDefinition AS3 = new UserDefinedNamespaceDefinition("AS3", "http://adobe.com/AS3/2006/builtin");
    private static INamespaceDefinition.ICodeModelImplicitDefinitionNamespaceDefinition CM_IMPLICIT_DEF_NS = new CodeModelImplicitDefinitionNamespaceDefinition();
    private static AnyNamespaceDefinition ANY = new AnyNamespaceDefinition();
    private final Namespace aetNamespace;

    public static INamespaceDefinition.IPublicNamespaceDefinition getPublicNamespaceDefinition() {
        return PUBLIC;
    }

    public static INamespaceDefinition getAS3NamespaceDefinition() {
        return AS3;
    }

    public static INamespaceReference getAS3NamespaceReference() {
        return AS3;
    }

    public static INamespaceReference getAnyNamespaceReference() {
        return ANY;
    }

    public static INamespaceDefinition.ICodeModelImplicitDefinitionNamespaceDefinition getCodeModelImplicitDefinitionNamespace() {
        return CM_IMPLICIT_DEF_NS;
    }

    public static NamespaceDefinition createNamespaceDefinition(Namespace ns) {
        return NamespaceDefinition.createNamespaceDefinition(null, ns);
    }

    public static NamespaceDefinition createNamespaceDefinition(String name, Namespace ns) {
        int namespaceKind = ns.getKind();
        switch (namespaceKind) {
            case 22: {
                if (ns.getName().length() == 0) {
                    return PUBLIC;
                }
                return new PublicNamespaceDefinition(ns);
            }
            case 23: {
                if (name == null) {
                    return new InternalNamespaceDefinition(ns);
                }
                return new UserDefinedNamespaceDefinition(name, ns);
            }
            case 5: {
                return new PrivateNamespaceDefinition(ns);
            }
            case 24: {
                return new ProtectedNamespaceDefinition(ns);
            }
            case 26: {
                return new StaticProtectedNamespaceDefinition(ns);
            }
            case 8: {
                if (name == null) {
                    name = "";
                }
                return new UserDefinedNamespaceDefinition(name, ns);
            }
        }
        assert (false) : "Unknown namespace kind!";
        return null;
    }

    public static INamespaceDefinition.IPrivateNamespaceDefinition createPrivateNamespaceDefinition(String uri) {
        return new PrivateNamespaceDefinition(uri);
    }

    public static INamespaceDefinition.IFilePrivateNamespaceDefinition createFilePrivateNamespaceDefinition(String uri) {
        return new FilePrivateNamespaceDefinition(uri);
    }

    public static INamespaceDefinition.IProtectedNamespaceDefinition createProtectedNamespaceDefinition(String uri) {
        return new ProtectedNamespaceDefinition(uri);
    }

    public static INamespaceDefinition.IStaticProtectedNamespaceDefinition createStaticProtectedNamespaceDefinition(String uri) {
        return new StaticProtectedNamespaceDefinition(uri);
    }

    public static INamespaceDefinition.IInternalNamespaceDefinition createInternalNamespaceDefinition(String owningPackageName) {
        return new InternalNamespaceDefinition(owningPackageName);
    }

    public static INamespaceDefinition.IInterfaceNamespaceDefinition createInterfaceNamespaceDefinition(InterfaceDefinition owningInterface) {
        return new InterfaceNamespaceDefinition(owningInterface);
    }

    public static INamespaceDefinition.IPublicNamespaceDefinition createPackagePublicNamespaceDefinition(String packageName) {
        if (packageName.length() == 0) {
            return PUBLIC;
        }
        return new PublicNamespaceDefinition(packageName);
    }

    public static NamespaceDefinition createUserDefinedNamespace(String name, String uri) {
        return new UserDefinedNamespaceDefinition(name, uri);
    }

    public static NamespaceDefinition createNamespaceDefintionDirective(INamespaceReference qualifierNamespaceRef, IASScope scope, String name, String uri, INamespaceReference initializer) {
        NamespaceDefinitionDirective directive = new NamespaceDefinitionDirective(qualifierNamespaceRef, scope, name, uri, initializer);
        ((ASScope)scope).addNamespaceDirective(directive);
        return directive;
    }

    public static INamespaceReference createNamespaceReference(IASScope scope, INamespaceDecorationNode node) {
        return NamespaceDefinition.createNamespaceReference(scope, node, false);
    }

    public static void setContainingDefinitionOfReference(INamespaceReference nsRef, IDefinition containingDef) {
        if (nsRef instanceof UserDefinedNamespaceReference) {
            ((UserDefinedNamespaceReference)nsRef).setContainingDefinition(containingDef);
        }
    }

    public static INamespaceReference createNamespaceReference(IASScope scope, INamespaceDecorationNode node, boolean isStatic) {
        assert (scope != null);
        String baseName = NamespaceDefinition.getBaseName(node);
        if (baseName.equals("public")) {
            ClassDefinition classDefinition = NamespaceDefinition.getContainingClassDefinition(scope);
            if (classDefinition != null) {
                return PUBLIC;
            }
            PackageScope packageScope = NamespaceDefinition.getContainingPackageScope(scope);
            if (packageScope != null) {
                return packageScope.getPublicNamespace();
            }
            if (node.isExpressionQualifier()) {
                return PUBLIC;
            }
            return NamespaceDefinition.getCodeModelImplicitDefinitionNamespace();
        }
        if (baseName.equals("internal")) {
            return NamespaceDefinition.getDefaultNamespaceDefinition(scope);
        }
        if (baseName.equals("private")) {
            ClassDefinition classDefinition = NamespaceDefinition.getContainingClassDefinition(scope);
            if (classDefinition != null) {
                return classDefinition.getPrivateNamespaceReference();
            }
            return NamespaceDefinition.getCodeModelImplicitDefinitionNamespace();
        }
        if (baseName.equals("protected")) {
            ClassDefinition classDefinition = NamespaceDefinition.getContainingClassDefinition(scope);
            if (classDefinition != null) {
                if (isStatic) {
                    return classDefinition.getStaticProtectedNamespaceReference();
                }
                return classDefinition.getProtectedNamespaceReference();
            }
            return NamespaceDefinition.getCodeModelImplicitDefinitionNamespace();
        }
        if (baseName.equals("*")) {
            return ANY;
        }
        if (node instanceof ExpressionNodeBase) {
            return ((ExpressionNodeBase)((Object)node)).computeNamespaceReference();
        }
        assert (false) : "creating a namespace reference from an unknown node type";
        return new UserDefinedNamespaceReference((ASScope)scope, node);
    }

    public static boolean qualifierCouldBeManyNamespaces(ASScope scope, INamespaceDecorationNode node) {
        String baseName = NamespaceDefinition.getBaseName(node);
        return baseName.equals("public") || baseName.equals("protected");
    }

    public static Collection<INamespaceReference> createNamespaceReferencesForQualifier(ASScope scope, INamespaceDecorationNode node) {
        ClassDefinition classDef;
        ArrayList nsrefs = new ArrayList();
        String baseName = NamespaceDefinition.getBaseName(node);
        INamespaceReference first = NamespaceDefinition.createNamespaceReference(scope, node);
        nsrefs.add(first);
        if (first instanceof INamespaceDefinition.IPublicNamespaceDefinition && baseName.equals("public")) {
            PackageScope packageScope;
            if (first != PUBLIC && (packageScope = NamespaceDefinition.getContainingPackageScope(scope)) != null && packageScope.getPublicNamespace() == first) {
                nsrefs.add(PUBLIC);
            }
        } else if (first instanceof INamespaceDefinition.IProtectedNamespaceDefinition && baseName.equals("protected") && (classDef = NamespaceDefinition.getContainingClassDefinition(scope)) != null && classDef.getProtectedNamespaceReference() == first) {
            nsrefs.add(classDef.getStaticProtectedNamespaceReference());
        }
        return nsrefs == null ? Collections.emptyList() : nsrefs;
    }

    public static INamespaceReference createNamespaceReference(ASScope scope, String baseName, INamespaceReference qualifier, IReference base) {
        return new MemberNamespaceReference(scope, base, baseName, qualifier);
    }

    public static INamespaceReference createNamespaceReference(ASScope scope, String baseName, INamespaceReference qualifier) {
        return new UserDefinedNamespaceReference(scope, baseName, qualifier);
    }

    public static void addUseNamespaceDirectiveToScope(IASScope scope, INamespaceDecorationNode node) {
        assert (scope != null);
        String baseName = NamespaceDefinition.getBaseName(node);
        if (baseName.equals("public")) {
            return;
        }
        UseNamespaceDirective directive = new UseNamespaceDirective((ASScope)scope, node);
        ((ASScope)scope).addUseDirective(directive);
    }

    private static String getBaseName(INamespaceDecorationNode node) {
        if (node == null) {
            return "internal";
        }
        String baseName = node.getName();
        if (baseName == null) {
            return "internal";
        }
        int index = baseName.lastIndexOf(".");
        if (index != -1) {
            baseName = baseName.substring(index + 1);
        }
        return baseName;
    }

    public static INamespaceDefinition.ILanguageNamespaceDefinition getDefaultNamespaceDefinition(IASScope scope) {
        InterfaceDefinition interfaceDef;
        InterfaceDefinition interfaceDefinition = interfaceDef = scope.getDefinition() instanceof InterfaceDefinition ? (InterfaceDefinition)scope.getDefinition() : null;
        if (interfaceDef != null) {
            return interfaceDef.getInterfaceNamespaceReference();
        }
        PackageScope packageScope = NamespaceDefinition.getContainingPackageScope(scope);
        if (packageScope != null) {
            return packageScope.getInternalNamespace();
        }
        return NamespaceDefinition.getFileScope(scope).getFilePrivateNamespaceReference();
    }

    private static ASFileScope getFileScope(IASScope scope) {
        IASScope currScope;
        for (currScope = scope; currScope != null && !(currScope instanceof ASFileScope); currScope = currScope.getContainingScope()) {
        }
        assert (currScope != null) : "Could not traverse to a file scope!";
        return (ASFileScope)currScope;
    }

    private static PackageScope getContainingPackageScope(IASScope scope) {
        while (!(scope instanceof PackageScope) && scope != null) {
            scope = scope.getContainingScope();
        }
        return (PackageScope)scope;
    }

    private static ClassDefinition getContainingClassDefinition(IASScope scope) {
        if (!(scope instanceof ASScope)) {
            return null;
        }
        ASScope asScope = (ASScope)scope;
        IScopedDefinition containingDef = asScope.getContainingDefinition();
        if (containingDef == null) {
            return null;
        }
        if (containingDef instanceof ClassDefinition) {
            return (ClassDefinition)containingDef;
        }
        ClassDefinition classDefinition = (ClassDefinition)containingDef.getAncestorOfType(ClassDefinition.class);
        return classDefinition;
    }

    private NamespaceDefinition(String name, int kind, String uri) {
        this(name, new Namespace(kind, uri == null ? "" : uri));
    }

    private NamespaceDefinition(String name, Namespace ns) {
        super(name);
        this.aetNamespace = ns;
    }

    @Override
    public String getURI() {
        return this.aetNamespace.getName();
    }

    @Override
    public INamespaceNode getNode() {
        return (INamespaceNode)super.getNode();
    }

    @Override
    public boolean isLanguageNamespace() {
        return false;
    }

    @Override
    public INamespaceDefinition resolveNamespaceReference(ICompilerProject project) {
        return this;
    }

    @Override
    public boolean matches(DefinitionBase node) {
        boolean matches = super.matches(node);
        if (!matches) {
            return matches;
        }
        NamespaceDefinition nNode = (NamespaceDefinition)node;
        if (nNode.getURI().compareTo(this.getURI()) != 0) {
            return false;
        }
        INamespaceDefinition.NamespaceClassification classification = nNode.getNamespaceClassification();
        if (classification != this.getNamespaceClassification()) {
            return false;
        }
        if (classification == INamespaceDefinition.NamespaceClassification.LOCAL || classification == INamespaceDefinition.NamespaceClassification.FILE_MEMBER) {
            if (nNode.getNameStart() != this.getNameStart() || nNode.getNameEnd() != this.getNameEnd()) {
                return false;
            }
        } else if (classification == INamespaceDefinition.NamespaceClassification.CLASS_MEMBER) {
            IASScope type2;
            IASScope type = node.getContainingScope();
            if (type != (type2 = this.getContainingScope())) {
                return false;
            }
            return type == type2;
        }
        return true;
    }

    @Override
    public String getBaseName() {
        return this.getStorageName();
    }

    @Override
    public boolean isPublicOrInternalNamespace() {
        return false;
    }

    @Override
    public int getNamespaceCount() {
        return 1;
    }

    @Override
    public Set<INamespaceDefinition> getNamespaceSet() {
        return ImmutableSet.of((Object)this);
    }

    @Override
    public INamespaceDefinition getFirst() {
        return this;
    }

    public Namespace getAETNamespace() {
        return this.aetNamespace;
    }

    public int hashCode() {
        return this.aetNamespace.hashCode();
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof INamespaceDefinition) {
            ret = this.equals((INamespaceDefinition)obj);
        }
        return ret;
    }

    @Override
    public boolean equals(INamespaceDefinition ns) {
        if (ns == null) {
            return false;
        }
        return ((NamespaceDefinition)ns).aetNamespace.equals(this.aetNamespace);
    }

    @Override
    public boolean isStatic() {
        if (this.getParent() instanceof ClassDefinition) {
            return true;
        }
        return super.isStatic();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NamespaceDirectiveResolver {
        private final ICompilerProject project;
        private final ASScope scope;
        private final ASScope containingScope;
        private Set<INamespaceDefinition> resolvedOpenNamespaces;
        private Map<String, List<ResolvedNamespaceDefinitionDirective>> resolvedNamespaceDirectiveSymbolTable;
        private NamespaceForwardReferencePredicate forwardRefPred;

        public static INamespaceDefinition resolveNamespaceReferenceInDirective(ICompilerProject project, UserDefinedNamespaceReference namespaceReference, INamespaceDirective containingDirective) {
            assert (containingDirective != null);
            NamespaceForwardReferencePredicate pred = null;
            pred = new NamespaceForwardReferencePredicate();
            return NamespaceDirectiveResolver.resolveNamespaceReferenceInDirective(project, namespaceReference, containingDirective, pred);
        }

        public static INamespaceDefinition resolveNamespaceReferenceInDirective(ICompilerProject project, UserDefinedNamespaceReference namespaceReference, INamespaceDirective containingDirective, NamespaceForwardReferencePredicate pred) {
            ASScope scope = namespaceReference.getScope();
            assert (scope != null) : "All UserDefinedNamespaceReferences should have a scope!";
            pred = pred.copy();
            if (containingDirective instanceof IDefinition) {
                pred.addRef((IDefinition)((Object)containingDirective));
            }
            NamespaceDirectiveResolver resolver = new NamespaceDirectiveResolver(project, scope, pred);
            for (INamespaceDirective currentDirective = scope.getFirstNamespaceDirective(); containingDirective != currentDirective; currentDirective = currentDirective.getNext()) {
                currentDirective.resolveDirective(resolver);
                assert (currentDirective != null);
            }
            return resolver.resolveDirectiveReference(namespaceReference);
        }

        private NamespaceDirectiveResolver(ICompilerProject project, ASScope scope, NamespaceForwardReferencePredicate pred) {
            this.project = project;
            this.scope = scope;
            this.containingScope = scope.getContainingScope();
            this.resolvedOpenNamespaces = null;
            this.resolvedNamespaceDirectiveSymbolTable = null;
            this.forwardRefPred = pred;
        }

        private Set<INamespaceDefinition> getResolvedOpenNamespaces(String name) {
            Set<INamespaceDefinition> additionalNamespaces;
            if (this.resolvedOpenNamespaces == null) {
                this.resolvedOpenNamespaces = new HashSet<INamespaceDefinition>();
                this.scope.addLocalImportsToNamespaceSet(this.project.getWorkspace(), this.resolvedOpenNamespaces);
                this.scope.addImplicitOpenNamespaces((CompilerProject)this.project, this.resolvedOpenNamespaces);
                if (this.containingScope != null) {
                    Set<INamespaceDefinition> containingScopeNamespaceSet = this.containingScope.getNamespaceSet(this.project);
                    this.resolvedOpenNamespaces.addAll(containingScopeNamespaceSet);
                } else {
                    ((CompilerProject)this.project).addGlobalUsedNamespacesToNamespaceSet(this.resolvedOpenNamespaces);
                }
            }
            if (this.scope != null && (additionalNamespaces = this.scope.getExplicitImportQualifiers((CompilerProject)this.project, name)) != null) {
                HashSet<INamespaceDefinition> set = new HashSet<INamespaceDefinition>();
                set.addAll(this.resolvedOpenNamespaces);
                set.addAll(additionalNamespaces);
                return set;
            }
            return this.resolvedOpenNamespaces;
        }

        public void addFullyResolvedNamespaceDefinitionDirective(ResolvedNamespaceDefinitionDirective resolvedDirective) {
            String baseName = resolvedDirective.getDirective().getBaseName();
            if (this.resolvedNamespaceDirectiveSymbolTable == null) {
                this.resolvedNamespaceDirectiveSymbolTable = new HashMap<String, List<ResolvedNamespaceDefinitionDirective>>();
                ArrayList<ResolvedNamespaceDefinitionDirective> directiveList = new ArrayList<ResolvedNamespaceDefinitionDirective>(1);
                directiveList.add(resolvedDirective);
                this.resolvedNamespaceDirectiveSymbolTable.put(baseName, directiveList);
            } else {
                List<ResolvedNamespaceDefinitionDirective> directiveList = this.resolvedNamespaceDirectiveSymbolTable.get(baseName);
                if (directiveList == null) {
                    directiveList = new ArrayList<ResolvedNamespaceDefinitionDirective>(1);
                    this.resolvedNamespaceDirectiveSymbolTable.put(baseName, directiveList);
                }
                directiveList.add(resolvedDirective);
            }
        }

        public NamespaceDefinition resolveDirectiveReference(INamespaceReference reference) {
            if (reference instanceof NamespaceDefinition) {
                return (NamespaceDefinition)reference;
            }
            assert (reference instanceof UserDefinedNamespaceReference) : "Unexpected implementation of INamespaceReference";
            UserDefinedNamespaceReference userDefinedNamespaceReference = (UserDefinedNamespaceReference)reference;
            String baseName = userDefinedNamespaceReference.getBaseName();
            INamespaceReference qualifier = userDefinedNamespaceReference.getQualifierNamespace();
            if (qualifier != null) {
                NamespaceDefinition resolvedQualifier = this.resolveDirectiveReference(qualifier);
                if (resolvedQualifier == null) {
                    return null;
                }
                return this.resolveQualifiedDirectiveReference(resolvedQualifier, baseName);
            }
            return this.resolveDirectiveReference(baseName);
        }

        private final NamespaceDefinition getResolvedNamespace(ICompilerProject project, IDefinition definition) {
            if (definition instanceof INamepaceDeclarationDirective) {
                definition = ((INamepaceDeclarationDirective)definition).resolveConcreteDefinition(project, this.forwardRefPred);
            }
            if (definition instanceof NamespaceDefinition) {
                return (NamespaceDefinition)definition;
            }
            return null;
        }

        private NamespaceDefinition resolveDirectiveReference(String baseName) {
            List<IDefinition> definitions = this.scope.findProperty((CompilerProject)this.project, baseName, (Predicate<IDefinition>)this.forwardRefPred, this.getResolvedOpenNamespaces(baseName), DependencyType.NAMESPACE);
            return definitions.size() == 1 ? this.getResolvedNamespace(this.project, definitions.get(0)) : null;
        }

        private NamespaceDefinition resolveQualifiedDirectiveReference(INamespaceDefinition resolvedQualifier, String baseName) {
            IDefinition definition = this.scope.findPropertyQualified(this.project, this.forwardRefPred, resolvedQualifier, baseName, DependencyType.NAMESPACE);
            return this.getResolvedNamespace(this.project, definition);
        }

        public void addResolvedUsedNamespace(NamespaceDefinition ns) {
            this.resolvedOpenNamespaces.add(ns);
        }

        private static final class ResolvedNamespaceDefinitionDirective {
            private final NamespaceDefinition resolvedQualifier;
            private final NamespaceDefinitionDirective directive;

            ResolvedNamespaceDefinitionDirective(NamespaceDefinition resolvedQualifier, NamespaceDefinitionDirective directive) {
                this.resolvedQualifier = resolvedQualifier;
                this.directive = directive;
            }

            public NamespaceDefinition getResolvedQualifier() {
                return this.resolvedQualifier;
            }

            public NamespaceDefinitionDirective getDirective() {
                return this.directive;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class NamespaceForwardReferencePredicate
        implements Predicate<IDefinition> {
            private SetMultimap<String, IDefinition> refLocations = HashMultimap.create();

            NamespaceForwardReferencePredicate copy() {
                NamespaceForwardReferencePredicate newPred = new NamespaceForwardReferencePredicate();
                newPred.refLocations = HashMultimap.create();
                newPred.refLocations.putAll(this.refLocations);
                return newPred;
            }

            void addRef(IDefinition source) {
                String sourcePath = source.getSourcePath();
                if (sourcePath != null) {
                    this.refLocations.put((Object)sourcePath, (Object)source);
                }
            }

            public boolean apply(IDefinition def) {
                String sourceFile;
                Set previousRefs;
                if (def != null && (previousRefs = this.refLocations.get((Object)(sourceFile = def.getSourcePath()))) != null) {
                    for (IDefinition d : previousRefs) {
                        if (!this.isForwardRef(d, def)) continue;
                        return false;
                    }
                }
                return true;
            }

            public boolean test(IDefinition input) {
                return this.apply(input);
            }

            private boolean isForwardRef(IDefinition from, IDefinition to) {
                IASScope toScope;
                if (to.getAbsoluteStart() < from.getAbsoluteStart()) {
                    return false;
                }
                IASScope fromScope = from.getContainingScope();
                if (fromScope == (toScope = to.getContainingScope())) {
                    return true;
                }
                for (IASScope current = fromScope; current != null; current = current.getContainingScope()) {
                    if (current != toScope) continue;
                    return false;
                }
                return !(toScope instanceof PackageScope);
            }
        }
    }

    private static final class UseNamespaceDirective
    extends UserDefinedNamespaceReference
    implements IUseNamespaceDirective {
        private INamespaceDirective next;

        private UseNamespaceDirective(ASScope scope, INamespaceDecorationNode node) {
            super(scope, node);
        }

        public INamespaceDirective getNext() {
            return this.next;
        }

        public void setNext(INamespaceDirective next) {
            this.next = next;
        }

        public void resolveDirective(NamespaceDirectiveResolver resolver) {
            NamespaceDefinition resolvedUsedNamespace = resolver.resolveDirectiveReference(this);
            resolver.addResolvedUsedNamespace(resolvedUsedNamespace);
        }

        public final INamespaceDefinition resolveNamespaceReference(ICompilerProject project) {
            assert (this.getScope() != null);
            return NamespaceDirectiveResolver.resolveNamespaceReferenceInDirective(project, this, this);
        }
    }

    private static class MemberNamespaceReference
    extends UserDefinedNamespaceReference {
        IReference baseRef = null;

        private MemberNamespaceReference(ASScope scope, IReference base, String baseName, INamespaceReference qualifier) {
            super(scope, baseName, qualifier);
            this.baseRef = base;
        }

        protected boolean needsForwardRefPredicate() {
            return this.def != null;
        }

        public INamespaceDefinition resolveNamespaceReference(ICompilerProject project) {
            INamespaceDefinition ns;
            ITypeDefinition baseType;
            ASScope scope = this.getScope();
            assert (this.getScope() != null);
            String baseName = this.getBaseName();
            IDefinition definition = null;
            IDefinition base = this.baseRef.resolve(project, scope, DependencyType.EXPRESSION, true);
            if (base != null && (baseType = base.resolveType(project)) != null) {
                definition = this.needsForwardRefPredicate() ? scope.getPropertyFromDef(project, (IDefinition)baseType, baseName, this.getForwardReferencePredicate(), false) : scope.getPropertyFromDef(project, baseType, baseName, false);
            }
            INamespaceDefinition iNamespaceDefinition = ns = definition instanceof INamespaceDefinition ? (INamespaceDefinition)definition : null;
            if (ns instanceof INamepaceDeclarationDirective) {
                ns = ((INamepaceDeclarationDirective)ns).resolveConcreteDefinition(project);
            }
            return ns;
        }
    }

    private static class UserDefinedNamespaceReference
    implements INamespaceResolvedReference {
        private ASScope scope;
        private String baseName;
        private INamespaceReference qualifierNamespace;
        protected IDefinition def;

        private static INamespaceReference getQualifierNamespaceIfExists(ASScope scope, INamespaceDecorationNode node) {
            if (!(node instanceof QualifiedNamespaceExpressionNode)) {
                return null;
            }
            QualifiedNamespaceExpressionNode qNode = (QualifiedNamespaceExpressionNode)node;
            IIdentifierNode prefix = (IIdentifierNode)qNode.getLeftOperandNode();
            Workspace w = (Workspace)scope.getWorkspace();
            INamespaceDefinition.ILanguageNamespaceDefinition qualifedNamespace = w.getPackageNamespaceDefinitionCache().get(prefix.getName(), false);
            return qualifedNamespace;
        }

        private UserDefinedNamespaceReference(ASScope scope, INamespaceDecorationNode node) {
            this(scope, NamespaceDefinition.getBaseName(node), UserDefinedNamespaceReference.getQualifierNamespaceIfExists(scope, node));
        }

        private UserDefinedNamespaceReference(ASScope scope, String baseName, INamespaceReference qualifier) {
            assert (scope != null);
            this.scope = scope;
            this.baseName = baseName;
            this.qualifierNamespace = qualifier;
        }

        public final boolean isPublicOrInternalNamespace() {
            return false;
        }

        public final String getBaseName() {
            return this.baseName;
        }

        public final INamespaceReference getQualifierNamespace() {
            return this.qualifierNamespace;
        }

        public final boolean isLanguageNamespace() {
            return false;
        }

        public INamespaceDefinition resolveNamespaceReference(ICompilerProject project) {
            INamespaceDefinition ns;
            assert (this.scope != null);
            IDefinition definition = null;
            if (this.qualifierNamespace != null) {
                INamespaceDefinition qualifier = this.qualifierNamespace.resolveNamespaceReference(project);
                if (qualifier != null) {
                    definition = this.needsForwardRefPredicate() ? this.scope.findPropertyQualified(project, this.getForwardReferencePredicate(), qualifier, this.baseName, DependencyType.NAMESPACE) : this.scope.findPropertyQualified(project, qualifier, this.baseName, DependencyType.NAMESPACE);
                }
            } else {
                definition = this.needsForwardRefPredicate() ? this.scope.findProperty(project, this.baseName, (Predicate<IDefinition>)this.getForwardReferencePredicate(), DependencyType.NAMESPACE, true) : this.scope.findProperty(project, this.baseName, DependencyType.NAMESPACE);
            }
            INamespaceDefinition iNamespaceDefinition = ns = definition instanceof INamespaceDefinition ? (INamespaceDefinition)definition : null;
            if (ns instanceof INamepaceDeclarationDirective) {
                ns = ((INamepaceDeclarationDirective)ns).resolveConcreteDefinition(project);
            }
            return ns;
        }

        protected boolean needsForwardRefPredicate() {
            if (this.def != null) {
                return this.scope.getFirstNamespaceDirective() != null || this.scope.getLocalDefinitionSetByName(this.baseName) != null;
            }
            return false;
        }

        protected NamespaceDirectiveResolver.NamespaceForwardReferencePredicate getForwardReferencePredicate() {
            NamespaceDirectiveResolver.NamespaceForwardReferencePredicate pred = new NamespaceDirectiveResolver.NamespaceForwardReferencePredicate();
            pred.addRef(this.def);
            return pred;
        }

        public void setContainingDefinition(IDefinition d) {
            this.def = d;
        }

        public final boolean equals(Object o) {
            assert (false);
            if (o == this) {
                return true;
            }
            if (o instanceof UserDefinedNamespaceReference) {
                UserDefinedNamespaceReference other = (UserDefinedNamespaceReference)o;
                if (other.baseName.equals(this.baseName)) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.qualifierNamespace != null) {
                sb.append(this.qualifierNamespace.toString());
                sb.append(':');
                sb.append(':');
            }
            sb.append(this.baseName);
            return sb.toString();
        }

        public final Namespace resolveAETNamespace(ICompilerProject project) {
            INamespaceDefinition def = this.resolveNamespaceReference(project);
            assert (def == null || def instanceof NamespaceDefinition);
            if (def instanceof NamespaceDefinition) {
                NamespaceDefinition concreteDef = (NamespaceDefinition)def;
                return concreteDef.getAETNamespace();
            }
            return null;
        }

        protected final ASScope getScope() {
            return this.scope;
        }
    }

    private static final class NamespaceDefinitionDirective
    extends UserDefinedNamespaceDefinition
    implements INamepaceDeclarationDirective {
        private INamespaceDirective next;
        private UserDefinedNamespaceReference initializer;

        private NamespaceDefinitionDirective(INamespaceReference qualifierNamespaceRef, IASScope scope, String name, String uri, INamespaceReference initializer) {
            super(qualifierNamespaceRef, scope, name, uri);
            if (initializer != null) {
                assert (initializer instanceof UserDefinedNamespaceReference);
                this.initializer = (UserDefinedNamespaceReference)initializer;
                this.initializer.setContainingDefinition(this);
            }
        }

        public INamespaceDirective getNext() {
            return this.next;
        }

        public void setNext(INamespaceDirective next) {
            this.next = next;
        }

        public void resolveDirective(NamespaceDirectiveResolver resolver) {
            NamespaceDefinition resolvedQualifier = resolver.resolveDirectiveReference(this.getNamespaceReference());
            NamespaceDirectiveResolver.ResolvedNamespaceDefinitionDirective resolvedDirective = new NamespaceDirectiveResolver.ResolvedNamespaceDefinitionDirective(resolvedQualifier, this);
            resolver.addFullyResolvedNamespaceDefinitionDirective(resolvedDirective);
        }

        public Namespace resolveAETNamespace(ICompilerProject project) {
            NamespaceDirectiveResolver.NamespaceForwardReferencePredicate pred = new NamespaceDirectiveResolver.NamespaceForwardReferencePredicate();
            pred.addRef(this);
            return this.resolveAETNamespace(project, pred);
        }

        protected String getNamespaceReferenceAsString() {
            return super.getNamespaceReferenceAsString();
        }

        public Namespace resolveAETNamespace(ICompilerProject project, NamespaceDirectiveResolver.NamespaceForwardReferencePredicate pred) {
            if (this.initializer != null) {
                INamespaceDefinition ns = NamespaceDirectiveResolver.resolveNamespaceReferenceInDirective(project, this.initializer, this, pred);
                if (ns instanceof NamespaceDefinition) {
                    return ((NamespaceDefinition)ns).resolveAETNamespace(project);
                }
                return null;
            }
            return super.resolveAETNamespace(project);
        }

        public INamespaceDefinition resolveConcreteDefinition(ICompilerProject project) {
            return this.resolveConcreteDefinition(project, new NamespaceDirectiveResolver.NamespaceForwardReferencePredicate());
        }

        public INamespaceDefinition resolveConcreteDefinition(ICompilerProject project, NamespaceDirectiveResolver.NamespaceForwardReferencePredicate pred) {
            if (this.initializer != null) {
                Namespace aetNamespace = this.resolveAETNamespace(project, pred);
                if (aetNamespace != null) {
                    return new UserDefinedNamespaceDefinition("", aetNamespace);
                }
                return null;
            }
            return this;
        }
    }

    private static class UserDefinedNamespaceDefinition
    extends NamespaceDefinition {
        private static String generateQualifierPrefixString(IASScope containingScope, INamespaceReference qualifierNamespaceRef) {
            if (!(qualifierNamespaceRef instanceof INamespaceDefinition)) {
                return qualifierNamespaceRef.getBaseName() + ":";
            }
            if (qualifierNamespaceRef instanceof INamespaceDefinition.IFilePrivateNamespaceDefinition) {
                ASFileScope containingFileScope = ((ASScope)containingScope).getFileScope();
                assert (containingFileScope != null);
                return UserDefinedNamespaceDefinition.generateQualifierPrefixStringForFilePrivate(qualifierNamespaceRef.getBaseName(), containingFileScope) + ":";
            }
            if (qualifierNamespaceRef instanceof INamespaceDefinition.IPrivateNamespaceDefinition) {
                return "private:";
            }
            INamespaceDefinition qualifierNamespace = (INamespaceDefinition)((Object)qualifierNamespaceRef);
            String uri = qualifierNamespace.getURI();
            if (uri.isEmpty()) {
                return "";
            }
            return uri + ":";
        }

        private static String generateQualifierPrefixStringForFilePrivate(String baseName, ASFileScope fileScope) {
            String sourcePath = fileScope.getContainingPath();
            String dirName = FilenameUtils.getPathNoEndSeparator((String)sourcePath);
            String md5String = StringEncoder.stringToMD5String(dirName);
            return FilenameUtils.getName((String)baseName) + "$" + md5String;
        }

        private static IDefinition getContaininDefinition(IASScope scope) {
            while (scope != null) {
                if (scope instanceof PackageScope) {
                    return null;
                }
                IScopedDefinition result = scope.getDefinition();
                if (result != null) {
                    return result;
                }
                scope = scope.getContainingScope();
            }
            return null;
        }

        private static String generateSpecialCaseFunctionURIPrefix(IDefinition definition) {
            String baseName = null;
            if (!(definition instanceof FunctionDefinition)) {
                return null;
            }
            FunctionDefinition functionDefinition = (FunctionDefinition)definition;
            FunctionNode functionNode = (FunctionNode)functionDefinition.getNode();
            if (functionNode == null) {
                return null;
            }
            if (functionNode.isConstructor()) {
                baseName = "$construct/";
            } else if (functionNode.getParent() instanceof FunctionObjectNode) {
                String functionName = functionDefinition.getBaseName();
                baseName = functionName.isEmpty() ? "anonymous/" : functionName + "/";
            } else {
                return null;
            }
            assert (baseName != null);
            return UserDefinedNamespaceDefinition.generateURI(PUBLIC, definition.getContainingScope(), baseName);
        }

        private static String generateURI(INamespaceReference qualifierNamespaceRef, IASScope containingScope, String baseName) {
            IDefinition containingDef = UserDefinedNamespaceDefinition.getContaininDefinition(containingScope);
            String prefix = "";
            if (containingDef != null) {
                String specialCaseFunctionPrefix = UserDefinedNamespaceDefinition.generateSpecialCaseFunctionURIPrefix(containingDef);
                prefix = specialCaseFunctionPrefix != null ? specialCaseFunctionPrefix : UserDefinedNamespaceDefinition.generateURI(containingDef.getNamespaceReference(), containingDef.getContainingScope(), containingDef.getBaseName()) + "/";
            }
            String uri = UserDefinedNamespaceDefinition.generateQualifierPrefixString(containingScope, qualifierNamespaceRef) + baseName;
            return prefix + uri;
        }

        private UserDefinedNamespaceDefinition(INamespaceReference qualifierNamespaceRef, IASScope containingScope, String name, String uri) {
            super(name, uri != null ? 8 : 23, uri != null ? uri : UserDefinedNamespaceDefinition.generateURI(qualifierNamespaceRef, containingScope, name));
            this.setNamespaceReference(qualifierNamespaceRef);
        }

        private UserDefinedNamespaceDefinition(String name, String uri) {
            super(name, 8, uri);
            assert (uri != null);
        }

        private UserDefinedNamespaceDefinition(String name, Namespace ns) {
            super(name, ns);
            assert (ns.getKind() == 8 || ns.getKind() == 23);
        }

        public Namespace resolveAETNamespace(ICompilerProject project) {
            return this.getAETNamespace();
        }

        public INamespaceDefinition.NamespaceClassification getNamespaceClassification() {
            IDefinition parent = this.getParent();
            if (parent instanceof IFunctionDefinition) {
                return INamespaceDefinition.NamespaceClassification.LOCAL;
            }
            if (parent instanceof IClassDefinition) {
                return INamespaceDefinition.NamespaceClassification.CLASS_MEMBER;
            }
            if (parent instanceof IPackageDefinition) {
                return INamespaceDefinition.NamespaceClassification.PACKAGE_MEMBER;
            }
            if (parent == null) {
                if (this.getNamespaceReference() != null && this.inPackageNamespace()) {
                    return INamespaceDefinition.NamespaceClassification.PACKAGE_MEMBER;
                }
                return INamespaceDefinition.NamespaceClassification.FILE_MEMBER;
            }
            return null;
        }

        protected void buildInnerString(StringBuilder sb) {
            sb.append(this.getURI());
        }
    }

    private static final class CodeModelImplicitDefinitionNamespaceDefinition
    extends LanguageNamespaceDefinition
    implements INamespaceDefinition.ICodeModelImplicitDefinitionNamespaceDefinition {
        private CodeModelImplicitDefinitionNamespaceDefinition() {
            super("", 5, "CodeModelImplicitDefinitionsNS");
        }

        public Namespace getAETNamespace() {
            return new Namespace(5, "<invalid-namespace>");
        }
    }

    private static final class InterfaceNamespaceDefinition
    extends LanguageNamespaceDefinition
    implements INamespaceDefinition.IInterfaceNamespaceDefinition {
        private InterfaceNamespaceDefinition(InterfaceDefinition interf) {
            super("public", 8, interf.generateInterfaceURI());
        }

        private InterfaceNamespaceDefinition(Namespace ns) {
            super("public", ns);
            assert (ns.getKind() == 5);
        }
    }

    private static class AnyNamespaceDefinition
    extends LanguageNamespaceDefinition
    implements INamespaceDefinition.IAnyNamespaceDefinition {
        private AnyNamespaceDefinition() {
            super("*", 5, "*");
        }

        public Namespace getAETNamespace() {
            assert (false) : "Can't get the Namespace for the any namespace!";
            return null;
        }
    }

    private static final class InternalNamespaceDefinition
    extends LanguageNamespaceDefinition
    implements INamespaceDefinition.IInternalNamespaceDefinition {
        private InternalNamespaceDefinition(String owningPackage) {
            super("internal", 23, owningPackage);
        }

        private InternalNamespaceDefinition(Namespace ns) {
            super("internal", ns);
            assert (ns.getKind() == 23);
        }

        public boolean isPublicOrInternalNamespace() {
            return true;
        }

        public String getGeneratedURIPrefix() {
            return this.getURI() + ":";
        }

        public String getNamespacePackageName() {
            return this.getURI();
        }
    }

    private static final class StaticProtectedNamespaceDefinition
    extends LanguageNamespaceDefinition
    implements INamespaceDefinition.IStaticProtectedNamespaceDefinition {
        private StaticProtectedNamespaceDefinition(String uri) {
            super("protected", 26, uri);
        }

        private StaticProtectedNamespaceDefinition(Namespace ns) {
            super("protected", ns);
            assert (ns.getKind() == 26);
        }
    }

    private static final class ProtectedNamespaceDefinition
    extends LanguageNamespaceDefinition
    implements INamespaceDefinition.IProtectedNamespaceDefinition {
        private ProtectedNamespaceDefinition(String uri) {
            super("protected", 24, uri);
        }

        private ProtectedNamespaceDefinition(Namespace ns) {
            super("protected", ns);
            assert (ns.getKind() == 24);
        }
    }

    private static final class FilePrivateNamespaceDefinition
    extends PrivateNamespaceDefinition
    implements INamespaceDefinition.IFilePrivateNamespaceDefinition {
        private FilePrivateNamespaceDefinition(String uri) {
            super(uri);
        }

        public String getGeneratedURIPrefix() {
            return this.getURI() + ":";
        }

        public String getNamespacePackageName() {
            return "";
        }
    }

    private static class PrivateNamespaceDefinition
    extends LanguageNamespaceDefinition
    implements INamespaceDefinition.IPrivateNamespaceDefinition {
        private PrivateNamespaceDefinition(String uri) {
            super("private", 5, uri);
        }

        private PrivateNamespaceDefinition(Namespace ns) {
            super("private", ns);
            assert (ns.getKind() == 5);
        }
    }

    private static final class PublicNamespaceDefinition
    extends LanguageNamespaceDefinition
    implements INamespaceDefinition.IPublicNamespaceDefinition {
        private PublicNamespaceDefinition() {
            this("");
        }

        private PublicNamespaceDefinition(String packageName) {
            super("public", 22, packageName);
            this.setPublic();
        }

        private PublicNamespaceDefinition(Namespace ns) {
            super("public", ns);
            this.setPublic();
            assert (ns.getKind() == 22);
        }

        public boolean isPublicOrInternalNamespace() {
            return true;
        }

        public String getGeneratedURIPrefix() {
            String uri = this.getURI();
            if (uri.length() == 0) {
                return "";
            }
            return uri + ":";
        }

        public String getNamespacePackageName() {
            return this.getURI();
        }
    }

    private static abstract class LanguageNamespaceDefinition
    extends NamespaceDefinition
    implements INamespaceDefinition.ILanguageNamespaceDefinition {
        private LanguageNamespaceDefinition(String name, int kind, String uri) {
            super(name, kind, uri);
            this.setImplicit();
        }

        private LanguageNamespaceDefinition(String name, Namespace ns) {
            super(name, ns);
            this.setImplicit();
        }

        public boolean isLanguageNamespace() {
            return true;
        }

        public Namespace resolveAETNamespace(ICompilerProject project) {
            return this.getAETNamespace();
        }

        public INamespaceDefinition.NamespaceClassification getNamespaceClassification() {
            return INamespaceDefinition.NamespaceClassification.LANGUAGE;
        }

        public IFileSpecification getFileSpecification() {
            return null;
        }

        public int getStart() {
            return -1;
        }

        public int getNameStart() {
            return -1;
        }

        public int getNameEnd() {
            return -1;
        }

        public String getContainingFilePath() {
            return null;
        }

        public String getContainingSourceFilePath(ICompilerProject project) {
            return null;
        }

        public ASFileScope getFileScope() {
            return null;
        }

        protected void buildInnerString(StringBuilder sb) {
            sb.append(this.getBaseName());
            sb.append('(');
            sb.append(this.getURI());
            sb.append(')');
        }

        public final String getPackageName() {
            return "";
        }
    }

    public static interface IUseNamespaceDirective
    extends INamespaceDirective,
    INamespaceReference {
    }

    public static interface INamepaceDeclarationDirective
    extends INamespaceDirective,
    INamespaceDefinition {
        public INamespaceDefinition resolveConcreteDefinition(ICompilerProject var1);

        public INamespaceDefinition resolveConcreteDefinition(ICompilerProject var1, NamespaceDirectiveResolver.NamespaceForwardReferencePredicate var2);
    }

    public static interface INamespaceDirective {
        public INamespaceDirective getNext();

        public void setNext(INamespaceDirective var1);

        public void resolveDirective(NamespaceDirectiveResolver var1);
    }
}

