/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.royale.compiler.css.ICSSProperty;
import org.apache.royale.compiler.css.ICSSPropertyValue;
import org.apache.royale.compiler.internal.css.CSSArrayPropertyValue;
import org.apache.royale.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.CSSNodeBase;
import org.apache.royale.compiler.internal.css.CSSPropertyValue;
import org.apache.royale.compiler.internal.css.CSSStringPropertyValue;

public class CSSProperty
extends CSSNodeBase
implements ICSSProperty {
    private final String normalizedName;
    private final String rawName;
    private final CSSPropertyValue value;

    protected CSSProperty(String name, CSSPropertyValue value, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.PROPERTY);
        assert (!Strings.isNullOrEmpty((String)name)) : "CSS property name can't be empty.";
        assert (value != null) : "CSS property name can't be null.";
        this.rawName = name;
        this.normalizedName = CSSProperty.normalize(name);
        this.value = value;
    }

    public String getName() {
        return this.normalizedName;
    }

    public ICSSPropertyValue getValue() {
        return this.value;
    }

    public String toString() {
        if (this.rawName.equalsIgnoreCase("border") && this.value instanceof CSSArrayPropertyValue) {
            CSSArrayPropertyValue borderValues = (CSSArrayPropertyValue)this.value;
            return String.format("%s: %s;", this.rawName, Joiner.on((String)" ").join(borderValues.getElements()));
        }
        return String.format("%s: %s;", this.rawName, this.value.toString());
    }

    public String toCSSString() {
        String cssName = this.rawName;
        if (!this.rawName.equals(this.rawName.toLowerCase())) {
            cssName = cssName.replaceAll("[A-Z]", "-$0").toLowerCase();
        }
        if (cssName.equals("content") && this.value instanceof CSSStringPropertyValue) {
            return String.format("%s: \"%s\";", cssName, this.escape(((CSSStringPropertyValue)this.value).getValue()));
        }
        if (this.value instanceof CSSStringPropertyValue) {
            return String.format("%s: %s;", cssName, ((CSSStringPropertyValue)this.value).getValue());
        }
        if (this.value instanceof CSSFunctionCallPropertyValue) {
            return String.format("%s: %s;", cssName, ((CSSFunctionCallPropertyValue)this.value).toString());
        }
        return String.format("%s: %s;", cssName, this.value.toString());
    }

    protected static String normalize(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean lastCharIsHyphen = false;
        boolean isFirstChar = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('-' == c) {
                lastCharIsHyphen = true;
                continue;
            }
            if (lastCharIsHyphen) {
                result.append(Character.toUpperCase(c));
                lastCharIsHyphen = false;
                continue;
            }
            if (isFirstChar) {
                result.append(Character.toLowerCase(c));
                isFirstChar = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private String escape(String content) {
        if (content.length() == 1 && content.codePointAt(0) > 255) {
            int code = content.codePointAt(0);
            content = Integer.toHexString(code);
            return "\\" + content;
        }
        return content;
    }
}

