/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.as.codegen;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.visitors.IABCVisitor;
import org.apache.royale.abc.visitors.ITraitVisitor;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.as.codegen.ClassDirectiveProcessor;
import org.apache.royale.compiler.internal.as.codegen.DirectiveProcessor;
import org.apache.royale.compiler.internal.as.codegen.GenerateFunctionInParallelResult;
import org.apache.royale.compiler.internal.as.codegen.InterfaceDirectiveProcessor;
import org.apache.royale.compiler.internal.as.codegen.LexicalScope;
import org.apache.royale.compiler.internal.as.codegen.MXMLClassDirectiveProcessor;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.InterfaceNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.PackageNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLDocumentNode;
import org.apache.royale.compiler.problems.AbstractOutsideClassProblem;
import org.apache.royale.compiler.problems.DynamicNotOnClassProblem;
import org.apache.royale.compiler.problems.EmbedOnlyOnClassesAndVarsProblem;
import org.apache.royale.compiler.problems.FinalOutsideClassProblem;
import org.apache.royale.compiler.problems.GlobalBindablePropertyProblem;
import org.apache.royale.compiler.problems.InterfaceModifierProblem;
import org.apache.royale.compiler.problems.NativeNotOnFunctionProblem;
import org.apache.royale.compiler.problems.NativeVariableProblem;
import org.apache.royale.compiler.problems.OverrideOutsideClassProblem;
import org.apache.royale.compiler.problems.StaticOutsideClassProblem;
import org.apache.royale.compiler.problems.SyntaxProblem;
import org.apache.royale.compiler.problems.VirtualOutsideClassProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDocumentNode;

class GlobalDirectiveProcessor
extends DirectiveProcessor {
    InstructionList directiveInsns = new InstructionList();
    protected LexicalScope currentScope;
    protected IABCVisitor emitter;
    protected boolean processingPackage = false;
    private final List<GenerateFunctionInParallelResult> parallelCodeGenList;
    private final ExecutorService executorService;
    private final boolean useParallelCodeGen;

    GlobalDirectiveProcessor(LexicalScope current_scope, IABCVisitor emitter) {
        this(null, false, current_scope, emitter);
    }

    GlobalDirectiveProcessor(ExecutorService executorService, boolean useParallelCodeGen, LexicalScope current_scope, IABCVisitor emitter) {
        super(current_scope.getProblems());
        assert (!useParallelCodeGen || executorService != null) : "Parallel code generation requires access to an ExecutorService";
        this.currentScope = current_scope;
        this.emitter = emitter;
        this.parallelCodeGenList = new LinkedList<GenerateFunctionInParallelResult>();
        this.executorService = executorService;
        this.useParallelCodeGen = useParallelCodeGen;
    }

    private MethodInfo startFunctionGeneration(FunctionNode f) {
        if (this.useParallelCodeGen) {
            assert (this.executorService != null) : "Parallel codegen requires an ExecutorService!";
            GenerateFunctionInParallelResult parallelCodeGen = this.currentScope.getGenerator().generateFunctionInParallel(this.executorService, f, this.currentScope);
            this.parallelCodeGenList.add(parallelCodeGen);
            return parallelCodeGen.getMethodInfo();
        }
        f.parseFunctionBody(this.currentScope.getProblems());
        return this.currentScope.getGenerator().generateFunction(f, this.currentScope, null, null);
    }

    void declareFunction(FunctionNode f) {
        this.verifyFunctionModifiers(f);
        MethodInfo mi = this.startFunctionGeneration(f);
        if (mi != null) {
            ICompilerProject project;
            List<IDefinition> defs;
            int traitKind;
            FunctionDefinition funcDef = f.getDefinition();
            Name funcName = funcDef.getMName(this.currentScope.getProject());
            SemanticUtils.checkScopedToDefaultNamespaceProblem(this.currentScope, f, funcDef, null);
            boolean conflictsWithOtherDefinition = false;
            if (funcName == null) {
                funcName = new Name("<invalid>");
            } else {
                conflictsWithOtherDefinition = this.currentScope.getMethodBodySemanticChecker().checkFunctionForConflictingDefinitions(f, funcDef);
            }
            ITraitVisitor tv = null;
            int n = traitKind = this.processingPackage ? DirectiveProcessor.functionTraitKind(f, 1) : DirectiveProcessor.functionTraitKind(f, 0);
            if (!this.currentScope.traitsVisitor.getTraits().containsTrait(traitKind, funcName)) {
                this.currentScope.declareVariableName(funcName);
                if (!this.processingPackage) {
                    if (f.isGetter() || f.isSetter()) {
                        tv = this.currentScope.traitsVisitor.visitMethodTrait(traitKind, funcName, 0, mi);
                        assert (tv != null) : "visitMethodTrait should never return null!";
                    } else {
                        tv = this.currentScope.traitsVisitor.visitSlotTrait(traitKind, funcName, 0, LexicalScope.anyType, LexicalScope.noInitializer);
                        assert (tv != null) : "visitSlotTrait should never return null!";
                        this.currentScope.getInitInstructions().addInstruction(100);
                        this.currentScope.getInitInstructions().addInstruction(64, mi);
                        this.currentScope.getInitInstructions().addInstruction(97, funcName);
                    }
                } else {
                    tv = this.currentScope.traitsVisitor.visitMethodTrait(traitKind, funcName, 0, mi);
                    assert (tv != null) : "visitMethodTrait should never return null!";
                }
                if (tv != null) {
                    this.currentScope.processMetadata(tv, funcDef.getAllMetaTags());
                    tv.visitEnd();
                }
            } else if (!(conflictsWithOtherDefinition || SemanticUtils.isGetterSetterPair(defs = SemanticUtils.findPotentialFunctionConflicts(project = this.currentScope.getProject(), funcDef), project) || this.processingPackage || f.isGetter() || f.isSetter())) {
                this.currentScope.getInitInstructions().addInstruction(100);
                this.currentScope.getInitInstructions().addInstruction(64, mi);
                this.currentScope.getInitInstructions().addInstruction(97, funcName);
            }
        }
    }

    protected void verifyFunctionModifiers(FunctionNode f) {
        ModifiersSet modifiersSet = f.getModifiers();
        if (modifiersSet == null) {
            return;
        }
        ASModifier[] modifiers = modifiersSet.getAllModifiers();
        IExpressionNode site = f.getNameExpressionNode();
        for (ASModifier modifier : modifiers) {
            this.verifyModifier(site, modifier);
        }
        this.currentScope.getMethodBodySemanticChecker().checkForDuplicateModifiers(f);
    }

    protected void verifyVariableModifiers(VariableNode v) {
        ModifiersSet modifiersSet = v.getModifiers();
        if (modifiersSet == null) {
            return;
        }
        ASModifier[] modifiers = modifiersSet.getAllModifiers();
        IExpressionNode site = v.getNameExpressionNode();
        for (ASModifier modifier : modifiers) {
            if (modifier == ASModifier.NATIVE) {
                this.currentScope.addProblem(new NativeVariableProblem(site));
                continue;
            }
            if (modifier == ASModifier.DYNAMIC) {
                this.currentScope.addProblem(new DynamicNotOnClassProblem(site));
                continue;
            }
            this.verifyModifier(site, modifier);
        }
        this.currentScope.getMethodBodySemanticChecker().checkForDuplicateModifiers(v);
    }

    protected void verifyClassModifiers(ClassNode c) {
        ClassDefinition classDef;
        IExpressionNode site = c.getNameExpressionNode();
        ModifiersSet modifiersSet = c.getModifiers();
        if (modifiersSet != null) {
            ASModifier[] modifiers;
            for (ASModifier modifier : modifiers = modifiersSet.getAllModifiers()) {
                if (modifier == ASModifier.FINAL || modifier == ASModifier.DYNAMIC || modifier == ASModifier.ABSTRACT) continue;
                if (modifier == ASModifier.NATIVE) {
                    this.currentScope.addProblem(new NativeNotOnFunctionProblem(site));
                    continue;
                }
                this.verifyModifier(site, modifier);
            }
            this.currentScope.getMethodBodySemanticChecker().checkForDuplicateModifiers(c);
        }
        if ((classDef = c.getDefinition()).isAbstract()) {
            if (this.currentScope.getProject().getAllowAbstractClasses()) {
                if (!SemanticUtils.canBeAbstract(c, this.currentScope.getProject())) {
                    this.currentScope.addProblem(new AbstractOutsideClassProblem(site));
                }
            } else {
                this.currentScope.addProblem(new SyntaxProblem(site, "abstract"));
            }
        }
    }

    protected void verifySkinning(ClassDefinition classDefinition) {
        classDefinition.getSkinParts(this.currentScope.getProblems());
        classDefinition.getSkinStates(this.currentScope.getProblems());
        classDefinition.verifyHostComponent((CompilerProject)this.currentScope.getProject(), this.currentScope.getProblems());
    }

    protected void verifyInterfaceModifiers(InterfaceNode i) {
        ModifiersSet modifiersSet = i.getModifiers();
        if (modifiersSet == null) {
            return;
        }
        ASModifier[] modifiers = modifiersSet.getAllModifiers();
        IExpressionNode site = i.getNameExpressionNode();
        for (ASModifier modifier : modifiers) {
            if (modifier == ASModifier.FINAL || modifier == ASModifier.DYNAMIC) {
                this.currentScope.addProblem(new InterfaceModifierProblem(site, modifier.toString()));
                continue;
            }
            if (modifier == ASModifier.NATIVE) {
                this.currentScope.addProblem(new NativeNotOnFunctionProblem(site));
                this.currentScope.addProblem(new InterfaceModifierProblem(site, modifier.toString()));
                continue;
            }
            this.verifyModifier(site, modifier);
        }
        this.currentScope.getMethodBodySemanticChecker().checkForDuplicateModifiers(i);
    }

    protected void verifyModifier(IASNode site, ASModifier modifier) {
        if (modifier == ASModifier.STATIC) {
            this.currentScope.addProblem(new StaticOutsideClassProblem(site));
        } else if (modifier == ASModifier.FINAL) {
            this.currentScope.addProblem(new FinalOutsideClassProblem(site));
        } else if (modifier == ASModifier.OVERRIDE) {
            this.currentScope.addProblem(new OverrideOutsideClassProblem(site));
        } else if (modifier == ASModifier.VIRTUAL) {
            this.currentScope.addProblem(new VirtualOutsideClassProblem(site));
        } else if (modifier == ASModifier.ABSTRACT) {
            if (this.currentScope.getProject().getAllowAbstractClasses()) {
                this.currentScope.addProblem(new AbstractOutsideClassProblem(site));
            } else {
                this.currentScope.addProblem(new SyntaxProblem(site, "abstract"));
            }
        }
    }

    void declareClass(ClassNode c) {
        this.verifyClassModifiers(c);
        this.verifySkinning(c.getDefinition());
        this.currentScope.getMethodBodySemanticChecker().checkNamespaceOfDefinition(c, c.getDefinition(), this.currentScope.getProject());
        if (c.getDefinition().getConstructor().isImplicit()) {
            this.currentScope.getMethodBodySemanticChecker().checkDefaultSuperCall(c.getDefinition().getConstructor().getNode());
        }
        ClassDirectiveProcessor cp = new ClassDirectiveProcessor(c, this.currentScope, this.emitter);
        cp.traverse(c.getScopedNode());
        cp.finishClassDefinition();
    }

    void declareInterface(InterfaceNode interface_ast) {
        this.verifyInterfaceModifiers(interface_ast);
        this.currentScope.getMethodBodySemanticChecker().checkNamespaceOfDefinition(interface_ast, interface_ast.getDefinition(), this.currentScope.getProject());
        InterfaceDirectiveProcessor ip = new InterfaceDirectiveProcessor(interface_ast, this.currentScope, this.emitter);
        ip.traverse(interface_ast.getScopedNode());
        ip.finishInterfaceDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void declarePackage(PackageNode p) {
        try {
            this.processingPackage = true;
            this.traverse(p.getScopedNode());
            Object var3_2 = null;
            this.processingPackage = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.processingPackage = false;
            throw throwable;
        }
    }

    void declareVariable(VariableNode var) {
        this.verifyVariableModifiers(var);
        if (var.getMetaTags() != null && var.getMetaTags().hasTagByName("Embed")) {
            this.currentScope.addProblem(new EmbedOnlyOnClassesAndVarsProblem(var));
        }
        DefinitionBase varDef = var.getDefinition();
        SemanticUtils.checkScopedToDefaultNamespaceProblem(this.currentScope, var, varDef, null);
        if (var.hasModifier(ASModifier.STATIC)) {
            ICompilerProject project = this.currentScope.getProject();
            Name var_name = varDef.getMName(project);
            TypeDefinitionBase typeDef = varDef.resolveType(project);
            Name var_type = typeDef != null ? typeDef.getMName(project) : null;
            ITraitVisitor tv = this.currentScope.traitsVisitor.visitSlotTrait(6, var_name, 0, var_type, LexicalScope.noInitializer);
            this.currentScope.declareVariableName(var_name);
            this.currentScope.processMetadata(tv, varDef.getAllMetaTags());
            tv.visitEnd();
        }
        this.processDirective(var);
    }

    void declareBindableVariable(VariableNode var) {
        this.currentScope.addProblem(new GlobalBindablePropertyProblem(var));
    }

    void declareMXMLDocument(IMXMLDocumentNode d) {
        MXMLClassDirectiveProcessor dp;
        this.verifySkinning((ClassDefinition)d.getDefinition());
        ((MXMLDocumentNode)d).cdp = dp = new MXMLClassDirectiveProcessor(d, this.currentScope, this.emitter);
        dp.processMainClassDefinitionNode(d);
        dp.finishClassDefinition();
    }

    void processNamespaceIdentifierDirective(NamespaceIdentifierNode ns) {
        this.traverse(ns);
    }

    void processDirective(IASNode n) {
        InstructionList stmt_insns = this.currentScope.getGenerator().generateInstructions(n, 13, this.currentScope);
        if (stmt_insns != null) {
            this.directiveInsns.addAll(stmt_insns);
        }
    }

    void finish() throws InterruptedException {
        try {
            for (GenerateFunctionInParallelResult parallelCodeGen : this.parallelCodeGenList) {
                parallelCodeGen.finish();
            }
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }
}

