/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.semantics;

import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.Label;

public class OneOperandInstruction
extends Instruction {
    public Object operand;

    public OneOperandInstruction(int opcode, Object operand) {
        super(opcode);
        this.operand = operand;
    }

    public OneOperandInstruction(int opcode) {
        super(opcode);
        assert (this.isTargetableInstruction()) : String.format("Invalid deferred operand type %s", super.toString());
    }

    public String toString() {
        return String.format("%s[%s]", super.toString(), this.operand);
    }

    public int getOperandCount() {
        return 1;
    }

    public boolean hasOperands() {
        return true;
    }

    public Object getOperand(int index) {
        assert (index == 0) : String.format("%s only has one operand, requested %d", super.toString(), index);
        return this.operand;
    }

    public Label getTarget() {
        return this.operand instanceof Label ? (Label)this.operand : null;
    }

    public void setTarget(Label target) {
        assert (this.operand == null) : String.format("%s target already set", this);
        this.operand = target;
    }
}

