/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.semantics;

import org.apache.royale.abc.semantics.Instruction;

public class ImmediateOperandInstruction
extends Instruction {
    public static final boolean allowAnyDeferredIntermediate = false;
    private int immediate;

    public ImmediateOperandInstruction(int opcode, int immediate) {
        super(opcode);
        this.immediate = immediate;
    }

    public ImmediateOperandInstruction(int opcode) {
        super(opcode);
        this.verifyDeferredImmediate("%s requires an immediate operand.");
    }

    public String toString() {
        return String.format("%s(%d)", super.toString(), this.immediate);
    }

    public int getImmediate() {
        return this.immediate;
    }

    public boolean isImmediate() {
        return true;
    }

    public void setImmediate(int immediate) {
        this.verifyDeferredImmediate("Cannot set immediate field on %s");
        this.immediate = immediate;
    }

    private void verifyDeferredImmediate(String diagnostic) {
        switch (this.opcode) {
            case 8: 
            case 31: 
            case 98: 
            case 99: 
            case 146: 
            case 148: 
            case 194: 
            case 195: {
                break;
            }
            default: {
                assert (false) : String.format(diagnostic, this.toString());
                break;
            }
        }
    }
}

