/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.royale;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.asdoc.IASDocTag;
import org.apache.royale.compiler.asdoc.royale.ASDocComment;
import org.apache.royale.compiler.codegen.js.royale.IJSRoyaleASDocEmitter;
import org.apache.royale.compiler.codegen.js.royale.IJSRoyaleEmitter;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IInterfaceDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLRoyaleASDocEmitter;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.EventDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleASDocProject;
import org.apache.royale.compiler.internal.tree.as.metadata.EventTagNode;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IGetterNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.ISetterNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.utils.NativeUtils;

public class JSRoyaleASDocDITAEmitter
extends JSGoogEmitter
implements IJSRoyaleEmitter,
IJSRoyaleASDocEmitter {
    public MXMLRoyaleASDocEmitter mxmlEmitter = null;
    private ArrayList<String> accessors = new ArrayList();

    public String postProcess(String output) {
        return output;
    }

    public JSRoyaleASDocDITAEmitter(FilterWriter out) {
        super(out);
    }

    protected void writeIndent() {
        this.write(JSRoyaleEmitterTokens.INDENT);
    }

    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numIndent; ++i) {
            sb.append(JSRoyaleEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    public void emitNamespace(INamespaceNode node) {
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        this.writeNewline("{ \"type\": \"namespace\",");
        this.write("  \"qname\": \"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.writeNewline("\",");
        this.indentPush();
        if (asDoc != null) {
            this.writeASDoc(asDoc);
        }
        this.indentPop();
        this.writeNewline("}");
    }

    public String formatQualifiedName(String name) {
        return this.formatQualifiedName(name, false);
    }

    public String formatQualifiedName(String name, boolean isDoc) {
        if (this.mxmlEmitter != null) {
            name = this.mxmlEmitter.formatQualifiedName(name);
        }
        if (this.getModel().isInternalClass(name)) {
            return this.getModel().getInternalClasses().get(name);
        }
        if (NativeUtils.isJSNative(name)) {
            return name;
        }
        if (name.startsWith("window.")) {
            name = name.substring(7);
        } else if (!isDoc) {
            // empty if block
        }
        int c = name.lastIndexOf(".");
        if (c != -1) {
            name = name.substring(0, c) + ":" + name.substring(c + 1);
        }
        return name;
    }

    public String convertASTypeToJS(String name) {
        String result = name;
        if (name.equals("")) {
            result = "Object";
        } else if (name.equals("Class")) {
            result = "Object";
        } else if (name.equals("int") || name.equals("uint")) {
            result = "Number";
        }
        boolean isBuiltinFunction = name.matches("Vector\\.<.*>");
        if (isBuiltinFunction) {
            result = "Array";
        }
        return result;
    }

    public void emitPackageHeader(IPackageDefinition definition) {
        IPackageNode packageNode = definition.getNode();
        IFileNode fileNode = (IFileNode)packageNode.getAncestorOfType(IFileNode.class);
        int nodeCount = fileNode.getChildCount();
        for (int i = 0; i < nodeCount; ++i) {
            IASNode pnode = fileNode.getChild(i);
            if (pnode instanceof IPackageNode) continue;
            if (pnode instanceof IClassNode) {
                this.getWalker().walk(pnode);
                continue;
            }
            if (pnode instanceof IInterfaceNode) {
                this.getWalker().walk(pnode);
                continue;
            }
            if (pnode instanceof IFunctionNode) {
                this.getWalker().walk(pnode);
                continue;
            }
            if (pnode instanceof INamespaceNode) {
                this.getWalker().walk(pnode);
                continue;
            }
            if (!(pnode instanceof IVariableNode)) continue;
            this.getWalker().walk(pnode);
        }
    }

    public void emitPackageHeaderContents(IPackageDefinition definition) {
    }

    public void emitPackageFooter(IPackageDefinition definition) {
    }

    public void emitClass(IClassNode node) {
        IMetaTagNode[] metas;
        IDefinitionNode[] members;
        IExpressionNode[] interfaceNodes;
        IClassDefinition def = node.getDefinition();
        this.write("<apiClassifier id=\"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.write("\"><apiName>");
        this.write(node.getName());
        this.write("</apiName>");
        String linkText = "";
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        String shortdesc = null;
        if (asDoc != null) {
            asDoc.compile(false);
            shortdesc = this.makeShortDescription(asDoc);
            this.write(shortdesc);
            linkText = this.writeASDoc(asDoc);
        } else {
            this.write("<shortdesc/>");
        }
        this.write("<apiClassifierDetail>");
        this.write("<apiClassifierDef>");
        if (def.isPublic()) {
            this.write("<apiAccess value=\"public\"/>");
        }
        this.write("<apiStatic/>");
        for (IExpressionNode base : interfaceNodes = node.getImplementedInterfaceNodes()) {
            this.write("<apiBaseInterface>");
            this.write(this.formatQualifiedName(base.resolve(this.getWalker().getProject()).getQualifiedName()));
            this.write("</apiBaseInterface>");
        }
        this.write("<apiBaseClassifier>");
        IExpressionNode baseNode = node.getBaseClassExpressionNode();
        if (baseNode == null) {
            this.write("Object");
        } else {
            this.write(this.formatQualifiedName(baseNode.resolve(this.getWalker().getProject()).getQualifiedName()));
        }
        this.write("</apiBaseClassifier>");
        this.write("</apiClassifierDef>");
        if (asDoc != null) {
            this.writeAPIDesc(asDoc);
        }
        this.write("</apiClassifierDetail>");
        this.write(linkText);
        for (IDefinitionNode mnode : members = node.getAllMemberNodes()) {
            this.getWalker().walk((IASNode)mnode);
        }
        for (IMetaTagNode mnode : metas = node.getMetaTagNodesByName("Event")) {
            this.writeEventTagNode(mnode, def);
        }
        this.write("</apiClassifier>");
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
        RoyaleASDocProject project = (RoyaleASDocProject)this.getWalker().getProject();
        RoyaleASDocProject.ASDocRecord record = new RoyaleASDocProject.ASDocRecord(project);
        record.definition = node.getDefinition();
        record.description = asDoc != null ? this.makeShortDescription(asDoc) : "";
        ((RoyaleASDocProject)this.getWalker().getProject()).classes.put(this.formatQualifiedName(node.getQualifiedName()), record);
    }

    public void emitInterface(IInterfaceNode node) {
        IDefinitionNode[] members;
        IExpressionNode[] baseNodes;
        IInterfaceDefinition def = node.getDefinition();
        this.write("<apiClassifier id=\"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.write("\"><apiName>");
        this.write(node.getName());
        this.write("</apiName>");
        String linkText = "";
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        String shortdesc = null;
        if (asDoc != null) {
            asDoc.compile(false);
            shortdesc = this.makeShortDescription(asDoc);
            this.write(shortdesc);
            linkText = this.writeASDoc(asDoc);
        } else {
            this.write("<shortdesc/>");
        }
        this.write("<apiClassifierDetail>");
        this.write("<apiClassifierDef>");
        this.write("<apiInterface/>");
        if (def.isPublic()) {
            this.write("<apiAccess value=\"public\"/>");
        }
        this.write("<apiStatic/>");
        for (IExpressionNode base : baseNodes = node.getExtendedInterfaceNodes()) {
            this.write("<apiBaseInterface>");
            this.write(this.formatQualifiedName(base.resolve(this.getWalker().getProject()).getQualifiedName()));
            this.write("</apiBaseInterface>");
        }
        this.write("<apiBaseClassifier/>");
        this.write("</apiClassifierDef>");
        if (asDoc != null) {
            this.writeAPIDesc(asDoc);
        }
        this.write("</apiClassifierDetail>");
        for (IDefinitionNode mnode : members = node.getAllMemberDefinitionNodes()) {
            this.getWalker().walk((IASNode)mnode);
        }
        this.write(linkText);
        this.write("</apiClassifier>");
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
        RoyaleASDocProject project = (RoyaleASDocProject)this.getWalker().getProject();
        RoyaleASDocProject.ASDocRecord record = new RoyaleASDocProject.ASDocRecord(project);
        record.definition = node.getDefinition();
        record.description = asDoc != null ? this.makeShortDescription(asDoc) : "";
        ((RoyaleASDocProject)this.getWalker().getProject()).classes.put(this.formatQualifiedName(node.getQualifiedName()), record);
    }

    public void emitGetAccessor(IGetterNode node) {
        IFunctionDefinition def = node.getDefinition();
        boolean isInterface = def.getParent() instanceof InterfaceDefinition;
        if (node.getDefinition().isPrivate()) {
            return;
        }
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        String name = node.getName();
        if (this.accessors.contains(name)) {
            return;
        }
        this.accessors.add(name);
        this.write("<apiValue id=\"");
        if (isInterface) {
            this.write(this.formatQualifiedName(def.getParent().getQualifiedName()));
            this.write(":");
        }
        this.write(this.formatQualifiedName(def.getParent().getQualifiedName()));
        this.write(":");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.write(":get\"><apiName>");
        this.write(node.getName());
        this.write("</apiName>");
        String shortdesc = null;
        String linkText = "";
        if (asDoc != null) {
            asDoc.compile(false);
            shortdesc = this.makeShortDescription(asDoc);
            this.write(shortdesc);
            linkText = this.writeASDoc(asDoc);
        } else {
            this.write("<shortdesc/>");
        }
        this.write("<apiValueDetail>");
        this.write("<apiValueDef>");
        this.write("<apiProperty/>");
        if (def.isPublic() || isInterface) {
            this.write("<apiAccess value=\"public\"/>");
        } else if (def.isProtected()) {
            this.write("<apiAccess value=\"protected\"/>");
        }
        if (def.isStatic()) {
            this.write("<apiStatic/>");
        }
        this.write("<apiDynamic/>");
        this.write("<apiValueAccess value=\"read\"/>");
        this.write("<apiType value=\"");
        this.write(this.formatQualifiedName(def.resolveType(this.getWalker().getProject()).getQualifiedName()));
        this.write("\"/>");
        this.write("</apiValueDef>");
        if (asDoc != null) {
            this.writeAPIDesc(asDoc);
        }
        this.write("</apiValueDetail>");
        this.write(linkText);
        this.write("</apiValue>");
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
    }

    public void emitSetAccessor(ISetterNode node) {
        IFunctionDefinition def = node.getDefinition();
        boolean isInterface = def.getParent() instanceof InterfaceDefinition;
        if (node.getDefinition().isPrivate()) {
            return;
        }
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        String name = node.getName();
        if (this.accessors.contains(name)) {
            return;
        }
        this.accessors.add(name);
        this.write("<apiValue id=\"");
        if (isInterface) {
            this.write(this.formatQualifiedName(def.getParent().getQualifiedName()));
            this.write(":");
        }
        this.write(this.formatQualifiedName(def.getParent().getQualifiedName()));
        this.write(":");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.write(":set\"><apiName>");
        this.write(node.getName());
        this.write("</apiName>");
        String shortdesc = null;
        String linkText = "";
        if (asDoc != null) {
            asDoc.compile(false);
            shortdesc = this.makeShortDescription(asDoc);
            this.write(shortdesc);
            linkText = this.writeASDoc(asDoc);
        } else {
            this.write("<shortdesc/>");
        }
        this.write("<apiValueDetail>");
        this.write("<apiValueDef>");
        this.writeAPIProperties((IDefinition)def);
        if (def.isPublic() || def.getParent() instanceof InterfaceDefinition) {
            this.write("<apiAccess value=\"public\"/>");
        } else if (def.isProtected()) {
            this.write("<apiAccess value=\"protected\"/>");
        }
        if (def.isStatic()) {
            this.write("<apiStatic/>");
        }
        this.write("<apiDynamic/>");
        this.write("<apiValueAccess value=\"write\"/>");
        this.write("<apiValueClassifier>");
        this.write(this.formatQualifiedName(def.resolveType(this.getWalker().getProject()).getQualifiedName()));
        this.write("</apiValueClassifier>");
        this.write("</apiValueDef>");
        if (asDoc != null) {
            this.writeAPIDesc(asDoc);
        }
        this.write("</apiValueDetail>");
        this.write(linkText);
        this.write("</apiValue>");
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
    }

    public void emitField(IVariableNode node) {
        IDefinition def = node.getDefinition();
        if (node.getDefinition().isPrivate()) {
            return;
        }
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        this.write("<apiValue id=\"");
        this.write(this.formatQualifiedName(def.getParent().getQualifiedName()));
        this.write(":");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.write("\"><apiName>");
        this.write(node.getName());
        this.write("</apiName>");
        String shortdesc = null;
        String linkText = "";
        if (asDoc != null) {
            asDoc.compile(false);
            shortdesc = this.makeShortDescription(asDoc);
            this.write(shortdesc);
            linkText = this.writeASDoc(asDoc);
        } else {
            this.write("<shortdesc/>");
        }
        this.write("<apiValueDetail>");
        this.write("<apiValueDef>");
        this.writeAPIProperties(def);
        if (def.isPublic() || def.getParent() instanceof InterfaceDefinition) {
            this.write("<apiAccess value=\"public\"/>");
        } else if (def.isProtected()) {
            this.write("<apiAccess value=\"protected\"/>");
        }
        if (def.isStatic()) {
            this.write("<apiStatic/>");
        }
        this.write("<apiDynamic/>");
        this.write("<apiValueClassifier>");
        this.write(this.formatQualifiedName(def.resolveType(this.getWalker().getProject()).getQualifiedName()));
        this.write("</apiValueClassifier>");
        this.write("</apiValueDef>");
        if (asDoc != null) {
            this.writeAPIDesc(asDoc);
        }
        this.write("</apiValueDetail>");
        this.write(linkText);
        this.write("</apiValue>");
        this.addToIndex(node.getDefinition(), asDoc);
    }

    public void emitVarDeclaration(IVariableNode node) {
        IDefinition def = node.getDefinition();
        if (node.getDefinition().isPrivate()) {
            return;
        }
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        this.write("<apiValue id=\"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.write("\"><apiName>");
        this.write(node.getName());
        this.write("</apiName>");
        String shortdesc = null;
        if (asDoc != null) {
            asDoc.compile(false);
            shortdesc = this.makeShortDescription(asDoc);
            this.write(shortdesc);
            this.writeASDoc(asDoc);
        } else {
            this.write("<shortdesc/>");
        }
        this.write("<apiValueDetail>");
        this.write("<apiValueDef>");
        this.writeAPIProperties(def);
        if (def.isPublic() || def.getParent() instanceof InterfaceDefinition) {
            this.write("<apiAccess value=\"public\"/>");
        } else if (def.isProtected()) {
            this.write("<apiAccess value=\"protected\"/>");
        }
        if (def.isStatic()) {
            this.write("<apiStatic/>");
        }
        this.write("<apiDynamic/>");
        this.write("<apiType value=\"");
        this.write(this.formatQualifiedName(def.resolveType(this.getWalker().getProject()).getQualifiedName()));
        this.write("\"/>");
        this.write("</apiValueDef>");
        if (asDoc != null) {
            this.writeAPIDesc(asDoc);
        }
        this.write("</apiValueDetail>");
        this.write("</apiValue>");
        this.addToIndex(node.getDefinition(), asDoc);
    }

    public void emitAccessors(IAccessorNode node) {
        if (node.getDefinition().isPrivate()) {
            return;
        }
        String name = node.getName();
        if (this.accessors.contains(name)) {
            return;
        }
        this.accessors.add(name);
        this.writeNewline("{ \"type\": \"accessor\",");
        IAccessorDefinition def = (IAccessorDefinition)node.getDefinition();
        IAccessorDefinition otherDef = def.resolveCorrespondingAccessor(this.getWalker().getProject());
        IAccessorNode otherNode = null;
        if (otherDef != null) {
            otherNode = (IAccessorNode)otherDef.getNode();
            this.writeNewline("  \"access\": \"read-write\",");
        } else {
            this.writeNewline("  \"access\": \"read-only\",");
        }
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if ((asDoc == null || asDoc.commentNoEnd().contains("@private")) && otherNode != null) {
            asDoc = (ASDocComment)otherNode.getASDocComment();
        }
        this.write("<apiValue id=\"");
        this.write(this.formatQualifiedName(node.getQualifiedName()));
        this.write(":set\"><apiName>");
        this.write(node.getName());
        this.write("</apiName>");
        String shortdesc = null;
        if (asDoc != null) {
            asDoc.compile(false);
            shortdesc = this.makeShortDescription(asDoc);
            this.write(shortdesc);
            this.writeASDoc(asDoc);
        } else {
            this.write("<shortdesc/>");
        }
        this.write("<apiValueDetail>");
        this.write("<apiValueDef>");
        this.writeAPIProperties((IDefinition)def);
        if (def.isPublic() || def.getParent() instanceof InterfaceDefinition) {
            this.write("<apiAccess value=\"public\"/>");
        } else if (def.isProtected()) {
            this.write("<apiAccess value=\"protected\"/>");
        }
        if (def.isStatic()) {
            this.write("<apiStatic/>");
        }
        this.write("<apiDynamic/>");
        if (otherDef != null) {
            otherNode = (IAccessorNode)otherDef.getNode();
            this.write("<apiValueAccess value=\"read-write\"/>");
        } else {
            this.writeNewline("  \"access\": \"read\",");
        }
        this.write("<apiType value=\"");
        this.write(this.formatQualifiedName(def.resolveType(this.getWalker().getProject()).getQualifiedName()));
        this.write("\"/>");
        this.write("</apiValueDef>");
        if (asDoc != null) {
            this.writeAPIDesc(asDoc);
        }
        this.write("</apiValueDetail>");
        this.write("</apiValue>");
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
    }

    public void emitMethod(IFunctionNode node) {
        IFunctionDefinition def = node.getDefinition();
        if (def.isPrivate()) {
            return;
        }
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        if (node.isConstructor()) {
            this.write("<apiConstructor id=\"");
            this.write(this.formatQualifiedName(node.getQualifiedName()));
            this.write(":");
            this.write(node.getName());
            this.write("\"><apiName>");
            this.write(node.getName());
            this.write("</apiName>");
            String shortdesc = null;
            if (asDoc != null) {
                asDoc.compile(false);
                shortdesc = this.makeShortDescription(asDoc);
                this.write(shortdesc);
                this.writeASDoc(asDoc);
            } else {
                this.write("<shortdesc/>");
            }
            this.write("<apiConstructorDetail>");
            this.write("<apiConstructorDef>");
            this.write("<apiAccess value=\"public\"/>");
            this.write("</apiConstructorDef>");
            if (asDoc != null) {
                this.writeAPIDesc(asDoc);
            }
            this.write("</apiConstructorDetail>");
            this.write("</apiConstructor>");
        } else {
            this.write("<apiOperation id=\"");
            this.write(this.formatQualifiedName(def.getParent().getQualifiedName()));
            this.write(":");
            this.write(this.formatQualifiedName(node.getQualifiedName()));
            this.write("\"><apiName>");
            this.write(node.getName());
            this.write("</apiName>");
            String shortdesc = null;
            if (asDoc != null) {
                asDoc.compile(false);
                shortdesc = this.makeShortDescription(asDoc);
                this.write(shortdesc);
                this.writeASDoc(asDoc);
            } else {
                this.write("<shortdesc/>");
            }
            this.write("<apiOperationDetail>");
            this.write("<apiOperationDef>");
            if (def.isPublic() || def.getParent() instanceof InterfaceDefinition) {
                this.write("<apiAccess value=\"public\"/>");
            } else if (def.isProtected()) {
                this.write("<apiAccess value=\"protected\"/>");
            }
            if (def.isStatic()) {
                this.write("<apiStatic/>");
            }
            this.write("<apiReturn><apiType value=\"");
            this.write(def.getReturnTypeAsDisplayString());
            this.write("\"/></apiReturn>");
            IParameterDefinition[] params = def.getParameters();
            this.write("<apiParam>");
            for (IParameterDefinition param : params) {
                this.write("<apiItemName>");
                this.write(param.getBaseName());
                this.write("</apiItemName><apiType value=\"");
                this.write(param.getTypeAsDisplayString());
                this.write("\">");
                if (param.hasDefaultValue()) {
                    this.write("<apiData>");
                    this.write(param.getNode().getDefaultValue());
                    this.write("</apiData>");
                }
                this.write("</apiParam>");
            }
            this.write("</apiOperationDef>");
            if (asDoc != null) {
                this.writeAPIDesc(asDoc);
            }
            this.write("</apiOperationDetail>");
            this.write("</apiOperation>");
        }
        this.addToIndex((IDefinition)node.getDefinition(), asDoc);
    }

    public String writeASDoc(ASDocComment asDoc) {
        StringBuilder linkText = new StringBuilder();
        RoyaleASDocProject project = (RoyaleASDocProject)this.getWalker().getProject();
        List<String> tagList = project.tags;
        Map<String, List<IASDocTag>> tags = asDoc.getTags();
        if (tags != null) {
            String[] parts;
            String desc;
            this.write("<prolog><asMetadata><apiVersion>");
            List<IASDocTag> values = tags.get("langversion");
            if (values != null) {
                for (IASDocTag value : values) {
                    this.write("<apiLanguage version=\"");
                    this.write(value.getDescription());
                    this.write("\"/>");
                }
            }
            if ((values = tags.get("playerversion")) != null) {
                for (IASDocTag value : values) {
                    this.write("<apiPlatform description=\"\" name=\"");
                    desc = value.getDescription();
                    parts = desc.split(" ");
                    this.write(parts[0]);
                    this.write("\" version=\"");
                    this.write(parts[1]);
                    this.write("\"/>");
                }
            }
            if ((values = tags.get("productversion")) != null) {
                for (IASDocTag value : values) {
                    this.write("<apiTool description=\"\" name=\"");
                    desc = value.getDescription();
                    parts = desc.split(" ");
                    this.write(parts[0]);
                    this.write("\" version=\"");
                    this.write(parts[1]);
                    this.write("\"/>");
                }
            }
            if ((values = tags.get("see")) != null) {
                linkText.append("<related-links>");
                for (IASDocTag value : values) {
                    linkText.append("<link href=\"");
                    desc = value.getDescription();
                    parts = desc.split("#");
                    String fileName = parts[0];
                    int c = fileName.lastIndexOf(".");
                    if (c == -1) {
                        c = fileName.length();
                    }
                    linkText.append(fileName.substring(0, c));
                    if (parts.length == 1) {
                        linkText.append(".xml");
                    } else {
                        linkText.append(".xml#");
                        linkText.append(fileName.substring(c + 1));
                        linkText.append("/");
                        linkText.append(parts[1]);
                    }
                    linkText.append("\"/>");
                    linkText.append("<linktext>");
                    linkText.append(parts[0]);
                    if (parts.length > 1) {
                        linkText.append(".");
                        linkText.append(parts[1]);
                    }
                    linkText.append("</linktext>");
                    linkText.append("</link>");
                }
                linkText.append("</related-links>");
            }
            this.write("</apiVersion></asMetadata>");
            boolean needHeader = true;
            boolean needFooter = false;
            Set<String> tagNames = tags.keySet();
            for (String tagName : tagNames) {
                if (!tagList.contains(tagName)) {
                    tagList.add(tagName);
                }
                if (tagName.equals("see") || tagName.equals("copy") || tagName.equals("productversion") || tagName.equals("langversion") || tagName.equals("playerversion")) continue;
                if (needHeader) {
                    this.write("<asCustoms>");
                    needFooter = true;
                }
                if ((values = tags.get(tagName)) != null) {
                    this.write("<" + tagName + ">");
                    for (IASDocTag value : values) {
                        this.write(value.getDescription());
                    }
                    this.write("</" + tagName + ">");
                    continue;
                }
                this.write("<" + tagName + "/>");
            }
            if (needFooter) {
                this.write("</asCustoms>");
            }
            this.write("</prolog>");
        } else {
            this.write("<prolog/>");
        }
        return linkText.toString();
    }

    public void writeEventTagNode(IMetaTagNode node, IClassDefinition classDef) {
        EventTagNode evt = (EventTagNode)node;
        ASDocComment asDoc = (ASDocComment)evt.getASDocComment();
        if (asDoc != null && asDoc.commentNoEnd().contains("@private")) {
            return;
        }
        this.write("<adobeApiEvent id=\"");
        this.write(this.formatQualifiedName(classDef.getQualifiedName()));
        this.write("_");
        this.write(evt.getValue("type"));
        this.write("_");
        this.write(evt.getValue("name"));
        this.writeNewline("\">");
        this.write("<apiName>");
        this.write(evt.getValue("name"));
        this.write("</apiName>");
        if (asDoc != null) {
            asDoc.compile(false);
            this.write(this.makeShortDescription(asDoc));
            this.writeASDoc(asDoc);
        }
        this.write("<adobeApiEventDetail>");
        this.write("<adobeApiEventDef>");
        this.write("<adobeApiEventClassifier>");
        this.write(evt.getValue("type"));
        this.write("</adobeApiEventClassifier>");
        this.write("<apiGeneratedEvent>");
        this.write("</adobeApiEventDef>");
        if (asDoc != null) {
            this.writeAPIDesc(asDoc);
        }
        this.write("</adobeApiEventDetail>");
        this.write("</adobeApiEvent>");
        this.addToIndex(evt.getDefinition(), asDoc);
    }

    private void addToIndex(IDefinition def, ASDocComment asDoc) {
        RoyaleASDocProject project = (RoyaleASDocProject)this.getWalker().getProject();
        List<RoyaleASDocProject.ASDocRecord> list = project.index.get(def.getBaseName());
        if (list == null) {
            list = new ArrayList<RoyaleASDocProject.ASDocRecord>();
            project.index.put(def.getBaseName(), list);
        }
        RoyaleASDocProject.ASDocRecord record = new RoyaleASDocProject.ASDocRecord(project);
        record.definition = def;
        record.description = asDoc != null ? this.makeShortDescription(asDoc) : "";
        list.add(record);
    }

    private String makeShortDescription(ASDocComment asDoc) {
        String description = asDoc.getDescription();
        if (description == null || description.length() == 0) {
            return "<shortdesc/>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<shortdesc");
        IASDocTag copyTag = asDoc.getTag("copy");
        if (copyTag != null) {
            sb.append(" conref=\"");
            sb.append(copyTag.getDescription());
            sb.append("\">\n");
        } else {
            sb.append(">");
            int c = description.indexOf(".");
            if (c != -1) {
                sb.append(description.substring(0, c + 1));
            } else {
                sb.append(description);
            }
        }
        sb.append("</shortdesc>");
        return sb.toString();
    }

    private void writeAPIDesc(ASDocComment asDoc) {
        this.write("<apiDesc");
        IASDocTag copyTag = asDoc.getTag("copy");
        if (copyTag != null) {
            this.write(" conref=\"");
            this.write(copyTag.getDescription());
            this.write("\">\n");
        } else {
            this.write(">");
            this.write(asDoc.getDescription());
        }
        this.write("</apiDesc>");
    }

    public void writeAPIProperties(IDefinition def) {
        IMetaTag propTag = def.getMetaTagByName("Bindable");
        if (propTag == null) {
            this.write("<apiProperty/>");
            return;
        }
        this.write("<apiProperty isBindable=\"true\"");
        String value = propTag.getValue();
        if (value != null) {
            this.write(" name=\"");
            this.write(value);
            this.write("\"");
        }
        this.write("/>");
    }

    public void outputIndex(File outputFolder, RoyaleASDocProject project) throws IOException {
        File indexFile = new File(outputFolder, "index.json");
        BufferedWriter out = new BufferedWriter(new FileWriter(indexFile));
        out.write("{  \"index\": [");
        if (project.config.isVerbose()) {
            System.out.println("Compiling file: " + indexFile);
        }
        Set<String> keys = project.index.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keys);
        Collections.sort(keyList);
        boolean firstLine = true;
        for (String key : keyList) {
            List<RoyaleASDocProject.ASDocRecord> list = project.index.get(key);
            for (RoyaleASDocProject.ASDocRecord record : list) {
                if (!firstLine) {
                    out.write(",\n");
                }
                firstLine = false;
                out.write("{ \"name\": \"");
                out.write(key);
                out.write("\",\n");
                out.write("  \"type\": ");
                if (record.definition instanceof ClassDefinition) {
                    out.write("\"Class\",\n");
                } else if (record.definition instanceof InterfaceDefinition) {
                    out.write("\"Interface\",\n");
                } else if (record.definition instanceof EventDefinition) {
                    out.write("\"Event\",\n");
                } else if (record.definition instanceof AccessorDefinition) {
                    out.write("\"Property\",\n");
                    out.write("  \"class\": \"");
                    out.write(this.formatQualifiedName(record.definition.getParent().getQualifiedName()));
                    out.write("\",\n");
                } else if (record.definition instanceof VariableDefinition) {
                    out.write("\"Property\",\n");
                    out.write("  \"class\": \"");
                    out.write(this.formatQualifiedName(record.definition.getParent().getQualifiedName()));
                    out.write("\",\n");
                } else if (record.definition instanceof FunctionDefinition) {
                    out.write("\"Method\",\n");
                    out.write("  \"class\": \"");
                    out.write(this.formatQualifiedName(record.definition.getParent().getQualifiedName()));
                    out.write("\",\n");
                }
                out.write("  \"description\": \"");
                out.write(record.description);
                out.write("\"}");
            }
        }
        out.write("]}");
        try {
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void outputClasses(File outputFolder, RoyaleASDocProject project) throws IOException {
        File indexFile = new File(outputFolder, "classes.json");
        BufferedWriter out = new BufferedWriter(new FileWriter(indexFile));
        out.write("{  \"classes\": [");
        if (project.config.isVerbose()) {
            System.out.println("Compiling file: " + indexFile);
        }
        Set<String> keys = project.classes.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keys);
        Collections.sort(keyList);
        boolean firstLine = true;
        for (String key : keyList) {
            if (!firstLine) {
                out.write(",\n");
            }
            firstLine = false;
            RoyaleASDocProject.ASDocRecord record = project.classes.get(key);
            out.write("{ \"name\": \"");
            out.write(key);
            out.write("\",\n");
            out.write("  \"description\": \"");
            out.write(record.description);
            out.write("\"}");
        }
        out.write("]}");
        try {
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void outputTags(File outputFolder, RoyaleASDocProject project) throws IOException {
        File indexFile = new File(outputFolder, "tags.json");
        BufferedWriter out = new BufferedWriter(new FileWriter(indexFile));
        out.write("{  \"tags\": [");
        if (project.config.isVerbose()) {
            System.out.println("Compiling file: " + indexFile);
        }
        Collections.sort(project.tags);
        boolean firstLine = true;
        for (String tag : project.tags) {
            if (!firstLine) {
                out.write(",\n");
            }
            firstLine = false;
            out.write("\"");
            out.write(tag);
            out.write("\"");
        }
        out.write("]}");
        try {
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

