/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jsc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLRoyalePublisher;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDocumentNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSCPublisher
extends MXMLRoyalePublisher {
    private RoyaleJSProject project;

    public JSCPublisher(RoyaleJSProject project, Configuration config) {
        super(project, config);
        this.project = project;
    }

    @Override
    protected String getTemplateBody(String mainClassQName) {
        IDefinition def = this.project.resolveQNameToDefinition(mainClassQName);
        IDefinitionNode node = def.getNode();
        if (node instanceof IMXMLDocumentNode) {
            return super.getTemplateBody(mainClassQName);
        }
        StringBuilder bodyHTML = new StringBuilder();
        bodyHTML.append("\t<script type=\"text/javascript\">\n");
        bodyHTML.append("\t\tnew ");
        bodyHTML.append(mainClassQName);
        bodyHTML.append("();\n");
        bodyHTML.append("\t</script>\n");
        return bodyHTML.toString();
    }

    @Override
    protected void writeHTML(String type, String projectName, String mainClassQName, File targetDir, String deps, List<String> additionalHTML) throws IOException {
        if ("intermediate".equals(type)) {
            StringBuilder depsFile = new StringBuilder();
            depsFile.append(deps);
            depsFile.append("goog.require(\"");
            depsFile.append(projectName);
            depsFile.append("\");\n");
            this.writeFile(new File(targetDir, projectName + "-dependencies.js"), depsFile.toString(), false);
        }
    }
}

