/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.goog;

import java.io.FilterWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.asdoc.royale.ASDocComment;
import org.apache.royale.compiler.codegen.IASGlobalFunctionConstants;
import org.apache.royale.compiler.codegen.js.goog.IJSGoogDocEmitter;
import org.apache.royale.compiler.codegen.js.goog.IJSGoogEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitter;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.scopes.PackageScope;
import org.apache.royale.compiler.internal.tree.as.ChainedVariableNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.VariableUsedBeforeDeclarationProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IEmbedNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IGetterNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.INamespaceAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.ISetterNode;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.compiler.tree.as.IVariableExpressionNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.utils.ASNodeUtils;

public class JSGoogEmitter
extends JSEmitter
implements IJSGoogEmitter {
    protected List<String> propertyNames = new ArrayList<String>();
    public ICompilerProject project;
    private JSGoogDocEmitter docEmitter;

    public IJSGoogDocEmitter getDocEmitter() {
        if (this.docEmitter == null) {
            this.docEmitter = new JSGoogDocEmitter(this);
        }
        return this.docEmitter;
    }

    public String formatQualifiedName(String name) {
        return name;
    }

    public void emitPackageHeader(IPackageDefinition definition) {
        IASScope containedScope = definition.getContainedScope();
        ITypeDefinition type = this.findType(containedScope.getAllLocalDefinitions());
        if (type == null) {
            return;
        }
        this.write(JSGoogEmitterTokens.GOOG_PROVIDE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(type.getQualifiedName());
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        this.writeNewline();
    }

    public void emitPackageHeaderContents(IPackageDefinition definition) {
        PackageScope containedScope = (PackageScope)definition.getContainedScope();
        ITypeDefinition type = this.findType(containedScope.getAllLocalDefinitions());
        if (type == null) {
            return;
        }
        List<String> list = EmitterUtils.resolveImports(type);
        for (String imp : list) {
            if (imp.indexOf(JSGoogEmitterTokens.AS3.getToken()) != -1) continue;
            this.write(JSGoogEmitterTokens.GOOG_REQUIRE);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(imp);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.writeNewline(ASEmitterTokens.SEMICOLON);
        }
        if (list.size() > 1 || list.size() == 1 && list.get(0).indexOf(JSGoogEmitterTokens.AS3.getToken()) == -1) {
            this.writeNewline();
        }
    }

    public void emitPackageContents(IPackageDefinition definition) {
        INamespaceNode nsNode;
        NamespaceDefinition.INamepaceDeclarationDirective ns;
        IVariableNode vnode;
        IASScope containedScope = definition.getContainedScope();
        ITypeDefinition type = EmitterUtils.findType(containedScope.getAllLocalDefinitions());
        if (type != null) {
            ITypeNode tnode = EmitterUtils.findTypeNode(definition.getNode());
            if (tnode != null) {
                this.getModel().primaryDefinitionQName = this.formatQualifiedName(type.getQualifiedName());
                this.getWalker().walk((IASNode)tnode);
            }
            return;
        }
        IFunctionDefinition func = EmitterUtils.findFunction(containedScope.getAllLocalDefinitions());
        if (func != null) {
            IFunctionNode fnode = EmitterUtils.findFunctionNode(definition.getNode());
            if (fnode != null) {
                this.getWalker().walk((IASNode)fnode);
            }
            return;
        }
        IVariableDefinition variable = EmitterUtils.findVariable(containedScope.getAllLocalDefinitions());
        if (variable != null && (vnode = EmitterUtils.findVariableNode(definition.getNode())) != null) {
            this.getWalker().walk((IASNode)vnode);
        }
        if ((ns = EmitterUtils.findNamespace(containedScope.getAllLocalDefinitions())) != null && (nsNode = EmitterUtils.findNamespaceNode(definition.getNode())) != null) {
            this.getWalker().walk((IASNode)nsNode);
        }
    }

    public void emitPackageFooter(IPackageDefinition definition) {
    }

    public void emitClass(IClassNode node) {
        IDefinitionNode[] dnodes;
        IClassDefinition definition = node.getDefinition();
        this.getModel().setCurrentClass(definition);
        IFunctionDefinition ctorDefinition = definition.getConstructor();
        if (ctorDefinition != null) {
            IFunctionNode ctorNode = (IFunctionNode)ctorDefinition.getNode();
            if (ctorNode != null) {
                this.emitMethod(ctorNode);
                this.write(ASEmitterTokens.SEMICOLON);
            } else {
                String qname = definition.getQualifiedName();
                if (qname != null && !qname.equals("")) {
                    this.write(qname);
                    this.write(ASEmitterTokens.SPACE);
                    this.writeToken(ASEmitterTokens.EQUAL);
                    this.write(ASEmitterTokens.FUNCTION);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.BLOCK_OPEN);
                    this.writeNewline();
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    this.write(ASEmitterTokens.SEMICOLON);
                }
            }
        }
        for (IDefinitionNode dnode : dnodes = node.getAllMemberNodes()) {
            if (dnode.getNodeID() == ASTNodeID.VariableID) {
                this.writeNewline();
                this.writeNewline();
                this.emitField((IVariableNode)dnode);
                this.write(ASEmitterTokens.SEMICOLON);
                continue;
            }
            if (dnode.getNodeID() == ASTNodeID.FunctionID) {
                if (((IFunctionNode)dnode).isConstructor()) continue;
                this.writeNewline();
                this.writeNewline();
                this.emitMethod((IFunctionNode)dnode);
                this.write(ASEmitterTokens.SEMICOLON);
                continue;
            }
            if (dnode.getNodeID() != ASTNodeID.GetterID && dnode.getNodeID() != ASTNodeID.SetterID) continue;
            this.writeNewline();
            this.writeNewline();
            this.emitAccessors((IAccessorNode)dnode);
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }

    public void emitInterface(IInterfaceNode node) {
        IDefinitionNode[] members;
        ICompilerProject project = this.getWalker().getProject();
        this.getDocEmitter().emitInterfaceDoc(node, project);
        String qname = node.getQualifiedName();
        if (qname != null && !qname.equals("")) {
            this.write(this.formatQualifiedName(qname));
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.FUNCTION);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            this.writeNewline();
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
        for (IDefinitionNode mnode : members = node.getAllMemberDefinitionNodes()) {
            boolean isAccessor;
            boolean bl = isAccessor = mnode.getNodeID() == ASTNodeID.GetterID || mnode.getNodeID() == ASTNodeID.SetterID;
            if (isAccessor && this.propertyNames.contains(qname)) continue;
            this.writeNewline();
            this.write(this.formatQualifiedName(qname));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(mnode.getQualifiedName());
            if (isAccessor && !this.propertyNames.contains(qname)) {
                this.propertyNames.add(qname);
            } else {
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.FUNCTION);
                this.emitParameters(((IFunctionNode)mnode).getParametersContainerNode());
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.BLOCK_OPEN);
                this.writeNewline();
                this.write(ASEmitterTokens.BLOCK_CLOSE);
            }
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }

    public void emitField(IVariableNode node) {
        IClassDefinition definition = EmitterUtils.getClassDefinition((IDefinitionNode)node);
        ITypeDefinition def = null;
        IExpressionNode enode = node.getVariableTypeNode();
        if (enode != null) {
            def = enode.resolveType(this.getWalker().getProject());
        }
        this.getDocEmitter().emitFieldDoc(node, (IDefinition)def, this.getWalker().getProject());
        ModifiersSet modifierSet = node.getDefinition().getModifiers();
        String root = "";
        if (modifierSet != null && !modifierSet.hasModifier(ASModifier.STATIC)) {
            root = JSEmitterTokens.PROTOTYPE.getToken();
            root = root + ASEmitterTokens.MEMBER_ACCESS.getToken();
        }
        this.write(definition.getQualifiedName() + ASEmitterTokens.MEMBER_ACCESS.getToken() + root + node.getName());
        IExpressionNode vnode = node.getAssignedValueNode();
        if (vnode != null) {
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.getWalker().walk((IASNode)vnode);
        }
        if (!(node instanceof ChainedVariableNode)) {
            int len = node.getChildCount();
            for (int i = 0; i < len; ++i) {
                IASNode child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode)) continue;
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.writeNewline();
                this.emitField((IVariableNode)child);
            }
        }
    }

    public void emitVarDeclaration(IVariableNode node) {
        IExpressionNode avnode;
        if (!(node instanceof ChainedVariableNode) && !node.isConst()) {
            this.emitMemberKeyword((IDefinitionNode)node);
        }
        if ((avnode = node.getAssignedValueNode()) != null) {
            ITypeDefinition def = avnode.resolveType(this.getWalker().getProject());
            String opcode = avnode.getNodeID().getParaphrase();
            if (opcode != "AnonymousFunction") {
                this.getDocEmitter().emitVarDoc(node, (IDefinition)def, this.getWalker().getProject());
            }
        } else {
            this.getDocEmitter().emitVarDoc(node, null, this.getWalker().getProject());
        }
        this.emitDeclarationName((IDefinitionNode)node);
        if (avnode != null && !(avnode instanceof IEmbedNode)) {
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.emitAssignedValue(avnode);
        }
        if (!(node instanceof ChainedVariableNode)) {
            int len = node.getChildCount();
            for (int i = 0; i < len; ++i) {
                IASNode child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode)) continue;
                this.writeToken(ASEmitterTokens.COMMA);
                this.emitVarDeclaration((IVariableNode)child);
            }
        }
    }

    public void emitAccessors(IAccessorNode node) {
        String qname = node.getQualifiedName();
        if (!this.propertyNames.contains(qname)) {
            this.emitField((IVariableNode)node);
            this.write(ASEmitterTokens.SEMICOLON);
            this.writeNewline();
            this.writeNewline();
            this.propertyNames.add(qname);
        }
        if (node.getNodeID() == ASTNodeID.GetterID) {
            this.emitGetAccessor((IGetterNode)node);
        } else if (node.getNodeID() == ASTNodeID.SetterID) {
            this.emitSetAccessor((ISetterNode)node);
        }
    }

    public void emitGetAccessor(IGetterNode node) {
        this.emitObjectDefineProperty((IAccessorNode)node);
    }

    public void emitSetAccessor(ISetterNode node) {
        this.emitObjectDefineProperty((IAccessorNode)node);
    }

    public void emitMethod(IFunctionNode node) {
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(new ArrayList());
        ICompilerProject project = this.getWalker().getProject();
        this.getDocEmitter().emitMethodDoc(node, project);
        boolean isConstructor = node.isConstructor();
        String qname = EmitterUtils.getTypeDefinition((IDefinitionNode)node).getQualifiedName();
        if (qname != null && !qname.equals("")) {
            this.write(this.formatQualifiedName(qname));
            if (!isConstructor) {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                if (!fn.hasModifier(ASModifier.STATIC)) {
                    this.write(JSEmitterTokens.PROTOTYPE);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                }
            }
        }
        if (!isConstructor) {
            this.emitMemberName((IDefinitionNode)node);
        }
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.FUNCTION);
        this.emitParameters(node.getParametersContainerNode());
        boolean hasSuperClass = EmitterUtils.hasSuperClass(project, (IDefinitionNode)node);
        if (isConstructor && node.getScopedNode().getChildCount() == 0) {
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            if (hasSuperClass) {
                this.emitSuperCall((IASNode)node, "emptyConstructor");
            }
            this.writeNewline();
            this.write(ASEmitterTokens.BLOCK_CLOSE);
        }
        if (!isConstructor || node.getScopedNode().getChildCount() > 0) {
            this.emitMethodScope(node.getScopedNode());
        }
        if (isConstructor && hasSuperClass) {
            this.writeNewline(ASEmitterTokens.SEMICOLON);
            this.write(JSGoogEmitterTokens.GOOG_INHERITS);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(this.formatQualifiedName(qname));
            this.writeToken(ASEmitterTokens.COMMA);
            String sname = EmitterUtils.getSuperClassDefinition((IDefinitionNode)node, project).getQualifiedName();
            this.write(this.formatQualifiedName(sname));
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    public void emitFunctionCall(IFunctionCallNode node) {
        ASTNodeID id;
        IASNode cnode = node.getChild(0);
        if (cnode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            cnode = cnode.getChild(0);
        }
        if ((id = cnode.getNodeID()) != ASTNodeID.SuperID) {
            if (node.isNewExpression()) {
                this.writeToken(ASEmitterTokens.NEW);
            }
            this.getWalker().walk((IASNode)node.getNameNode());
            this.emitArguments((IContainerNode)node.getArgumentsNode());
        } else {
            this.emitSuperCall((IASNode)node, "replaceSuperFunction");
        }
    }

    public void emitIdentifier(IIdentifierNode node) {
        boolean isRunningInTestMode;
        ICompilerProject project = this.getWalker().getProject();
        IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        IDefinition def = node.resolve(project);
        ITypeDefinition type = node.resolveType(project);
        IASNode pnode = node.getParent();
        ASTNodeID inode = pnode.getNodeID();
        boolean writeSelf = false;
        if (cnode != null) {
            IDefinitionNode[] members;
            for (IDefinitionNode mnode : members = cnode.getAllMemberNodes()) {
                if ((type == null || !type.getQualifiedName().equalsIgnoreCase("Function")) && (def == null || !def.getQualifiedName().equalsIgnoreCase(mnode.getQualifiedName()))) continue;
                if (!(pnode instanceof FunctionNode) && inode != ASTNodeID.MemberAccessExpressionID) {
                    writeSelf = true;
                    break;
                }
                if (inode != ASTNodeID.MemberAccessExpressionID || def.isStatic()) continue;
                String tname = type.getQualifiedName();
                writeSelf = !tname.equalsIgnoreCase(cnode.getQualifiedName()) && !tname.equals("Function");
                break;
            }
        }
        boolean bl = isRunningInTestMode = cnode != null && cnode.getQualifiedName().equalsIgnoreCase("RoyaleTest_A");
        if (writeSelf && !isRunningInTestMode) {
            this.write(JSGoogEmitterTokens.SELF);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
        } else {
            String pname;
            String string = pname = type != null ? type.getPackageName() : "";
            if (cnode != null && pname != "" && !pname.equalsIgnoreCase(cnode.getPackageName()) && inode != ASTNodeID.ArgumentID && inode != ASTNodeID.VariableID && inode != ASTNodeID.TypedExpressionID) {
                this.write(pname);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
            }
        }
        super.emitIdentifier(node);
    }

    public void emitFunctionBlockHeader(IFunctionNode node) {
        String debugToken;
        String asDocString;
        int emitIndex;
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (asDoc != null && (emitIndex = (asDocString = asDoc.commentNoEnd()).indexOf(debugToken = JSRoyaleEmitterTokens.DEBUG_COMMENT.getToken())) != -1) {
            IParameterNode[] pnodes = node.getParameterNodes();
            IParameterNode rest = EmitterUtils.getRest(pnodes);
            if (rest != null) {
                StringBuilder code = new StringBuilder();
                code.append(rest.getName());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.EQUAL.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(rest.getName());
                code.append(ASEmitterTokens.SEMICOLON.getToken());
                this.write(code.toString());
            }
            this.write(JSRoyaleEmitterTokens.DEBUG_RETURN);
            this.writeNewline();
        }
        IFunctionDefinition def = node.getDefinition();
        boolean isStatic = false;
        if (def != null && def.isStatic()) {
            isStatic = true;
        }
        boolean isLocal = false;
        if (node.getFunctionClassification() == IFunctionDefinition.FunctionClassification.LOCAL) {
            isLocal = true;
        }
        boolean isPackage = false;
        if (node.getFunctionClassification() == IFunctionDefinition.FunctionClassification.PACKAGE_MEMBER) {
            isPackage = true;
        }
        if (EmitterUtils.hasBody(node) && !isStatic && !isLocal && !isPackage) {
            this.emitSelfReference(node);
        }
        if (node.isConstructor() && EmitterUtils.hasSuperClass(this.getWalker().getProject(), (IDefinitionNode)node) && !EmitterUtils.hasSuperCall(node.getScopedNode())) {
            this.emitSuperCall((IASNode)node, "fullConstructor");
        }
        if (!this.getModel().isExterns) {
            this.emitRestParameterCodeBlock(node);
        }
        if (!this.getModel().isExterns) {
            this.emitDefaultParameterCodeBlock(node);
        }
    }

    protected void emitSelfReference(IFunctionNode node) {
        this.writeToken(ASEmitterTokens.VAR);
        this.writeToken(JSGoogEmitterTokens.SELF);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.THIS);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
    }

    protected void emitSuperCall(IASNode node, String type) {
        FunctionCallNode fcnode;
        IFunctionNode fnode = node instanceof IFunctionNode ? (IFunctionNode)node : null;
        FunctionCallNode functionCallNode = fcnode = node instanceof IFunctionCallNode ? (FunctionCallNode)node : null;
        if (type == "emptyConstructor") {
            this.indentPush();
            this.writeNewline();
            this.indentPop();
        } else if (type == "replaceSuperFunction" && fnode == null) {
            fnode = (IFunctionNode)fcnode.getAncestorOfType(IFunctionNode.class);
        }
        if (fnode.isConstructor() && !EmitterUtils.hasSuperClass(this.getWalker().getProject(), (IDefinitionNode)fnode)) {
            return;
        }
        IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        if (cnode == null) {
            IClassDefinition cdef = this.getModel().getCurrentClass();
            this.write(this.formatQualifiedName(cdef.getQualifiedName()));
        } else {
            this.write(this.formatQualifiedName(cnode.getQualifiedName()));
        }
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSGoogEmitterTokens.GOOG_BASE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.THIS);
        if (fnode.isConstructor()) {
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(JSGoogEmitterTokens.GOOG_CONSTRUCTOR);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
        }
        if (fnode != null && !fnode.isConstructor()) {
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(fnode.getName());
            this.write(ASEmitterTokens.SINGLE_QUOTE);
        }
        IExpressionNode[] anodes = null;
        boolean writeArguments = false;
        if (fcnode != null) {
            anodes = fcnode.getArgumentNodes();
            writeArguments = anodes.length > 0;
        } else if (fnode.isConstructor()) {
            anodes = fnode.getParameterNodes();
            boolean bl = writeArguments = anodes != null && anodes.length > 0;
        }
        if (writeArguments) {
            int len = anodes.length;
            for (int i = 0; i < len; ++i) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.getWalker().walk((IASNode)anodes[i]);
            }
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
        if (type == "fullConstructor") {
            this.write(ASEmitterTokens.SEMICOLON);
            this.writeNewline();
        } else if (type == "emptyConstructor") {
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }

    protected void emitDefaultParameterCodeBlock(IFunctionNode node) {
        IParameterNode[] pnodes = node.getParameterNodes();
        if (pnodes.length == 0) {
            return;
        }
        Map<Integer, IParameterNode> defaults = EmitterUtils.getDefaults(pnodes);
        if (defaults != null) {
            StringBuilder code = new StringBuilder();
            if (!EmitterUtils.hasBody(node)) {
                this.indentPush();
                this.writeIndent();
            }
            ArrayList<IParameterNode> parameters = new ArrayList<IParameterNode>(defaults.values());
            int n = parameters.size();
            for (int i = 0; i < n; ++i) {
                IParameterNode pnode = (IParameterNode)parameters.get(i);
                if (pnode == null) continue;
                code.setLength(0);
                code.append(pnode.getName());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.EQUAL.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.TYPEOF.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(pnode.getName());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.STRICT_NOT_EQUAL.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                code.append(ASEmitterTokens.UNDEFINED.getToken());
                code.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.TERNARY.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(pnode.getName());
                code.append(ASEmitterTokens.SPACE.getToken());
                code.append(ASEmitterTokens.COLON.getToken());
                code.append(ASEmitterTokens.SPACE.getToken());
                IExpressionNode assignedValueNode = pnode.getAssignedValueNode();
                code.append(this.stringifyNode((IASNode)assignedValueNode));
                code.append(ASEmitterTokens.SEMICOLON.getToken());
                this.write(code.toString());
                if (i == n - 1 && !EmitterUtils.hasBody(node)) {
                    this.indentPop();
                }
                this.writeNewline();
            }
        }
    }

    protected void emitRestParameterCodeBlock(IFunctionNode node) {
        IParameterNode[] pnodes = node.getParameterNodes();
        IParameterNode rest = EmitterUtils.getRest(pnodes);
        if (rest != null) {
            StringBuilder code = new StringBuilder();
            code.append(rest.getName());
            code.append(ASEmitterTokens.SPACE.getToken());
            code.append(ASEmitterTokens.EQUAL.getToken());
            code.append(ASEmitterTokens.SPACE.getToken());
            code.append(IASGlobalFunctionConstants.BuiltinType.ARRAY.getName());
            code.append(ASEmitterTokens.MEMBER_ACCESS.getToken());
            code.append(JSEmitterTokens.PROTOTYPE.getToken());
            code.append(ASEmitterTokens.MEMBER_ACCESS.getToken());
            code.append(JSEmitterTokens.SLICE.getToken());
            code.append(ASEmitterTokens.MEMBER_ACCESS.getToken());
            code.append(JSEmitterTokens.CALL.getToken());
            code.append(ASEmitterTokens.PAREN_OPEN.getToken());
            code.append(JSEmitterTokens.ARGUMENTS.getToken());
            code.append(ASEmitterTokens.COMMA.getToken());
            code.append(ASEmitterTokens.SPACE.getToken());
            code.append(String.valueOf(pnodes.length - 1));
            code.append(ASEmitterTokens.PAREN_CLOSE.getToken());
            code.append(ASEmitterTokens.SEMICOLON.getToken());
            this.write(code.toString());
            this.writeNewline();
        }
    }

    public void emitAssignedValue(IExpressionNode node) {
        if (node == null) {
            return;
        }
        IDefinition definition = node.resolve(this.getWalker().getProject());
        if (node.getNodeID() == ASTNodeID.IdentifierID && node.getParent().getNodeID() == ASTNodeID.VariableID && definition instanceof VariableDefinition && !(definition.getParent() instanceof ClassDefinition)) {
            IFileSpecification defFile = ((VariableDefinition)definition).getFileSpecification();
            IFileSpecification varFile = node.getFileSpecification();
            if (defFile != null && varFile != null && varFile.equals(defFile) && node.getAbsoluteStart() < definition.getAbsoluteStart()) {
                this.getProblems().add((ICompilerProblem)new VariableUsedBeforeDeclarationProblem((IASNode)node, definition.getBaseName()));
            }
        }
        if (node.getNodeID() == ASTNodeID.ClassReferenceID) {
            this.write(definition.getQualifiedName());
        } else if (definition instanceof IFunctionDefinition && node.getNodeID() == ASTNodeID.NamespaceAccessExpressionID) {
            this.getWalker().walk(node.getChild(1));
        } else {
            this.getWalker().walk((IASNode)node);
        }
    }

    public void emitForEachLoop(IForLoopNode node) {
        IContainerNode xnode = (IContainerNode)node.getChild(1);
        IBinaryOperatorNode bnode = (IBinaryOperatorNode)node.getConditionalsContainerNode().getChild(0);
        IASNode childNode = bnode.getChild(0);
        this.write(JSGoogEmitterTokens.GOOG_ARRAY_FOREACH);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.getWalker().walk(bnode.getChild(1));
        this.writeToken(ASEmitterTokens.COMMA);
        this.writeToken(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        if (childNode instanceof IVariableExpressionNode) {
            this.write(((IVariableNode)childNode.getChild(0)).getName());
        } else {
            this.write(((IIdentifierNode)childNode).getName());
        }
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        if (JSGoogEmitter.isImplicit(xnode)) {
            this.write(ASEmitterTokens.BLOCK_OPEN);
        }
        this.getWalker().walk(node.getStatementContentsNode());
        if (JSGoogEmitter.isImplicit(xnode)) {
            this.writeNewline();
            this.write(ASEmitterTokens.BLOCK_CLOSE);
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    public JSGoogEmitter(FilterWriter out) {
        super(out);
    }

    protected void emitObjectDefineProperty(IAccessorNode node) {
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(this.getProblems());
        this.write(JSGoogEmitterTokens.OBJECT);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.DEFINE_PROPERTY);
        this.writeNewline(ASEmitterTokens.PAREN_OPEN, true);
        IFunctionDefinition definition = node.getDefinition();
        ITypeDefinition type = (ITypeDefinition)definition.getParent();
        this.write(type.getQualifiedName());
        if (!node.hasModifier(ASModifier.STATIC)) {
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
        }
        this.writeToken(ASEmitterTokens.COMMA);
        this.writeNewline();
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(definition.getBaseName());
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.writeToken(ASEmitterTokens.COMMA);
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.write(node.getNodeID() == ASTNodeID.GetterID ? ASEmitterTokens.GET : ASEmitterTokens.SET);
        this.write(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.FUNCTION);
        this.emitParameters(node.getParametersContainerNode());
        this.emitDefinePropertyFunction(node);
        this.writeToken(ASEmitterTokens.COMMA);
        this.write(JSEmitterTokens.CONFIGURABLE);
        this.write(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.TRUE);
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE, false);
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    protected void emitDefinePropertyFunction(IAccessorNode node) {
        this.emitMethodScope(node.getScopedNode());
    }

    public void emitNamespaceAccessExpression(INamespaceAccessExpressionNode node) {
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.getWalker().walk((IASNode)node.getRightOperandNode());
    }

    public void emitAsOperator(IBinaryOperatorNode node) {
        this.emitBinaryOperator(node);
    }

    public void emitIsOperator(IBinaryOperatorNode node) {
        this.emitBinaryOperator(node);
    }

    public void emitBinaryOperator(IBinaryOperatorNode node) {
        ASTNodeID id;
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        if ((id = node.getNodeID()) == ASTNodeID.Op_IsID) {
            this.write(ASEmitterTokens.IS);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.writeToken(ASEmitterTokens.COMMA);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            this.write(ASEmitterTokens.PAREN_CLOSE);
        } else if (id == ASTNodeID.Op_AsID) {
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.IS);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.writeToken(ASEmitterTokens.COMMA);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            this.writeToken(ASEmitterTokens.PAREN_CLOSE);
            this.writeToken(ASEmitterTokens.TERNARY);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.NULL);
            this.write(ASEmitterTokens.PAREN_CLOSE);
        } else {
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            if (id != ASTNodeID.Op_CommaID) {
                this.write(ASEmitterTokens.SPACE);
            }
            if (id == ASTNodeID.Op_LogicalAndAssignID || id == ASTNodeID.Op_LogicalOrAssignID) {
                IExpressionNode lnode = node.getLeftOperandNode();
                this.writeToken(ASEmitterTokens.EQUAL);
                this.getWalker().walk((IASNode)lnode);
                this.write(ASEmitterTokens.SPACE);
                this.write(id == ASTNodeID.Op_LogicalAndAssignID ? ASEmitterTokens.LOGICAL_AND : ASEmitterTokens.LOGICAL_OR);
            } else {
                this.write(node.getOperator().getOperatorText());
            }
            this.write(ASEmitterTokens.SPACE);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
        }
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    protected void emitClosureStart(FunctionNode node) {
        this.write(JSGoogEmitterTokens.GOOG_BIND);
        this.write(ASEmitterTokens.PAREN_OPEN);
    }

    protected void emitClosureEnd(FunctionNode node, IDefinition nodeDef) {
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    public void emitContainer(IContainerNode node) {
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            IASNode child = node.getChild(i);
            if (i == 0) {
                this.getWalker().walk(child);
            } else {
                String s = this.stringifyNode(child);
                if (s.startsWith("var ")) {
                    s = s.substring(4);
                    this.write(s);
                }
            }
            if (i >= len - 1) continue;
            this.write(", ");
        }
    }
}

