/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Stack;
import org.apache.royale.compiler.codegen.ISourceMapEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.codegen.js.IJSWriter;
import org.apache.royale.compiler.codegen.js.IMappingEmitter;
import org.apache.royale.compiler.driver.js.IJSBackend;
import org.apache.royale.compiler.internal.codegen.js.JSFilterWriter;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.visitor.as.IASBlockWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSWriter
implements IJSWriter {
    protected RoyaleJSProject project;
    protected List<ICompilerProblem> problems;
    protected ICompilationUnit compilationUnit;
    private boolean enableDebug;
    private boolean isExterns = false;

    public boolean isExterns() {
        return this.isExterns;
    }

    public JSWriter(RoyaleJSProject project, List<ICompilerProblem> problems, ICompilationUnit compilationUnit, boolean enableDebug) {
        this.project = project;
        this.problems = problems;
        this.compilationUnit = compilationUnit;
        this.enableDebug = enableDebug;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void writeTo(OutputStream out) {
        this.writeTo(out, null, null);
    }

    @Override
    public int writeTo(File out) throws IOException {
        return 0;
    }

    @Override
    public void writeTo(OutputStream jsOut, OutputStream jsSourceMapOut, File sourceMapFile) {
        IJSBackend backend = (IJSBackend)this.project.getBackend();
        JSFilterWriter writer = (JSFilterWriter)backend.createWriterBuffer(this.project);
        IJSEmitter emitter = (IJSEmitter)backend.createEmitter(writer);
        IASBlockWalker walker = backend.createWalker(this.project, this.problems, emitter);
        walker.visitCompilationUnit(this.compilationUnit);
        this.isExterns = emitter.getModel().isExterns;
        try {
            String emitted = writer.toString();
            if (!this.isExterns) {
                emitted = emitter.postProcess(emitted);
            }
            jsOut.write(emitted.getBytes("utf8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (jsSourceMapOut != null) {
            String sourceMapFilePath = null;
            String sourceRoot = null;
            if (sourceMapFile != null) {
                sourceMapFilePath = sourceMapFile.getAbsolutePath();
                this.convertMappingSourcePathsToRelative(emitter, sourceMapFile);
            } else {
                sourceRoot = System.getProperty("user.dir");
                this.convertMappingSourcePathsToRelative(emitter, new File(sourceRoot, "test.js.map"));
                sourceRoot = this.convertSourcePathToURI(sourceRoot);
            }
            this.convertMappingSourcePathsToURI(emitter);
            File compilationUnitFile = new File(this.compilationUnit.getAbsoluteFilename());
            ISourceMapEmitter sourceMapEmitter = backend.createSourceMapEmitter(emitter);
            try {
                String fileName = compilationUnitFile.getName();
                fileName = fileName.replace(".as", ".js");
                String sourceMap = sourceMapEmitter.emitSourceMap(fileName, sourceMapFilePath, sourceRoot);
                jsSourceMapOut.write(sourceMap.getBytes("utf8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void convertMappingSourcePathsToRelative(IMappingEmitter emitter, File relativeToFile) {
        List<IMappingEmitter.SourceMapMapping> mappings = emitter.getSourceMapMappings();
        for (IMappingEmitter.SourceMapMapping mapping : mappings) {
            String relativePath;
            mapping.sourcePath = relativePath = this.relativize(mapping.sourcePath, relativeToFile.getAbsolutePath());
        }
    }

    protected void convertMappingSourcePathsToURI(IMappingEmitter emitter) {
        List<IMappingEmitter.SourceMapMapping> mappings = emitter.getSourceMapMappings();
        for (IMappingEmitter.SourceMapMapping mapping : mappings) {
            String sourcePath = mapping.sourcePath;
            mapping.sourcePath = sourcePath = this.convertSourcePathToURI(sourcePath);
        }
    }

    protected String convertSourcePathToURI(String sourcePath) {
        File file = new File(sourcePath);
        if (file.isAbsolute()) {
            sourcePath = "file:///" + sourcePath;
        }
        return sourcePath.replace('\\', '/');
    }

    private String relativize(String filePath, String relativeToFilePath) {
        boolean caseInsensitive = System.getProperty("os.name").toLowerCase().startsWith("windows");
        if (caseInsensitive) {
            relativeToFilePath = relativeToFilePath.toLowerCase();
        }
        File currentFile = new File(filePath);
        Stack<String> stack = new Stack<String>();
        stack.push(currentFile.getName());
        for (currentFile = currentFile.getParentFile(); currentFile != null; currentFile = currentFile.getParentFile()) {
            String absoluteCurrentFile = currentFile.getAbsolutePath() + File.separator;
            if (caseInsensitive) {
                absoluteCurrentFile = absoluteCurrentFile.toLowerCase();
            }
            if (relativeToFilePath.startsWith(absoluteCurrentFile)) {
                String relativeRelativeToFile = relativeToFilePath.substring(absoluteCurrentFile.length());
                String result = "";
                for (int separatorCount = relativeRelativeToFile.length() - relativeRelativeToFile.replace(File.separator, "").length(); separatorCount > 0; --separatorCount) {
                    result = result + ".." + File.separator;
                }
                while (stack.size() > 0) {
                    result = result + (String)stack.pop();
                }
                return result;
            }
            stack.push(currentFile.getName() + File.separator);
        }
        return null;
    }
}

