/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.codegen.js.IJSPublisher;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;

public class JSPublisher
implements IJSPublisher {
    protected RoyaleJSProject project;
    protected File outputFolder;
    protected File outputParentFolder;
    protected Configuration configuration;

    public JSPublisher(RoyaleJSProject project, Configuration config) {
        this.project = project;
        this.configuration = config;
    }

    public File getOutputFolder() {
        this.outputFolder = new File(this.getOutputFilePath());
        if (!this.outputFolder.isDirectory()) {
            this.outputFolder = this.outputFolder.getParentFile();
        }
        this.outputParentFolder = this.outputFolder;
        this.setupOutputFolder();
        return this.outputFolder;
    }

    protected void setupOutputFolder() {
        if (!this.outputFolder.exists()) {
            this.outputFolder.mkdirs();
        }
    }

    private String getOutputFilePath() {
        if (this.configuration.getOutput() == null) {
            String extension = "." + this.project.getBackend().getOutputExtension();
            return FilenameUtils.removeExtension(this.configuration.getTargetFile()).concat(extension);
        }
        return this.configuration.getOutput();
    }

    public boolean publish(ProblemQuery problems) throws IOException {
        System.out.println("The project has been successfully compiled and optimized.");
        return true;
    }
}

