/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients.problems;

import java.util.HashSet;
import java.util.Set;
import org.apache.royale.compiler.clients.problems.IProblemFilter;
import org.apache.royale.compiler.config.ICompilerProblemSettings;
import org.apache.royale.compiler.problems.AbstractDeprecatedAPIProblem;
import org.apache.royale.compiler.problems.ArrayCastProblem;
import org.apache.royale.compiler.problems.AssignmentInConditionalProblem;
import org.apache.royale.compiler.problems.ConstNotInitializedProblem;
import org.apache.royale.compiler.problems.DateCastProblem;
import org.apache.royale.compiler.problems.DeprecatedConfigurationOptionProblem;
import org.apache.royale.compiler.problems.DuplicateQNameInSourcePathProblem;
import org.apache.royale.compiler.problems.DuplicateVariableDefinitionProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.IllogicalComparionWithNaNProblem;
import org.apache.royale.compiler.problems.IllogicalComparisonWithUndefinedProblem;
import org.apache.royale.compiler.problems.InstanceOfProblem;
import org.apache.royale.compiler.problems.NullUsedWhereOtherExpectedProblem;
import org.apache.royale.compiler.problems.OverlappingSourcePathProblem;
import org.apache.royale.compiler.problems.ScopedToDefaultNamespaceProblem;
import org.apache.royale.compiler.problems.SemanticWarningProblem;
import org.apache.royale.compiler.problems.StrictSemanticsProblem;
import org.apache.royale.compiler.problems.ThisUsedInClosureProblem;
import org.apache.royale.compiler.problems.VariableHasNoTypeDeclarationProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemSettingsFilter
implements IProblemFilter {
    private final ICompilerProblemSettings problemSettings;
    private final Set<Class<? extends ICompilerProblem>> filter = new HashSet<Class<? extends ICompilerProblem>>();

    public ProblemSettingsFilter(ICompilerProblemSettings problemSettings) {
        assert (problemSettings != null) : "Settings may not be null";
        this.problemSettings = problemSettings;
        this.init();
    }

    @Override
    public boolean accept(ICompilerProblem p) {
        for (Class<? extends ICompilerProblem> filterClass : this.filter) {
            if (!filterClass.isInstance(p)) continue;
            return false;
        }
        return true;
    }

    private void init() {
        this.setShowStrictSemantics(this.problemSettings.isStrict());
        this.setShowWarnings(this.problemSettings.showActionScriptWarnings());
        this.setShowDeprecationWarnings(this.problemSettings.showDeprecationWarnings());
        this.setShowBindingWarnings(this.problemSettings.showBindingWarnings());
        this.setShowMultipleDefinitionWarnings(this.problemSettings.showMultipleDefinitionWarnings());
        this.setShowUnusedTypeSelectorWarnings(this.problemSettings.showUnusedTypeSelectorWarnings());
        this.setAllowSourcePathOverlapWarnings(this.problemSettings.isSourcePathOverlapAllowed());
        this.setShowActionScriptWarnings();
    }

    private void setShowStrictSemantics(boolean isStrict) {
        this.setShowProblemByClass(StrictSemanticsProblem.class, isStrict);
    }

    private void setShowWarnings(boolean showWarnings) {
        this.setShowProblemByClass(SemanticWarningProblem.class, showWarnings);
    }

    private void setAllowSourcePathOverlapWarnings(boolean isSourcePathOverlapAllowed) {
        this.setShowProblemByClass(OverlappingSourcePathProblem.class, !isSourcePathOverlapAllowed);
    }

    private void setShowUnusedTypeSelectorWarnings(boolean showUnusedTypeSelectorWarnings) {
    }

    private void setShowBindingWarnings(boolean showBindingWarnings) {
    }

    private void setShowMultipleDefinitionWarnings(boolean b) {
        this.setShowProblemByClass(DuplicateQNameInSourcePathProblem.class, b);
    }

    private void setShowActionScriptWarnings() {
        this.setShowActionScriptWarning(AssignmentInConditionalProblem.class, 1100);
        this.setShowActionScriptWarning(ArrayCastProblem.class, 1112);
        this.setShowActionScriptWarning(DateCastProblem.class, 3575);
        this.setShowActionScriptWarning(IllogicalComparionWithNaNProblem.class, 1098);
        this.setShowActionScriptWarning(NullUsedWhereOtherExpectedProblem.class, 1102);
        this.setShowActionScriptWarning(IllogicalComparisonWithUndefinedProblem.class, 1012);
        this.setShowActionScriptWarning(ConstNotInitializedProblem.class, 1110);
        this.setShowActionScriptWarning(DuplicateVariableDefinitionProblem.class, 3596);
        this.setShowActionScriptWarning(InstanceOfProblem.class, 3555);
        this.setShowActionScriptWarning(ScopedToDefaultNamespaceProblem.class, 1084);
        this.setShowActionScriptWarning(VariableHasNoTypeDeclarationProblem.class, 1008);
        this.setShowActionScriptWarning(ThisUsedInClosureProblem.class, 20000);
    }

    private void setShowActionScriptWarning(Class<? extends ICompilerProblem> problem, int warningCode) {
        this.setShowProblemByClass(problem, this.problemSettings.checkActionScriptWarning(warningCode));
    }

    private void setShowDeprecationWarnings(boolean showWarnings) {
        this.setShowProblemByClass(AbstractDeprecatedAPIProblem.class, showWarnings);
        this.setShowProblemByClass(DeprecatedConfigurationOptionProblem.class, showWarnings);
    }

    private void setShowProblemByClass(Class<? extends ICompilerProblem> clazz, boolean enable) {
        if (enable) {
            this.filter.remove(clazz);
        } else {
            this.filter.add(clazz);
        }
    }
}

