/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients.problems;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.royale.compiler.clients.problems.IProblemFilter;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.problems.ICompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProblemPrinter {
    private ProblemFormatter formatter;
    private OutputStream outputStream;

    public ProblemPrinter(ProblemFormatter formatter, OutputStream outputStream) {
        this.formatter = formatter;
        this.outputStream = outputStream;
    }

    public ProblemPrinter(ProblemFormatter formatter) {
        this(formatter, System.err);
    }

    public int printProblems(Collection<ICompilerProblem> problems, IProblemFilter filter) {
        if (problems == null || problems.isEmpty()) {
            return 0;
        }
        ArrayList<ICompilerProblem> filteredProblems = new ArrayList<ICompilerProblem>();
        for (ICompilerProblem problem : problems) {
            if (filter != null && !filter.accept(problem)) continue;
            filteredProblems.add(problem);
        }
        return this.printProblems(filteredProblems);
    }

    public int printProblems(Iterable<ICompilerProblem> problems) {
        int problemCount = 0;
        PrintWriter writer = new PrintWriter(new PrintStream(this.outputStream));
        for (ICompilerProblem problem : problems) {
            writer.println(this.formatter.format(problem));
            ++problemCount;
        }
        writer.flush();
        return problemCount;
    }
}

