/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.tasks.configuration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.tasks.configuration.CompilationConfiguration;
import org.apache.royale.test.ant.tasks.configuration.TestRunConfiguration;
import org.apache.royale.test.ant.tasks.types.LoadConfig;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public class TaskConfiguration {
    private final String DEFAULT_WORKING_PATH = ".";
    private final String DEFAULT_REPORT_PATH = ".";
    private final List<String> VALID_PLAYERS = Arrays.asList("flash", "air", "html");
    private String player = "flash";
    private File reportDir = null;
    private File workingDir = null;
    private boolean verbose = false;
    private File royaleHome = null;
    private Project project;
    private CompilationConfiguration compilationConfiguration;
    private TestRunConfiguration testRunConfiguration;

    public TaskConfiguration(Project project) {
        this.project = project;
        this.compilationConfiguration = new CompilationConfiguration();
        this.testRunConfiguration = new TestRunConfiguration();
        if (project.getProperty("ROYALE_HOME") != null) {
            this.royaleHome = new File(project.getProperty("ROYALE_HOME"));
        }
    }

    protected boolean isValidURL(String urlStr) {
        try {
            URL url = new URL(urlStr);
            LoggingUtil.log("my protocol " + url.getProtocol().toString());
            if (url.getProtocol().toUpperCase().equals("HTTP") || url.getProtocol().toUpperCase().equals("HTTPS")) {
                LoggingUtil.log("Valid URL returning TRUE");
                return true;
            }
            LoggingUtil.log("Valid URL returning FALSE");
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public CompilationConfiguration getCompilationConfiguration() {
        return this.compilationConfiguration;
    }

    public TestRunConfiguration getTestRunConfiguration() {
        return this.testRunConfiguration;
    }

    public void setCommand(String commandPath) {
        this.testRunConfiguration.setCommand(this.project.resolveFile(commandPath));
    }

    public void setDisplay(int display) {
        this.testRunConfiguration.setDisplay(display);
    }

    public void setFailOnTestFailure(boolean failOnTestFailure) {
        this.testRunConfiguration.setFailOnTestFailure(failOnTestFailure);
    }

    public void setFailureProperty(String failureProperty) {
        this.testRunConfiguration.setFailureProperty(failureProperty);
    }

    public void addSource(FileSet fileset) {
        fileset.setProject(this.project);
        this.compilationConfiguration.addSource(fileset);
    }

    public void addTestSource(FileSet fileset) {
        fileset.setProject(this.project);
        this.compilationConfiguration.addTestSource(fileset);
    }

    public void addLibrary(FileSet fileset) {
        fileset.setProject(this.project);
        this.compilationConfiguration.addLibrary(fileset);
    }

    public void setHeadless(boolean headless) {
        this.testRunConfiguration.setHeadless(headless);
    }

    public void setLocalTrusted(boolean isLocalTrusted) {
        this.testRunConfiguration.setLocalTrusted(isLocalTrusted);
    }

    public void setPlayer(String player) {
        this.player = player;
    }

    public void setPort(int port) {
        this.testRunConfiguration.setPort(port);
    }

    public void setReportDir(String reportDirPath) {
        this.reportDir = this.project.resolveFile(reportDirPath);
    }

    public void setServerBufferSize(int serverBufferSize) {
        this.testRunConfiguration.setServerBufferSize(serverBufferSize);
    }

    public void setSocketTimeout(int socketTimeout) {
        this.testRunConfiguration.setSocketTimeout(socketTimeout);
    }

    public void setSwf(String swf) {
        File localFile = this.project.resolveFile(swf);
        if (localFile.exists()) {
            this.testRunConfiguration.setSwf(localFile);
            LoggingUtil.log("Local path to SWF was given and SWF property will be used.");
        } else if (this.isValidURL(swf)) {
            this.testRunConfiguration.setUrl(swf);
            LoggingUtil.log("Remote path to SWF was given, setting URL property instead of SWF");
        } else {
            LoggingUtil.log("SWF and URL not set, file did not resolve to a local path or a remote path, please verify your format and try again.");
        }
    }

    public void setSwf(File swf) {
        this.testRunConfiguration.setSwf(swf);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        LoggingUtil.VERBOSE = verbose;
    }

    public void setWorkingDir(String workingDirPath) {
        this.workingDir = this.project.resolveFile(workingDirPath);
    }

    public boolean shouldCompile() {
        File swf = this.testRunConfiguration.getSwf();
        boolean noTestSources = !this.compilationConfiguration.getTestSources().provided();
        return !noTestSources && (swf == null || !swf.exists());
    }

    public void verify() throws BuildException {
        this.validateSharedProperties();
        if (this.shouldCompile()) {
            this.compilationConfiguration.validate();
        }
        this.testRunConfiguration.validate();
        this.propagateSharedConfiguration();
    }

    protected void validateSharedProperties() throws BuildException {
        LoggingUtil.log("Validating task attributes ...");
        if (!this.VALID_PLAYERS.contains(this.player)) {
            throw new BuildException("The provided 'player' property value [" + this.player + "] must be either of the following values: " + this.VALID_PLAYERS.toString() + ".");
        }
        File swf = this.testRunConfiguration.getSwf();
        boolean noTestSources = !this.compilationConfiguration.getTestSources().provided();
        String swfURL = this.testRunConfiguration.getUrl();
        if (!(swf != null && swf.exists() || !noTestSources || swfURL != null && !swfURL.equals(""))) {
            throw new BuildException("The provided 'swf' property value [" + (swf == null ? "" : swf.getPath()) + "] could not be found or is not a valid remote URL.");
        }
        if (swf == null && swfURL != null && swfURL != "" && this.testRunConfiguration.isLocalTrusted()) {
            throw new BuildException("The provided 'swf' property points to a remote location.  Please set localTrusted = false or change the location of your swf to a local path.");
        }
        if (swf != null && !noTestSources) {
            throw new BuildException("Please specify the 'swf' property or use the 'testSource' element(s), but not both.");
        }
        if (!(this.royaleHome != null && this.royaleHome.exists() || !new String("air").equals(this.testRunConfiguration.getPlayer()) && !this.shouldCompile())) {
            throw new BuildException("Please specify, or verify the location for, the ROYALE_HOME property.  It is required when testing with 'air' as the player or when using the 'testSource' element.  It should point to the installation directory for an Apache Royale SDK.");
        }
    }

    protected void propagateSharedConfiguration() {
        LoggingUtil.log("Generating default values ...");
        this.compilationConfiguration.setPlayer(this.player);
        this.testRunConfiguration.setPlayer(this.player);
        this.compilationConfiguration.setRoyaleHome(this.royaleHome);
        this.testRunConfiguration.setRoyaleHome(this.royaleHome);
        if (this.workingDir == null || !this.workingDir.exists()) {
            this.workingDir = this.project.resolveFile(".");
            LoggingUtil.log("Using default working dir [" + this.workingDir.getAbsolutePath() + "]");
        }
        this.workingDir.mkdirs();
        this.compilationConfiguration.setWorkingDir(this.workingDir);
        if (this.reportDir == null || !this.reportDir.exists()) {
            this.reportDir = this.project.resolveFile(".");
            LoggingUtil.log("Using default reporting dir [" + this.reportDir.getAbsolutePath() + "]");
        }
        this.reportDir.mkdir();
        this.testRunConfiguration.setReportDir(this.reportDir);
    }

    public void setDebug(boolean value) {
        this.compilationConfiguration.setDebug(value);
    }

    public void setLoadConfig(LoadConfig loadconfig) {
        this.compilationConfiguration.setLoadConfig(loadconfig);
    }
}

