/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.tasks;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.royale.test.ant.IRoyaleUnitServer;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.RoyaleUnitSocketServer;
import org.apache.royale.test.ant.RoyaleUnitSocketThread;
import org.apache.royale.test.ant.RoyaleUnitWebSocketServer;
import org.apache.royale.test.ant.launcher.commands.player.AdlCommand;
import org.apache.royale.test.ant.launcher.commands.player.PlayerCommand;
import org.apache.royale.test.ant.launcher.commands.player.PlayerCommandFactory;
import org.apache.royale.test.ant.launcher.contexts.ExecutionContext;
import org.apache.royale.test.ant.launcher.contexts.ExecutionContextFactory;
import org.apache.royale.test.ant.report.Reports;
import org.apache.royale.test.ant.tasks.configuration.TestRunConfiguration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRun {
    private final String TRUE = "true";
    private TestRunConfiguration configuration;
    private Project project;
    private Reports reports;

    public TestRun(Project project, TestRunConfiguration configuration) {
        this.project = project;
        this.configuration = configuration;
        this.reports = new Reports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws BuildException {
        this.configuration.log();
        try {
            Future<Object> daemon = this.setupSocketThread();
            PlayerCommand player = this.obtainPlayer();
            ExecutionContext context = this.obtainContext(player);
            context.start();
            Process process = player.launch();
            try {
                daemon.get();
            }
            finally {
                context.stop(process);
            }
            this.analyzeReports();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected PlayerCommand obtainPlayer() {
        PlayerCommand command = PlayerCommandFactory.createPlayer(this.configuration.getOs(), this.configuration.getPlayer(), this.configuration.getCommand(), this.configuration.isLocalTrusted());
        command.setProject(this.project);
        command.setSwf(this.configuration.getSwf());
        command.setUrl(this.configuration.getUrl());
        if (command instanceof AdlCommand) {
            ((AdlCommand)command).setPrecompiledAppDescriptor(this.configuration.getPrecompiledAppDescriptor());
        }
        return command;
    }

    protected ExecutionContext obtainContext(PlayerCommand player) {
        ExecutionContext context = ExecutionContextFactory.createContext(this.configuration.getOs(), this.configuration.isHeadless(), this.configuration.getDisplay());
        context.setProject(this.project);
        context.setCommand(player);
        return context;
    }

    protected Future<Object> setupSocketThread() {
        LoggingUtil.log("Setting up server process ...");
        IRoyaleUnitServer server = null;
        server = this.configuration.getPlayer().equals("html") ? new RoyaleUnitWebSocketServer(this.configuration.getPort(), this.configuration.getSocketTimeout()) : new RoyaleUnitSocketServer(this.configuration.getPort(), this.configuration.getSocketTimeout(), this.configuration.getServerBufferSize(), this.configuration.usePolicyFile());
        RoyaleUnitSocketThread operation = new RoyaleUnitSocketThread(server, this.configuration.getReportDir(), this.reports);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        return executor.submit(operation);
    }

    protected void analyzeReports() {
        LoggingUtil.log("Analyzing reports ...");
        LoggingUtil.log("\n" + this.reports.getSummary(), true);
        if (this.reports.hasFailures()) {
            this.project.setNewProperty(this.configuration.getFailureProperty(), "true");
            if (this.configuration.isFailOnTestFailure()) {
                throw new BuildException("RoyaleUnit tests failed during the test run.");
            }
        }
    }
}

