/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.report;

import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.royale.test.ant.report.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reports
extends HashMap<String, Report> {
    private static final long serialVersionUID = 2078272511659655555L;
    private static final String TEST_INFO = "Tests run: {0}, Failures: {1}, Errors: {2}, Skipped: {3}, Time elapsed: {4} sec";

    public String getSummary() {
        String summary = "";
        int runs = 0;
        int errors = 0;
        int failures = 0;
        int skips = 0;
        long time = 0L;
        for (Report report : this.values()) {
            runs += report.suite.getTests();
            errors += report.suite.getErrors();
            failures += report.suite.getFailures();
            skips += report.suite.getSkips();
            time += report.suite.getTime();
            summary = summary + report.getSummary() + "\n";
        }
        summary = summary + "\nResults :\n\n";
        try {
            summary = summary + MessageFormat.format(TEST_INFO, new Integer(runs), new Integer(failures), new Integer(errors), new Integer(skips), this.formatTime(time));
        }
        catch (Exception e) {
            summary = summary + "Error occurred while generating summary ...";
        }
        summary = summary + "\n";
        return summary;
    }

    private String formatTime(long time) {
        return String.format("%.3f", new Double((double)time / 1000.0));
    }

    public boolean hasFailures() {
        for (Report report : this.values()) {
            if (!report.hasFailures()) continue;
            return true;
        }
        return false;
    }
}

