/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.types;

import flash.swf.Tag;
import flash.swf.tags.DefineFont;
import flash.swf.types.GlyphEntry;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextRecord {
    private static final int HAS_FONT = 8;
    private static final int HAS_COLOR = 4;
    private static final int HAS_X = 1;
    private static final int HAS_Y = 2;
    private static final int HAS_HEIGHT = 8;
    public int flags = 128;
    public int color;
    public int xOffset;
    public int yOffset;
    public int height;
    public DefineFont font;
    public GlyphEntry[] entries;

    public void getReferenceList(List<Tag> refs) {
        if (this.hasFont() && this.font != null) {
            refs.add(this.font);
        }
    }

    public boolean hasFont() {
        return (this.flags & 8) != 0;
    }

    public boolean hasColor() {
        return (this.flags & 4) != 0;
    }

    public boolean hasX() {
        return (this.flags & 1) != 0;
    }

    public boolean hasY() {
        return (this.flags & 2) != 0;
    }

    public boolean hasHeight() {
        return (this.flags & 8) != 0;
    }

    public void setFont(DefineFont font) {
        this.font = font;
        this.flags |= 8;
    }

    public void setHeight(int i) {
        this.height = i;
        this.flags |= 8;
    }

    public void setColor(int color) {
        this.flags |= 4;
        this.color = color;
    }

    public void setX(int xOffset) {
        this.xOffset = xOffset;
        this.flags |= 1;
    }

    public void setY(int yOffset) {
        this.yOffset = yOffset;
        this.flags |= 2;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object instanceof TextRecord) {
            TextRecord textRecord = (TextRecord)object;
            if (textRecord.flags == this.flags && textRecord.color == this.color && textRecord.xOffset == this.xOffset && textRecord.yOffset == this.yOffset && textRecord.height == this.height && textRecord.font == this.font && Arrays.equals(textRecord.entries, this.entries)) {
                isEqual = true;
            }
        }
        return isEqual;
    }
}

