/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients.problems;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.royale.compiler.clients.problems.IProblemFilter;
import org.apache.royale.compiler.problems.ICompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemFilterClassCriteria
implements IProblemFilter {
    private Set<Class<?>> classesToFilterOut;
    private Set<Class<?>> classesToRequire;

    public ProblemFilterClassCriteria(Class<?> ... classesToFilterOut) {
        this.classesToFilterOut = new HashSet(Arrays.asList(classesToFilterOut));
        this.classesToRequire = new HashSet();
    }

    public ProblemFilterClassCriteria(Set<Class<?>> classesToFilterOut, Set<Class<?>> classesToRequire) {
        this.classesToFilterOut = classesToFilterOut;
        this.classesToRequire = classesToRequire;
    }

    public void addRejectedClass(Class<?> clazz) {
        assert (!this.classesToRequire.contains(clazz));
        this.classesToFilterOut.add(clazz);
    }

    public void removeRejectedClass(Class<?> clazz) {
        this.classesToFilterOut.remove(clazz);
    }

    public void addRequiredClass(Class<?> clazz) {
        assert (!this.classesToFilterOut.contains(clazz));
        this.classesToRequire.add(clazz);
    }

    @Override
    public boolean accept(ICompilerProblem p) {
        for (Class<?> filter : this.classesToFilterOut) {
            if (!filter.isInstance(p)) continue;
            return false;
        }
        for (Class<?> filter : this.classesToRequire) {
            if (filter.isInstance(p)) continue;
            return false;
        }
        return true;
    }
}

