/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.css.ICSSManager;
import org.apache.royale.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.royale.compiler.internal.css.semantics.ActivatedStyleSheets;
import org.apache.royale.compiler.internal.driver.js.royale.JSCSSCompilationSession;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.targets.JSTarget;
import org.apache.royale.compiler.internal.targets.RoyaleApplicationFrame1Info;
import org.apache.royale.compiler.internal.targets.Target;
import org.apache.royale.compiler.problems.FileNotFoundProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.targets.IJSTarget;
import org.apache.royale.compiler.targets.ITargetProgressMonitor;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoyaleJSTarget
extends JSTarget
implements IJSTarget {
    private final RoyaleJSProject royaleProject;

    public RoyaleJSTarget(RoyaleJSProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) {
        super(project, targetSettings, progressMonitor);
        this.royaleProject = project;
    }

    protected Set<ICompilationUnit> findAllCompilationUnitsToLink(Collection<ICompilationUnit> compilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
        JSCSSCompilationSession cssCompilationSession = (JSCSSCompilationSession)this.royaleProject.getCSSCompilationSession();
        cssCompilationSession.setKeepAllTypeSelectors(this.targetSettings.keepAllTypeSelectors());
        cssCompilationSession.setExcludeDefaultsCSSFiles(this.targetSettings.getExcludeDefaultsCSSFiles());
        for (ICompilationUnit cu : compilationUnits) {
            cu.startBuildAsync(this.getTargetType());
        }
        assert (compilationUnits != null) : "compilation units can't be null";
        assert (problems != null) : "problems can't be null";
        HashSet<ICompilationUnit> allCompilationUnitsInTarget = new HashSet<ICompilationUnit>(compilationUnits);
        ActivatedStyleSheets activatedStyleSheets = new ActivatedStyleSheets();
        ICSSManager cssManager = this.royaleProject.getCSSManager();
        this.collectThemes(cssManager, activatedStyleSheets, problems);
        this.collectDefaultCSS(cssManager, activatedStyleSheets, problems);
        boolean done = false;
        while (!done) {
            Collection dependentCUListFromCSS;
            Set dependencies = this.getDependentCompilationUnits(allCompilationUnitsInTarget, problems);
            allCompilationUnitsInTarget.addAll(dependencies);
            Map<ICSSDocument, File> activatedDefaultCSSList = RoyaleJSTarget.getAllDefaultCSS(cssManager, allCompilationUnitsInTarget);
            for (Map.Entry<ICSSDocument, File> entry : activatedDefaultCSSList.entrySet()) {
                activatedStyleSheets.addLibraryCSS(entry.getKey(), entry.getValue().getAbsolutePath());
            }
            ImmutableList definitions = Target.getAllExternallyVisibleDefinitions(allCompilationUnitsInTarget);
            HashSet cssDependencies = new HashSet();
            for (ICSSDocument cssDocument : cssCompilationSession.cssDocuments) {
                dependentCUListFromCSS = cssManager.getDependentCompilationUnitsFromCSS((CSSCompilationSession)cssCompilationSession, cssDocument, (Collection)definitions, problems);
                cssDependencies.addAll(dependentCUListFromCSS);
            }
            for (ICSSDocument cssDocument : activatedStyleSheets.all()) {
                dependentCUListFromCSS = cssManager.getDependentCompilationUnitsFromCSS((CSSCompilationSession)cssCompilationSession, cssDocument, (Collection)definitions, problems);
                cssDependencies.addAll(dependentCUListFromCSS);
            }
            done = !allCompilationUnitsInTarget.addAll(cssDependencies);
        }
        cssCompilationSession.cssDocuments.addAll(0, activatedStyleSheets.sort());
        return super.findAllCompilationUnitsToLink(compilationUnits, problems);
    }

    private void collectThemes(ICSSManager cssManager, ActivatedStyleSheets activatedStyleSheets, Collection<ICompilerProblem> problems) {
        Collection cssFromThemes = cssManager.getCSSFromThemes(problems);
        for (ICSSDocument themeCSS : cssFromThemes) {
            activatedStyleSheets.addThemeCSS(themeCSS);
        }
    }

    private void collectDefaultCSS(ICSSManager cssManager, ActivatedStyleSheets activatedStyleSheets, Collection<ICompilerProblem> problems) {
        for (String defaultsCSSPath : this.getTargetSettings().getDefaultsCSSFiles()) {
            ICSSDocument defaultsCSSModel = cssManager.getCSS(defaultsCSSPath);
            if (defaultsCSSModel == null) {
                problems.add((ICompilerProblem)new FileNotFoundProblem(defaultsCSSPath));
                continue;
            }
            activatedStyleSheets.addDefaultCSS(defaultsCSSModel);
        }
    }

    private static Map<ICSSDocument, File> getAllDefaultCSS(ICSSManager cssManager, Collection<ICompilationUnit> compilationUnits) {
        assert (cssManager != null) : "Expected CSS manager.";
        assert (compilationUnits != null) : "Expected collection of compilation units.";
        HashMap<ICSSDocument, File> result = new HashMap<ICSSDocument, File>();
        for (ICompilationUnit compilationUnit : compilationUnits) {
            File swcFile;
            ICSSDocument defaultCSS;
            if (compilationUnit.getCompilationUnitType() != ICompilationUnit.UnitType.SWC_UNIT || (defaultCSS = cssManager.getDefaultCSS(swcFile = new File(compilationUnit.getAbsoluteFilename()))) == null) continue;
            result.put(defaultCSS, swcFile);
        }
        return result;
    }

    public void collectMixinMetaData(TreeSet<String> mixinClassNames, List<ICompilationUnit> units) {
        for (ICompilationUnit unit : units) {
            try {
                RoyaleApplicationFrame1Info.collectMixinMetaData(mixinClassNames, (ICompilationUnit)unit);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void collectRemoteClassMetaData(Map<String, String> remoteClassAliasMap, List<ICompilationUnit> units) {
        for (ICompilationUnit unit : units) {
            try {
                RoyaleApplicationFrame1Info.collectRemoteClassMetaData(remoteClassAliasMap, (ICompilationUnit)unit);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

