/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.royale.compiler.driver.js.IJSApplication;
import org.apache.royale.compiler.exceptions.BuildCanceledException;
import org.apache.royale.compiler.internal.driver.js.JSApplication;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.targets.Target;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.targets.IJSTarget;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetProgressMonitor;
import org.apache.royale.compiler.targets.ITargetReport;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSTarget
extends Target
implements IJSTarget {
    protected ICompilationUnit mainCU;
    protected Target.RootedCompilationUnits rootedCompilationUnits;

    public JSTarget(RoyaleJSProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) {
        super((CompilerProject)project, targetSettings, progressMonitor);
    }

    public ITarget.TargetType getTargetType() {
        return null;
    }

    protected ITargetReport computeTargetReport() throws InterruptedException {
        return null;
    }

    protected Target.RootedCompilationUnits computeRootedCompilationUnits() throws InterruptedException {
        if (this.mainCU != null) {
            return new Target.RootedCompilationUnits(ImmutableSet.of(this.mainCU), Collections.emptyList());
        }
        return new Target.RootedCompilationUnits(Collections.emptySet(), Collections.emptyList());
    }

    public Target.RootedCompilationUnits getRootedCompilationUnits() throws InterruptedException {
        if (this.rootedCompilationUnits == null) {
            this.rootedCompilationUnits = this.computeRootedCompilationUnits();
        }
        return this.rootedCompilationUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJSApplication build(Collection<ICompilerProblem> problems) {
        this.buildStarted();
        try {
            IJSApplication application;
            Iterable fatalProblems = this.getFatalProblems();
            if (!Iterables.isEmpty(fatalProblems)) {
                Iterables.addAll(problems, fatalProblems);
                IJSApplication iJSApplication = null;
                return iJSApplication;
            }
            HashSet<ICompilationUnit> compilationUnitSet = new HashSet<ICompilationUnit>();
            Target.RootedCompilationUnits rootedCompilationUnits = this.getRootedCompilationUnits();
            Iterables.addAll(problems, rootedCompilationUnits.getProblems());
            compilationUnitSet.addAll(rootedCompilationUnits.getUnits());
            this.buildAndCollectProblems(compilationUnitSet, problems);
            List reachableCompilationUnits = this.project.getReachableCompilationUnitsInSWFOrder((Collection)rootedCompilationUnits.getUnits());
            IJSApplication iJSApplication = application = this.initializeApplication(reachableCompilationUnits);
            return iJSApplication;
        }
        catch (BuildCanceledException bce) {
            IJSApplication iJSApplication = null;
            return iJSApplication;
        }
        catch (InterruptedException ie) {
            IJSApplication iJSApplication = null;
            return iJSApplication;
        }
        finally {
            this.buildFinished();
        }
    }

    protected IJSApplication initializeApplication(List<ICompilationUnit> reachableCompilationUnits) {
        JSApplication result = new JSApplication();
        return result;
    }

    protected void buildAndCollectProblems(Set<ICompilationUnit> compilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
        Target.BuiltCompilationUnitSet builtCompilationUnits = this.getBuiltCompilationUnitSet();
        ICompilationUnit rootCU = this.getRootClassCompilationUnit();
        compilationUnits.clear();
        compilationUnits.add(rootCU);
        Iterables.addAll(problems, builtCompilationUnits.problems);
    }

    private ICompilationUnit getRootClassCompilationUnit() {
        String rootClassFileName = this.targetSettings.getRootSourceFileName();
        if (rootClassFileName == null) {
            return null;
        }
        Collection rootClassCompilationUnits = this.project.getCompilationUnits(rootClassFileName);
        assert (rootClassCompilationUnits.size() == 1) : "There must only be a single compilation unit for the root source file!";
        return (ICompilationUnit)Iterables.getOnlyElement(rootClassCompilationUnits);
    }

    public IJSApplication build(ICompilationUnit unit, Collection<ICompilerProblem> problems) {
        this.mainCU = unit;
        return this.build(problems);
    }
}

