/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.compiler.utils.ASNodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryOperatorEmitter
extends JSSubEmitter
implements ISubEmitter<IUnaryOperatorNode> {
    public UnaryOperatorEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IUnaryOperatorNode node) {
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        if (node.getNodeID() == ASTNodeID.Op_PreIncrID || node.getNodeID() == ASTNodeID.Op_PreDecrID || node.getNodeID() == ASTNodeID.Op_BitwiseNotID || node.getNodeID() == ASTNodeID.Op_LogicalNotID || node.getNodeID() == ASTNodeID.Op_SubtractID || node.getNodeID() == ASTNodeID.Op_AddID) {
            this.emitPreUnaryOperator(node);
        } else if (node.getNodeID() == ASTNodeID.Op_PostIncrID || node.getNodeID() == ASTNodeID.Op_PostDecrID) {
            this.emitPostUnaryOperator(node);
        } else if (node.getNodeID() == ASTNodeID.Op_DeleteID) {
            this.emitDeleteOperator(node);
        } else if (node.getNodeID() == ASTNodeID.Op_VoidID) {
            this.emitVoidOperator(node);
        } else if (node.getNodeID() == ASTNodeID.Op_TypeOfID) {
            this.emitTypeOfOperator(node);
        }
        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    public void emitPreUnaryOperator(IUnaryOperatorNode node) {
        this.startMapping((ISourceLocation)node);
        this.write(node.getOperator().getOperatorText());
        IExpressionNode opNode = node.getOperandNode();
        this.endMapping((ISourceLocation)node);
        this.getWalker().walk((IASNode)opNode);
    }

    protected void emitPostUnaryOperator(IUnaryOperatorNode node) {
        IExpressionNode operandNode = node.getOperandNode();
        this.getWalker().walk((IASNode)operandNode);
        this.startMapping((ISourceLocation)node, (ISourceLocation)operandNode);
        this.write(node.getOperator().getOperatorText());
        this.endMapping((ISourceLocation)node);
    }

    protected void emitDeleteOperator(IUnaryOperatorNode node) {
        this.startMapping((ISourceLocation)node);
        this.writeToken(node.getOperator().getOperatorText());
        this.endMapping((ISourceLocation)node);
        this.getWalker().walk((IASNode)node.getOperandNode());
    }

    protected void emitVoidOperator(IUnaryOperatorNode node) {
        this.startMapping((ISourceLocation)node);
        this.writeToken(node.getOperator().getOperatorText());
        this.endMapping((ISourceLocation)node);
        this.getWalker().walk((IASNode)node.getOperandNode());
    }

    protected void emitTypeOfOperator(IUnaryOperatorNode node) {
        this.startMapping((ISourceLocation)node);
        this.write(node.getOperator().getOperatorText());
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.endMapping((ISourceLocation)node);
        IExpressionNode operandNode = node.getOperandNode();
        this.getWalker().walk((IASNode)operandNode);
        this.startMapping((ISourceLocation)node);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.endMapping((ISourceLocation)node);
    }
}

