/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.as;

import java.util.List;
import org.apache.royale.compiler.codegen.as.IASEmitter;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.LabeledStatementNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem2;
import org.apache.royale.compiler.projects.IASProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IBlockNode;
import org.apache.royale.compiler.tree.as.ICatchNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IDefaultXMLNamespaceNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IEmbedNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IFunctionObjectNode;
import org.apache.royale.compiler.tree.as.IGetterNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IIfNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.IIterationFlowNode;
import org.apache.royale.compiler.tree.as.IKeywordNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.ILiteralContainerNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.compiler.tree.as.INumericLiteralNode;
import org.apache.royale.compiler.tree.as.IObjectLiteralValuePairNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IReturnNode;
import org.apache.royale.compiler.tree.as.ISetterNode;
import org.apache.royale.compiler.tree.as.ISwitchNode;
import org.apache.royale.compiler.tree.as.ITerminalNode;
import org.apache.royale.compiler.tree.as.ITernaryOperatorNode;
import org.apache.royale.compiler.tree.as.IThrowNode;
import org.apache.royale.compiler.tree.as.ITryNode;
import org.apache.royale.compiler.tree.as.ITypedExpressionNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.compiler.tree.as.IUseNamespaceNode;
import org.apache.royale.compiler.tree.as.IVariableExpressionNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.as.IWhileLoopNode;
import org.apache.royale.compiler.tree.as.IWithNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.ISyntaxTreeRequestResult;
import org.apache.royale.compiler.utils.DefinitionUtils;
import org.apache.royale.compiler.visitor.IASNodeStrategy;
import org.apache.royale.compiler.visitor.as.IASBlockVisitor;
import org.apache.royale.compiler.visitor.as.IASBlockWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASBlockWalker
implements IASBlockVisitor,
IASBlockWalker {
    boolean isDebug;
    private IASEmitter emitter;
    private final List<ICompilerProblem> errors;
    private IASNodeStrategy strategy;
    private IASProject project;

    @Override
    public IASEmitter getEmitter() {
        return this.emitter;
    }

    @Override
    public List<ICompilerProblem> getErrors() {
        return this.errors;
    }

    public IASNodeStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(IASNodeStrategy value) {
        this.strategy = value;
    }

    public IASProject getProject() {
        return this.project;
    }

    public ASBlockWalker(List<ICompilerProblem> errors, IASProject project, IASEmitter emitter) {
        this.errors = errors;
        this.project = project;
        this.emitter = emitter;
        emitter.setWalker(this);
    }

    @Override
    public void walk(IASNode node) {
        try {
            this.getStrategy().handle(node);
        }
        catch (Exception e) {
            String sp = String.format("%s line %d column %d", node.getSourcePath(), node.getLine() + 1, node.getColumn());
            if (node.getSourcePath() == null) {
                IASNode parent = node.getParent();
                sp = String.format("%s line %d column %d", parent.getSourcePath(), parent.getLine() + 1, parent.getColumn());
            }
            InternalCompilerProblem2 problem = new InternalCompilerProblem2(sp, (Throwable)e, "ASBlockWalker");
            this.errors.add((ICompilerProblem)problem);
        }
    }

    @Override
    public void visitCompilationUnit(ICompilationUnit unit) {
        this.debug("visitCompilationUnit()");
        IFileNode node = null;
        try {
            node = (IFileNode)((ISyntaxTreeRequestResult)unit.getSyntaxTreeRequest().get()).getAST();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.walk((IASNode)node);
    }

    @Override
    public void visitFile(IFileNode node) {
        this.debug("visitFile()");
        boolean foundPackage = false;
        int nodeCount = node.getChildCount();
        for (int i = 0; i < nodeCount; ++i) {
            IASNode pnode = node.getChild(i);
            if (pnode == null) continue;
            boolean isPackage = pnode instanceof IPackageNode;
            boolean isAllowedAfterPackage = false;
            if (isPackage) {
                foundPackage = true;
            } else if (foundPackage) {
                boolean bl = isAllowedAfterPackage = pnode instanceof IInterfaceNode || pnode instanceof IClassNode || pnode instanceof IFunctionNode || pnode instanceof INamespaceNode || pnode instanceof IVariableNode;
            }
            if (!isPackage && !isAllowedAfterPackage) continue;
            this.walk(pnode);
            if (i >= nodeCount - 1) continue;
            this.emitter.writeNewline();
            this.emitter.writeNewline();
            this.emitter.writeNewline();
        }
    }

    @Override
    public void visitPackage(IPackageNode node) {
        this.debug("visitPackage()");
        IPackageDefinition definition = (IPackageDefinition)node.getDefinition();
        this.emitter.emitPackageHeader(definition);
        this.emitter.emitPackageHeaderContents(definition);
        this.emitter.emitPackageContents(definition);
        this.emitter.emitPackageFooter(definition);
    }

    @Override
    public void visitClass(IClassNode node) {
        this.debug("visitClass()");
        this.emitter.emitClass(node);
    }

    @Override
    public void visitInterface(IInterfaceNode node) {
        this.debug("visitInterface()");
        this.emitter.emitInterface(node);
    }

    @Override
    public void visitVariable(IVariableNode node) {
        this.debug("visitVariable()");
        if (SemanticUtils.isPackageDefinition((IDefinition)node.getDefinition()) || SemanticUtils.isMemberDefinition((IDefinition)node.getDefinition()) || node.getParent() instanceof IFileNode) {
            this.emitter.emitField(node);
        } else {
            this.emitter.emitVarDeclaration(node);
        }
    }

    @Override
    public void visitFunction(IFunctionNode node) {
        this.debug("visitFunction()");
        if (SemanticUtils.isPackageDefinition((IDefinition)node.getDefinition()) || DefinitionUtils.isMemberDefinition((IDefinition)node.getDefinition()) || node.getParent() instanceof IFileNode) {
            this.emitter.emitMethod(node);
        } else {
            this.emitter.emitLocalNamedFunction(node);
        }
    }

    @Override
    public void visitParameter(IParameterNode node) {
        this.debug("visitParameter()");
        this.emitter.emitParameter(node);
    }

    @Override
    public void visitGetter(IGetterNode node) {
        this.debug("visitGetter()");
        this.emitter.emitGetAccessor(node);
    }

    @Override
    public void visitSetter(ISetterNode node) {
        this.debug("visitSetter()");
        this.emitter.emitSetAccessor(node);
    }

    @Override
    public void visitNamespace(INamespaceNode node) {
        this.debug("visitNamespace()");
        this.emitter.emitNamespace(node);
    }

    @Override
    public void visitFunctionCall(IFunctionCallNode node) {
        this.debug("visitFunctionCall()");
        this.emitter.emitFunctionCall(node);
    }

    @Override
    public void visitBlock(IBlockNode node) {
        this.debug("visitBlock()");
        ASTNodeID pnodeId = node.getParent().getNodeID();
        if (pnodeId == ASTNodeID.FunctionID || pnodeId == ASTNodeID.GetterID || pnodeId == ASTNodeID.SetterID) {
            this.emitter.emitFunctionBlockHeader((IFunctionNode)node.getParent());
        }
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            this.emitter.emitStatement(node.getChild(i));
        }
    }

    @Override
    public void visitIf(IIfNode node) {
        this.debug("visitIf()");
        this.emitter.emitIf(node);
    }

    @Override
    public void visitForLoop(IForLoopNode node) {
        this.debug("visitForLoop(" + node.getKind() + ")");
        if (node.getKind() == IForLoopNode.ForLoopKind.FOR) {
            this.visitFor(node);
        } else if (node.getKind() == IForLoopNode.ForLoopKind.FOR_EACH) {
            this.visitForEach(node);
        }
    }

    protected void visitForEach(IForLoopNode node) {
        this.debug("visitForEach()");
        this.emitter.emitForEachLoop(node);
    }

    protected void visitFor(IForLoopNode node) {
        this.debug("visitFor()");
        this.emitter.emitForLoop(node);
    }

    @Override
    public void visitSwitch(ISwitchNode node) {
        this.debug("visitSwitch()");
        this.emitter.emitSwitch(node);
    }

    @Override
    public void visitWhileLoop(IWhileLoopNode node) {
        this.debug("visitWhileLoopNode()");
        if (node.getKind() == IWhileLoopNode.WhileLoopKind.WHILE) {
            this.emitter.emitWhileLoop(node);
        } else if (node.getKind() == IWhileLoopNode.WhileLoopKind.DO) {
            this.emitter.emitDoLoop(node);
        }
    }

    @Override
    public void visitWith(IWithNode node) {
        this.debug("visitWith()");
        this.emitter.emitWith(node);
    }

    @Override
    public void visitThrow(IThrowNode node) {
        this.debug("visitThrow()");
        this.emitter.emitThrow(node);
    }

    @Override
    public void visitTry(ITryNode node) {
        this.debug("visitTry()");
        this.emitter.emitTry(node);
    }

    @Override
    public void visitCatch(ICatchNode node) {
        this.debug("visitCatch()");
        this.emitter.emitCatch(node);
    }

    @Override
    public void visitIterationFlow(IIterationFlowNode node) {
        this.debug("visitIterationFlow()");
        this.emitter.emitIterationFlow(node);
    }

    @Override
    public void visitIdentifier(IIdentifierNode node) {
        this.debug("visitIdentifier(" + node.getName() + ")");
        this.emitter.emitIdentifier(node);
    }

    @Override
    public void visitNumericLiteral(INumericLiteralNode node) {
        this.debug("visitNumericLiteral(" + node.getNumericValue() + ")");
        this.emitter.emitNumericLiteral(node);
    }

    @Override
    public void visitDefaultXMLNamespace(IDefaultXMLNamespaceNode node) {
        this.debug("visitDefaultXMLNamespace()");
        this.walk((IASNode)node.getKeywordNode());
        this.walk((IASNode)node.getExpressionNode());
    }

    @Override
    public void visitKeyword(IKeywordNode node) {
        this.debug("visitKeyword(" + node.getNodeID().getParaphrase() + ")");
        this.emitter.emitKeyword(node);
    }

    @Override
    public void visitLiteral(ILiteralNode node) {
        this.debug("visitLiteral(" + node.getValue() + ")");
        if (node.getLiteralType() == ILiteralNode.LiteralType.NUMBER || node.getLiteralType() == ILiteralNode.LiteralType.BOOLEAN || node.getLiteralType() == ILiteralNode.LiteralType.NULL || node.getLiteralType() == ILiteralNode.LiteralType.NUMBER || node.getLiteralType() == ILiteralNode.LiteralType.REGEXP || node.getLiteralType() == ILiteralNode.LiteralType.STRING || node.getLiteralType() == ILiteralNode.LiteralType.XML || node.getLiteralType() == ILiteralNode.LiteralType.VOID) {
            this.emitter.emitLiteral(node);
        } else if (node.getLiteralType() == ILiteralNode.LiteralType.ARRAY || node.getLiteralType() == ILiteralNode.LiteralType.OBJECT || node.getLiteralType() == ILiteralNode.LiteralType.VECTOR || node.getLiteralType() == ILiteralNode.LiteralType.XMLLIST) {
            this.emitter.emitLiteralContainer((ILiteralContainerNode)node);
        }
    }

    @Override
    public void visitMemberAccessExpression(IMemberAccessExpressionNode node) {
        this.debug("visitMemberAccessExpression()");
        this.emitter.emitMemberAccessExpression(node);
    }

    @Override
    public void visitNamespaceAccessExpression(INamespaceAccessExpressionNode node) {
        this.debug("visitNamespaceAccessExpression()");
        this.emitter.emitNamespaceAccessExpression(node);
    }

    @Override
    public void visitDynamicAccess(IDynamicAccessNode node) {
        this.debug("visitDynamicAccess()");
        this.emitter.emitDynamicAccess(node);
    }

    @Override
    public void visitTypedExpression(ITypedExpressionNode node) {
        this.debug("visitITypedExpression()");
        this.emitter.emitTypedExpression(node);
    }

    @Override
    public void visitAsOperator(IBinaryOperatorNode node) {
        this.debug("visitAsOperator()");
        this.emitter.emitAsOperator(node);
    }

    @Override
    public void visitIsOperator(IBinaryOperatorNode node) {
        this.debug("visitIsOperator()");
        this.emitter.emitIsOperator(node);
    }

    @Override
    public void visitBinaryOperator(IBinaryOperatorNode node) {
        this.debug("visitBinaryOperator(" + node.getOperator().getOperatorText() + ")");
        this.emitter.emitBinaryOperator(node);
    }

    @Override
    public void visitUnaryOperator(IUnaryOperatorNode node) {
        this.debug("visitUnaryOperator()");
        this.emitter.emitUnaryOperator(node);
    }

    @Override
    public void visitTerminal(ITerminalNode node) {
        this.debug("visitTerminal(" + node.getKind() + ")");
        this.walk(node.getStatementContentsNode());
    }

    @Override
    public void visitFunctionObject(IFunctionObjectNode node) {
        this.emitter.emitFunctionObject(node);
    }

    @Override
    public void visitVariableExpression(IVariableExpressionNode node) {
        this.debug("visitVariableExpression()");
        this.emitter.emitVariableExpression(node);
    }

    @Override
    public void visitExpression(IExpressionNode node) {
        this.debug("visitExpression()");
    }

    @Override
    public void visitImport(IImportNode node) {
        this.debug("visitImport()");
        this.emitter.emitImport(node);
    }

    @Override
    public void visitMetaTags(IMetaTagsNode node) {
        IMetaTagNode[] tags;
        this.debug("visitMetaTags()");
        for (IMetaTagNode tag : tags = node.getAllTags()) {
            this.walk((IASNode)tag);
        }
    }

    @Override
    public void visitMetaTag(IMetaTagNode node) {
        this.debug("visitMetaTag(" + node.getTagName() + ")");
        this.emitter.emitMetaTag(node);
    }

    @Override
    public void visitUseNamespace(IUseNamespaceNode node) {
        this.debug("visitUseNamespace(" + node.getTargetNamespace() + ")");
        this.emitter.emitUseNamespace(node);
    }

    @Override
    public void visitEmbed(IEmbedNode node) {
        this.debug("visitEmbed(" + node.getAttributes()[0].getValue() + ")");
        this.emitter.emitEmbed(node);
    }

    @Override
    public void visitContainer(IContainerNode node) {
        this.debug("visitContainer()");
        this.emitter.emitContainer(node);
    }

    @Override
    public void visitE4XFilter(IMemberAccessExpressionNode node) {
        this.debug("visitE4XFilter()");
        this.emitter.emitE4XFilter(node);
    }

    @Override
    public void visitReturn(IReturnNode node) {
        this.debug("visitReturn()");
        this.emitter.emitReturn(node);
    }

    @Override
    public void visitTernaryOperator(ITernaryOperatorNode node) {
        this.debug("visitTernaryOperator()");
        this.emitter.emitTernaryOperator(node);
    }

    @Override
    public void visitLabeledStatement(LabeledStatementNode node) {
        this.debug("visitLabeledStatement()");
        this.emitter.emitLabelStatement(node);
    }

    @Override
    public void visitObjectLiteralValuePair(IObjectLiteralValuePairNode node) {
        this.debug("visitIObjectLiteralValuePair()");
        this.emitter.emitObjectLiteralValuePair(node);
    }

    @Override
    public void visitLanguageIdentifierNode(ILanguageIdentifierNode node) {
        this.emitter.emitLanguageIdentifier(node);
    }

    protected void debug(String message) {
        if (this.isDebug) {
            System.out.println(message);
        }
    }
}

