/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.flex.tools.FlexTool;
import org.apache.royale.compiler.asdoc.IASDocDelegate;
import org.apache.royale.compiler.clients.JSCompilerEntryPoint;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.clients.problems.ProblemQueryProvider;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.codegen.js.IJSPublisher;
import org.apache.royale.compiler.codegen.js.IJSWriter;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.ConfigurationBuffer;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.driver.IBackend;
import org.apache.royale.compiler.driver.js.IJSApplication;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.config.FlashBuilderConfigurator;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.royale.compiler.internal.driver.js.node.NodeBackend;
import org.apache.royale.compiler.internal.parsing.as.RoyaleASDocDelegate;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.ISourceFileHandler;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.targets.JSTarget;
import org.apache.royale.compiler.internal.targets.RoyaleJSTarget;
import org.apache.royale.compiler.internal.units.ResourceModuleCompilationUnit;
import org.apache.royale.compiler.internal.units.SourceCompilationUnitFactory;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ConfigurationProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem;
import org.apache.royale.compiler.problems.UnableToBuildSWFProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.utils.ArgumentUtil;
import org.apache.royale.utils.FilenameNormalization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXMLJSCNode
implements JSCompilerEntryPoint,
ProblemQueryProvider,
FlexTool {
    protected Workspace workspace = new Workspace();
    protected RoyaleJSProject project;
    protected ProblemQuery problems;
    protected ISourceFileHandler asFileHandler;
    protected Configuration config;
    protected Configurator projectConfigurator;
    private ConfigurationBuffer configBuffer;
    private ICompilationUnit mainCU;
    protected ITarget target;
    protected ITargetSettings targetSettings;
    protected IJSApplication jsTarget;
    private IJSPublisher jsPublisher;

    public ProblemQuery getProblemQuery() {
        return this.problems;
    }

    public String getName() {
        return "MXMLC";
    }

    public int execute(String[] args) {
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        return this.mainNoExit(args, problems, true);
    }

    public static void main(String[] args) {
        int exitCode = MXMLJSCNode.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        long startTime = System.nanoTime();
        MXMLJSCNode mxmlc = new MXMLJSCNode();
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        int exitCode = mxmlc.mainNoExit(args, problems, true);
        long endTime = System.nanoTime();
        System.out.println((double)(endTime - startTime) / 1.0E9 + " seconds");
        return exitCode;
    }

    public MXMLJSCNode() {
        this(new NodeBackend());
    }

    protected MXMLJSCNode(IBackend backend) {
        this.workspace.setASDocDelegate((IASDocDelegate)new RoyaleASDocDelegate());
        this.project = new RoyaleJSProject(this.workspace, backend);
        this.problems = new ProblemQuery();
        this.asFileHandler = backend.getSourceFileHandlerInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int mainNoExit(String[] args, List<ICompilerProblem> problems, Boolean printProblems) {
        int exitCode = -1;
        try {
            exitCode = this._mainNoExit(ArgumentUtil.fixArgs((String[])args), problems);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        finally {
            if (problems != null && !problems.isEmpty() && printProblems.booleanValue()) {
                WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(this.workspace);
                ProblemPrinter printer = new ProblemPrinter((ProblemFormatter)formatter);
                printer.printProblems(problems);
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _mainNoExit(String[] args, List<ICompilerProblem> outProblems) {
        ExitCode exitCode;
        block11: {
            exitCode = ExitCode.SUCCESS;
            try {
                boolean continueCompilation = this.configure(args);
                if (continueCompilation) {
                    this.project.setProblems(this.problems.getProblems());
                    this.compile();
                    if (this.problems.hasFilteredProblems()) {
                        exitCode = this.problems.hasErrors() ? ExitCode.FAILED_WITH_ERRORS : ExitCode.FAILED_WITH_PROBLEMS;
                    }
                } else {
                    exitCode = this.problems.hasFilteredProblems() ? ExitCode.FAILED_WITH_CONFIG_PROBLEMS : ExitCode.PRINT_HELP;
                }
            }
            catch (Exception e) {
                if (outProblems == null) {
                    System.err.println(e.getMessage());
                } else {
                    UnexpectedExceptionProblem unexpectedExceptionProblem = new UnexpectedExceptionProblem((Throwable)e);
                    this.problems.add((ICompilerProblem)unexpectedExceptionProblem);
                }
                exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
                return (int)exitCode;
            }
            finally {
                this.waitAndClose();
                if (outProblems == null || !this.problems.hasFilteredProblems()) break block11;
                for (ICompilerProblem problem : this.problems.getFilteredProblems()) {
                    outProblems.add(problem);
                }
            }
        }
        return exitCode.code;
    }

    protected boolean compile() {
        JSGoogConfiguration googConfiguration = (JSGoogConfiguration)this.config;
        boolean compilationSuccess = false;
        try {
            this.project.getSourceCompilationUnitFactory().addHandler(this.asFileHandler);
            if (!googConfiguration.getSkipTranspile()) {
                if (!this.setupTargetFile()) {
                    return false;
                }
                this.buildArtifact();
            }
            if (this.jsTarget != null || googConfiguration.getSkipTranspile()) {
                ArrayList<ICompilerProblem> errors = new ArrayList<ICompilerProblem>();
                ArrayList warnings = new ArrayList();
                if (!this.config.getCreateTargetWithErrors()) {
                    this.problems.getErrorsAndWarnings(errors, warnings);
                    if (errors.size() > 0) {
                        return false;
                    }
                }
                this.jsPublisher = (IJSPublisher)this.project.getBackend().createPublisher(this.project, errors, this.config);
                File outputFolder = this.jsPublisher.getOutputFolder();
                if (!googConfiguration.getSkipTranspile()) {
                    ArrayList<ICompilationUnit> roots = new ArrayList<ICompilationUnit>();
                    roots.add(this.mainCU);
                    Set incs = this.target.getIncludesCompilationUnits();
                    roots.addAll(incs);
                    this.project.mixinClassNames = new TreeSet();
                    List reachableCompilationUnits = this.project.getReachableCompilationUnitsInSWFOrder(roots);
                    ((RoyaleJSTarget)this.target).collectMixinMetaData(this.project.mixinClassNames, reachableCompilationUnits);
                    for (ICompilationUnit cu : reachableCompilationUnits) {
                        ICompilationUnit.UnitType cuType = cu.getCompilationUnitType();
                        if (cuType != ICompilationUnit.UnitType.AS_UNIT && cuType != ICompilationUnit.UnitType.MXML_UNIT) continue;
                        File outputClassFile = this.getOutputClassFile((String)cu.getQualifiedNames().get(0), outputFolder);
                        System.out.println("Compiling file: " + outputClassFile);
                        ICompilationUnit unit = cu;
                        IJSWriter writer = cuType == ICompilationUnit.UnitType.AS_UNIT ? (IJSWriter)this.project.getBackend().createWriter(this.project, errors, unit, false) : (IJSWriter)this.project.getBackend().createMXMLWriter(this.project, errors, unit, false);
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputClassFile));
                        BufferedOutputStream sourceMapOut = null;
                        File outputSourceMapFile = null;
                        if (this.project.config.getSourceMap()) {
                            outputSourceMapFile = this.getOutputSourceMapFile((String)cu.getQualifiedNames().get(0), outputFolder);
                            sourceMapOut = new BufferedOutputStream(new FileOutputStream(outputSourceMapFile));
                        }
                        writer.writeTo(out, sourceMapOut, outputSourceMapFile);
                        out.flush();
                        out.close();
                        if (sourceMapOut != null) {
                            sourceMapOut.flush();
                            sourceMapOut.close();
                        }
                        writer.close();
                    }
                }
                compilationSuccess = this.jsPublisher != null ? this.jsPublisher.publish(this.problems) : true;
            }
        }
        catch (Exception e) {
            InternalCompilerProblem problem = new InternalCompilerProblem(e);
            this.problems.add((ICompilerProblem)problem);
        }
        return compilationSuccess;
    }

    protected void buildArtifact() throws InterruptedException, IOException, ConfigurationException {
        this.jsTarget = this.buildJSTarget();
    }

    private IJSApplication buildJSTarget() throws InterruptedException, FileNotFoundException, ConfigurationException {
        ArrayList<ICompilerProblem> problemsBuildingSWF = new ArrayList<ICompilerProblem>();
        this.project.mainCU = this.mainCU;
        IJSApplication app = this.buildApplication((CompilerProject)this.project, this.config.getMainDefinition(), this.mainCU, problemsBuildingSWF);
        this.problems.addAll(problemsBuildingSWF);
        if (app == null) {
            UnableToBuildSWFProblem problem = new UnableToBuildSWFProblem(this.getOutputFilePath());
            this.problems.add((ICompilerProblem)problem);
        }
        return app;
    }

    private IJSApplication buildApplication(CompilerProject applicationProject, String rootClassName, ICompilationUnit mainCU, Collection<ICompilerProblem> problems) throws InterruptedException, ConfigurationException, FileNotFoundException {
        Collection fatalProblems = applicationProject.getFatalProblems();
        if (!fatalProblems.isEmpty()) {
            problems.addAll(fatalProblems);
            return null;
        }
        return ((JSTarget)this.target).build(mainCU, problems);
    }

    private String getOutputFilePath() {
        if (this.config.getOutput() == null) {
            String extension = "." + this.project.getBackend().getOutputExtension();
            return FilenameUtils.removeExtension(this.config.getTargetFile()).concat(extension);
        }
        return this.config.getOutput();
    }

    private File getOutputClassFile(String qname, File outputFolder) {
        String[] cname = qname.split("\\.");
        String sdirPath = outputFolder + File.separator;
        if (cname.length > 0) {
            int n = cname.length - 1;
            for (int i = 0; i < n; ++i) {
                sdirPath = sdirPath + cname[i] + File.separator;
            }
            File sdir = new File(sdirPath);
            if (!sdir.exists()) {
                sdir.mkdirs();
            }
            qname = cname[cname.length - 1];
        }
        return new File(sdirPath + qname + "." + this.project.getBackend().getOutputExtension());
    }

    private File getOutputSourceMapFile(String qname, File outputFolder) {
        String[] cname = qname.split("\\.");
        String sdirPath = outputFolder + File.separator;
        if (cname.length > 0) {
            int n = cname.length - 1;
            for (int i = 0; i < n; ++i) {
                sdirPath = sdirPath + cname[i] + File.separator;
            }
            File sdir = new File(sdirPath);
            if (!sdir.exists()) {
                sdir.mkdirs();
            }
            qname = cname[cname.length - 1];
        }
        return new File(sdirPath + qname + "." + this.project.getBackend().getOutputExtension() + ".map");
    }

    protected boolean setupTargetFile() throws InterruptedException {
        File normalizedMainFile;
        String mainFileName = this.config.getTargetFile();
        String normalizedMainFileName = FilenameNormalization.normalize((String)mainFileName);
        SourceCompilationUnitFactory compilationUnitFactory = this.project.getSourceCompilationUnitFactory();
        if (compilationUnitFactory.canCreateCompilationUnit(normalizedMainFile = new File(normalizedMainFileName))) {
            this.project.addIncludeSourceFile(normalizedMainFile);
            List sourcePath = this.config.getCompilerSourcePath();
            String mainQName = null;
            if (sourcePath != null && !sourcePath.isEmpty()) {
                for (String path : sourcePath) {
                    String otherPath = new File(path).getAbsolutePath();
                    if (!mainFileName.startsWith(otherPath)) continue;
                    mainQName = mainFileName.substring(otherPath.length() + 1);
                    mainQName = mainQName.replaceAll("\\\\", "/");
                    if (!(mainQName = mainQName.replaceAll("\\/", ".")).endsWith(".as")) break;
                    mainQName = mainQName.substring(0, mainQName.length() - 3);
                    break;
                }
            }
            if (mainQName == null) {
                mainQName = FilenameUtils.getBaseName(mainFileName);
            }
            Collection mainFileCompilationUnits = this.workspace.getCompilationUnits(normalizedMainFileName, (ICompilerProject)this.project);
            this.mainCU = (ICompilationUnit)Iterables.getOnlyElement(mainFileCompilationUnits);
            this.config.setMainDefinition(mainQName);
        }
        Preconditions.checkNotNull(this.mainCU, "Main compilation unit can't be null");
        ITargetSettings settings = this.getTargetSettings();
        if (settings != null) {
            this.project.setTargetSettings(settings);
        }
        this.target = this.project.getBackend().createTarget(this.project, this.getTargetSettings(), null);
        return true;
    }

    private ITargetSettings getTargetSettings() {
        if (this.targetSettings == null) {
            this.targetSettings = this.projectConfigurator.getTargetSettings(null);
        }
        return this.targetSettings;
    }

    protected Configurator createConfigurator() {
        return this.project.getBackend().createConfigurator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean configure(String[] args) {
        this.project.getSourceCompilationUnitFactory().addHandler(this.asFileHandler);
        this.project.configurator = this.projectConfigurator = this.createConfigurator();
        try {
            if (this.useFlashBuilderProjectFiles(args)) {
                this.projectConfigurator.setConfiguration(FlashBuilderConfigurator.computeFlashBuilderArgs((String[])args, (String)this.getTargetType().getExtension()), "file-specs");
            } else {
                this.projectConfigurator.setConfiguration(args, "file-specs");
            }
            this.projectConfigurator.applyToProject((ICompilerProject)this.project);
            this.project.config = (JSGoogConfiguration)this.projectConfigurator.getConfiguration();
            this.config = this.projectConfigurator.getConfiguration();
            this.configBuffer = this.projectConfigurator.getConfigurationBuffer();
            this.problems = new ProblemQuery(this.projectConfigurator.getCompilerProblemSettings());
            this.problems.addAll((Iterable)this.projectConfigurator.getConfigurationProblems());
            if (this.configBuffer.getVar("version") != null) {
                boolean bl = false;
                return bl;
            }
            if (this.problems.hasErrors()) {
                boolean bl = false;
                return bl;
            }
            this.validateTargetFile();
            boolean bl = true;
            return bl;
        }
        catch (ConfigurationException e) {
            ConfigurationProblem problem = new ConfigurationProblem(e);
            this.problems.add((ICompilerProblem)problem);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage());
            this.problems.add((ICompilerProblem)problem);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.config == null) {
                this.config = new Configuration();
                this.configBuffer = new ConfigurationBuffer(Configuration.class, Configuration.getAliases());
            }
        }
    }

    private boolean useFlashBuilderProjectFiles(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-fb") && !arg.equals("-use-flashbuilder-project-files")) continue;
            return true;
        }
        return false;
    }

    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWF;
    }

    protected void validateTargetFile() throws ConfigurationException {
        if (this.mainCU instanceof ResourceModuleCompilationUnit) {
            return;
        }
        String targetFile = this.config.getTargetFile();
        if (targetFile == null) {
            throw new ConfigurationException.MustSpecifyTarget(null, null, -1);
        }
        File file = new File(targetFile);
        if (!file.exists()) {
            throw new ConfigurationException.IOError(targetFile);
        }
    }

    protected void waitAndClose() {
        this.workspace.startIdleState();
        try {
            this.workspace.close();
        }
        finally {
            this.workspace.endIdleState(Collections.emptyMap());
        }
    }

    protected void close() {
        this.workspace.close();
    }

    @Override
    public List<String> getSourceList() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ArrayList<ICompilationUnit> roots = new ArrayList<ICompilationUnit>();
            roots.add(this.mainCU);
            Set incs = this.target.getIncludesCompilationUnits();
            roots.addAll(incs);
            this.project.mixinClassNames = new TreeSet();
            List units = this.project.getReachableCompilationUnitsInSWFOrder(roots);
            for (ICompilationUnit unit : units) {
                ICompilationUnit.UnitType ut = unit.getCompilationUnitType();
                if (ut != ICompilationUnit.UnitType.AS_UNIT && ut != ICompilationUnit.UnitType.MXML_UNIT) continue;
                list.add(unit.getAbsoluteFilename());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public String getMainSource() {
        return this.mainCU.getAbsoluteFilename();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_PROBLEMS(2),
        FAILED_WITH_ERRORS(3),
        FAILED_WITH_EXCEPTIONS(4),
        FAILED_WITH_CONFIG_PROBLEMS(5);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }
    }
}

