/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import com.google.common.collect.ImmutableList;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.clients.COMPC;
import org.apache.royale.compiler.clients.COMPJSCNative;
import org.apache.royale.compiler.clients.COMPJSCRoyale;
import org.apache.royale.compiler.clients.MXMLJSC;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.codegen.js.IJSWriter;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.driver.js.IJSApplication;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.codegen.js.JSWriter;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogCompcConfiguration;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.targets.JSTarget;
import org.apache.royale.compiler.internal.targets.RoyaleSWCTarget;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem;
import org.apache.royale.compiler.problems.LibraryNotFoundProblem;
import org.apache.royale.compiler.problems.UnableToBuildSWFProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swc.io.SWCReader;
import org.apache.royale.utils.ArgumentUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COMPJSC
extends MXMLJSC {
    @Override
    public String getName() {
        return "COMPC";
    }

    @Override
    public int execute(String[] args) {
        return COMPJSC.staticMainNoExit(args);
    }

    public static void main(String[] args) {
        int exitCode = COMPJSC.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        long startTime = System.nanoTime();
        COMPJSC mxmlc = new COMPJSC();
        mxmlc.configurationClass = JSGoogCompcConfiguration.class;
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        int exitCode = mxmlc.mainNoExit(args, problems, true);
        long endTime = System.nanoTime();
        System.out.println((double)(endTime - startTime) / 1.0E9 + " seconds");
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int mainNoExit(String[] args, List<ICompilerProblem> problems, Boolean printProblems) {
        int exitCode = -1;
        try {
            exitCode = this._mainNoExit(ArgumentUtil.fixArgs((String[])args), problems);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        finally {
            if (problems != null && !problems.isEmpty() && printProblems.booleanValue()) {
                WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(this.workspace);
                ProblemPrinter printer = new ProblemPrinter((ProblemFormatter)formatter);
                printer.printProblems(problems);
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _mainNoExit(String[] args, List<ICompilerProblem> outProblems) {
        Iterator<String> iterator;
        System.out.println("args:");
        for (String arg : args) {
            System.out.println(arg);
        }
        ExitCode exitCode = ExitCode.SUCCESS;
        try {
            boolean continueCompilation = this.configure(args);
            CompilerDiagnosticsConstants.diagnostics = this.config.getDiagnosticsLevel();
            if (continueCompilation) {
                List<String> targets = this.config.getCompilerTargets();
                for (String target : targets) {
                    System.out.println("target:" + target);
                }
            } else {
                if (this.problems.hasFilteredProblems()) {
                    exitCode = ExitCode.FAILED_WITH_CONFIG_PROBLEMS;
                    return exitCode.code;
                }
                exitCode = ExitCode.PRINT_HELP;
                return exitCode.code;
            }
            iterator = this.config.getCompilerTargets().iterator();
        }
        catch (Exception e) {
            if (outProblems == null) {
                System.err.println(e.getMessage());
            } else {
                UnexpectedExceptionProblem unexpectedExceptionProblem = new UnexpectedExceptionProblem((Throwable)e);
                this.problems.add((ICompilerProblem)unexpectedExceptionProblem);
            }
            exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
            return (int)exitCode;
        }
        finally {
            this.waitAndClose();
            if (outProblems == null) return exitCode.code;
            if (!this.problems.hasFilteredProblems()) return exitCode.code;
            Iterator iterator2 = this.problems.getFilteredProblems().iterator();
            while (iterator2.hasNext()) {
                ICompilerProblem problem = (ICompilerProblem)iterator2.next();
                outProblems.add(problem);
            }
            return exitCode.code;
        }
        block13: while (iterator.hasNext()) {
            String target;
            target = iterator.next();
            int result = 0;
            switch (MXMLJSC.JSTargetType.fromString(target)) {
                case SWF: {
                    System.out.println("COMPC");
                    COMPC compc = new COMPC();
                    this.mxmlc = compc;
                    compc.configurationClass = JSGoogCompcConfiguration.class;
                    result = compc.mainNoExit(this.removeJSArgs(args));
                    if (result == 0) break;
                    this.problems.addAll((Iterable)compc.problems.getProblems());
                    break block13;
                }
                case JS_ROYALE: {
                    System.out.println("COMPCJSCRoyale");
                    COMPJSCRoyale royale = new COMPJSCRoyale();
                    this.lastCompiler = royale;
                    result = royale.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                    if (result == 0) break;
                    break block13;
                }
                case JS_NATIVE: 
                case JS_NODE: {
                    COMPJSCNative jsc = new COMPJSCNative();
                    this.lastCompiler = jsc;
                    result = jsc.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                    if (result != 0) break block13;
                }
            }
        }
        if (!this.problems.hasFilteredProblems()) return exitCode.code;
        if (this.problems.hasErrors()) {
            exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
            return exitCode.code;
        }
        exitCode = ExitCode.FAILED_WITH_PROBLEMS;
        return exitCode.code;
    }

    @Override
    protected boolean compile() {
        boolean compilationSuccess = false;
        try {
            this.project.getSourceCompilationUnitFactory().addHandler(this.asFileHandler);
            if (this.setupTargetFile()) {
                this.buildArtifact();
            }
            if (this.jsTarget != null) {
                ArrayList errors = new ArrayList();
                ArrayList warnings = new ArrayList();
                if (!this.config.getCreateTargetWithErrors()) {
                    this.problems.getErrorsAndWarnings(errors, warnings);
                    if (errors.size() > 0) {
                        return false;
                    }
                }
                boolean packingSWC = false;
                String outputFolderName = this.getOutputFilePath();
                File swcFile = new File(outputFolderName);
                File jsOut = new File("js/out");
                File externsOut = new File("externs");
                ZipFile zipFile = null;
                ZipOutputStream zipOutputStream = null;
                String catalog = null;
                StringBuilder fileList = new StringBuilder();
                if (outputFolderName.endsWith(".swc")) {
                    packingSWC = true;
                    if (!swcFile.exists()) {
                        this.problems.add((ICompilerProblem)new LibraryNotFoundProblem(outputFolderName));
                        return false;
                    }
                    zipFile = new ZipFile(swcFile, 1);
                    InputStream catalogInputStream = SWCReader.getInputStream((ZipFile)zipFile, (String)"catalog.xml");
                    catalog = IOUtils.toString(catalogInputStream);
                    catalogInputStream.close();
                    zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFolderName + ".new")));
                    zipOutputStream.setLevel(0);
                    Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
                    while (entryEnum.hasMoreElements()) {
                        ZipEntry entry = entryEnum.nextElement();
                        if (entry.getName().contains("js/out") || entry.getName().contains("catalog.xml")) continue;
                        System.out.println("Copy " + entry.getName());
                        InputStream input = zipFile.getInputStream(entry);
                        zipOutputStream.putNextEntry(new ZipEntry(entry.getName()));
                        IOUtils.copy(input, (OutputStream)zipOutputStream);
                        zipOutputStream.flush();
                        zipOutputStream.closeEntry();
                    }
                    int filesIndex = catalog.indexOf("<files>");
                    if (filesIndex != -1) {
                        int filesIndex2 = catalog.indexOf("</files>");
                        String files = catalog.substring(filesIndex, filesIndex2);
                        int fileIndex = files.indexOf("<file", 6);
                        int pathIndex = files.indexOf("path=");
                        while (pathIndex != -1) {
                            int pathIndex2 = files.indexOf("\"", pathIndex + 6);
                            int fileIndex2 = files.indexOf("/>", fileIndex);
                            String path = files.substring(pathIndex + 6, pathIndex2);
                            if (!path.startsWith("js/out")) {
                                fileList.append(files.substring(fileIndex - 8, fileIndex2 + 3));
                            }
                            pathIndex = files.indexOf("path=", pathIndex2);
                            fileIndex = files.indexOf("<file", fileIndex2);
                        }
                        catalog = catalog.substring(0, filesIndex) + catalog.substring(filesIndex2 + 8);
                    }
                }
                File outputFolder = null;
                if (!packingSWC) {
                    outputFolder = new File(outputFolderName);
                }
                Set externs = this.config.getExterns();
                ImmutableList roots = ((RoyaleSWCTarget)this.target).getReachableCompilationUnits(errors);
                List reachableCompilationUnits = this.project.getReachableCompilationUnitsInSWFOrder(roots);
                for (ICompilationUnit cu : reachableCompilationUnits) {
                    String symbol;
                    ICompilationUnit.UnitType cuType = cu.getCompilationUnitType();
                    if (cuType != ICompilationUnit.UnitType.AS_UNIT && cuType != ICompilationUnit.UnitType.MXML_UNIT || externs.contains(symbol = (String)cu.getQualifiedNames().get(0)) || this.project.isExternalLinkage(cu)) continue;
                    if (!packingSWC) {
                        File outputClassFile = this.getOutputClassFile((String)cu.getQualifiedNames().get(0), outputFolder, true);
                        System.out.println("Compiling file: " + outputClassFile);
                        ICompilationUnit unit = cu;
                        IJSWriter writer = cuType == ICompilationUnit.UnitType.AS_UNIT ? (IJSWriter)this.project.getBackend().createWriter(this.project, errors, unit, false) : (IJSWriter)this.project.getBackend().createMXMLWriter(this.project, errors, unit, false);
                        this.problems.addAll(errors);
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputClassFile));
                        BufferedOutputStream sourceMapOut = null;
                        File outputSourceMapFile = null;
                        if (this.project.config.getSourceMap()) {
                            outputSourceMapFile = this.getOutputSourceMapFile((String)cu.getQualifiedNames().get(0), outputFolder, true);
                            sourceMapOut = new BufferedOutputStream(new FileOutputStream(outputSourceMapFile));
                        }
                        writer.writeTo(out, sourceMapOut, outputSourceMapFile);
                        out.flush();
                        out.close();
                        if (sourceMapOut != null) {
                            sourceMapOut.flush();
                            sourceMapOut.close();
                        }
                        writer.close();
                        continue;
                    }
                    System.out.println("Compiling file: " + (String)cu.getQualifiedNames().get(0));
                    ICompilationUnit unit = cu;
                    IJSWriter writer = cuType == ICompilationUnit.UnitType.AS_UNIT ? (IJSWriter)this.project.getBackend().createWriter(this.project, errors, unit, false) : (IJSWriter)this.project.getBackend().createMXMLWriter(this.project, errors, unit, false);
                    this.problems.addAll(errors);
                    ByteArrayOutputStream temp = new ByteArrayOutputStream();
                    ByteArrayOutputStream sourceMapTemp = null;
                    if (this.project.config.getSourceMap()) {
                        sourceMapTemp = new ByteArrayOutputStream();
                    }
                    writer.writeTo(temp, sourceMapTemp, null);
                    boolean isExterns = false;
                    if (writer instanceof JSWriter) {
                        isExterns = ((JSWriter)writer).isExterns();
                    }
                    String outputClassFile = this.getOutputClassFile((String)cu.getQualifiedNames().get(0), isExterns ? externsOut : jsOut, false).getPath();
                    System.out.println("Writing file: " + outputClassFile);
                    zipOutputStream.putNextEntry(new ZipEntry(outputClassFile));
                    temp.writeTo(zipOutputStream);
                    zipOutputStream.flush();
                    zipOutputStream.closeEntry();
                    fileList.append("        <file path=\"" + outputClassFile + "\" mod=\"" + System.currentTimeMillis() + "\"/>\n");
                    if (sourceMapTemp != null) {
                        String sourceMapFile = this.getOutputSourceMapFile((String)cu.getQualifiedNames().get(0), isExterns ? externsOut : jsOut, false).getPath();
                        System.out.println("Writing file: " + sourceMapFile);
                        zipOutputStream.putNextEntry(new ZipEntry(sourceMapFile));
                        sourceMapTemp.writeTo(zipOutputStream);
                        zipOutputStream.flush();
                        zipOutputStream.closeEntry();
                        fileList.append("        <file path=\"" + sourceMapFile + "\" mod=\"" + System.currentTimeMillis() + "\"/>\n");
                    }
                    writer.close();
                }
                if (packingSWC) {
                    zipFile.close();
                    int libraryIndex = catalog.indexOf("</libraries>");
                    catalog = catalog.substring(0, libraryIndex + 13) + "    <files>\n" + fileList.toString() + "    </files>" + catalog.substring(libraryIndex + 13);
                    zipOutputStream.putNextEntry(new ZipEntry("catalog.xml"));
                    zipOutputStream.write(catalog.getBytes());
                    zipOutputStream.flush();
                    zipOutputStream.closeEntry();
                    zipOutputStream.flush();
                    zipOutputStream.close();
                    swcFile.delete();
                    File newSWCFile = new File(outputFolderName + ".new");
                    newSWCFile.renameTo(swcFile);
                }
                compilationSuccess = true;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            InternalCompilerProblem problem = new InternalCompilerProblem(e);
            this.problems.add((ICompilerProblem)problem);
        }
        return compilationSuccess;
    }

    @Override
    protected void buildArtifact() throws InterruptedException, IOException, ConfigurationException {
        this.jsTarget = this.buildJSTarget();
    }

    private IJSApplication buildJSTarget() throws InterruptedException, FileNotFoundException, ConfigurationException {
        ArrayList<ICompilerProblem> problemsBuildingSWF = new ArrayList<ICompilerProblem>();
        IJSApplication app = this.buildApplication((CompilerProject)this.project, this.config.getMainDefinition(), null, problemsBuildingSWF);
        this.problems.addAll(problemsBuildingSWF);
        if (app == null) {
            UnableToBuildSWFProblem problem = new UnableToBuildSWFProblem(this.getOutputFilePath());
            this.problems.add((ICompilerProblem)problem);
        }
        return app;
    }

    private IJSApplication buildApplication(CompilerProject applicationProject, String rootClassName, ICompilationUnit mainCU, Collection<ICompilerProblem> problems) throws InterruptedException, ConfigurationException, FileNotFoundException {
        Collection fatalProblems = applicationProject.getFatalProblems();
        if (!fatalProblems.isEmpty()) {
            problems.addAll(fatalProblems);
            return null;
        }
        return ((JSTarget)this.target).build(mainCU, problems);
    }

    private String getOutputFilePath() {
        if (this.config.getOutput() == null) {
            String extension = "." + this.project.getBackend().getOutputExtension();
            return FilenameUtils.removeExtension(this.config.getTargetFile()).concat(extension);
        }
        String outputFolderName = this.config.getOutput();
        return outputFolderName;
    }

    private File getOutputClassFile(String qname, File outputFolder, boolean createDirs) {
        String[] cname = qname.split("\\.");
        String sdirPath = outputFolder + File.separator;
        if (cname.length > 0) {
            File sdir;
            int n = cname.length - 1;
            for (int i = 0; i < n; ++i) {
                sdirPath = sdirPath + cname[i] + File.separator;
            }
            if (createDirs && !(sdir = new File(sdirPath)).exists()) {
                sdir.mkdirs();
            }
            qname = cname[cname.length - 1];
        }
        return new File(sdirPath + qname + "." + this.project.getBackend().getOutputExtension());
    }

    private File getOutputSourceMapFile(String qname, File outputFolder, boolean createDirs) {
        String[] cname = qname.split("\\.");
        String sdirPath = outputFolder + File.separator;
        if (cname.length > 0) {
            File sdir;
            int n = cname.length - 1;
            for (int i = 0; i < n; ++i) {
                sdirPath = sdirPath + cname[i] + File.separator;
            }
            if (createDirs && !(sdir = new File(sdirPath)).exists()) {
                sdir.mkdirs();
            }
            qname = cname[cname.length - 1];
        }
        return new File(sdirPath + qname + "." + this.project.getBackend().getOutputExtension() + ".map");
    }

    @Override
    protected boolean setupTargetFile() throws InterruptedException {
        this.config.getTargetFile();
        ITargetSettings settings = this.getTargetSettings();
        if (settings == null) {
            return false;
        }
        this.project.setTargetSettings(settings);
        this.target = this.project.getBackend().createTarget(this.project, this.getTargetSettings(), null);
        return true;
    }

    private ITargetSettings getTargetSettings() {
        if (this.targetSettings == null) {
            this.targetSettings = this.projectConfigurator.getTargetSettings(this.getTargetType());
        }
        if (this.targetSettings == null) {
            this.problems.addAll((Iterable)this.projectConfigurator.getConfigurationProblems());
        }
        return this.targetSettings;
    }

    @Override
    protected void validateTargetFile() throws ConfigurationException {
    }

    @Override
    protected String getProgramName() {
        return "compc";
    }

    protected boolean isCompc() {
        return true;
    }

    @Override
    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWC;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_PROBLEMS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }
    }
}

