/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swf.tags;

import java.util.ArrayList;
import java.util.List;
import org.apache.royale.swf.TagType;
import org.apache.royale.swf.tags.CharacterTag;
import org.apache.royale.swf.tags.ICharacterReferrer;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.ITag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineSpriteTag
extends CharacterTag
implements ICharacterReferrer {
    private final int frameCount;
    private final List<ITag> controlTags;

    public DefineSpriteTag(int frameCount, List<ITag> controlTags) {
        super(TagType.DefineSprite);
        this.frameCount = frameCount;
        this.controlTags = controlTags;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public List<ITag> getControlTags() {
        return this.controlTags;
    }

    @Override
    public String description() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("#%d, including %d frame(s)", this.getCharacterID(), this.frameCount));
        for (ITag tag : this.controlTags) {
            result.append("\n  >> ").append(tag);
        }
        return result.toString();
    }

    @Override
    public Iterable<ICharacterTag> getReferences() {
        ArrayList<ICharacterTag> result = new ArrayList<ICharacterTag>();
        for (ITag controlTag : this.controlTags) {
            if (!(controlTag instanceof ICharacterReferrer)) continue;
            for (ICharacterTag tag : ((ICharacterReferrer)((Object)controlTag)).getReferences()) {
                assert (tag != null);
                result.add(tag);
            }
        }
        return result;
    }
}

