/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swc.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.royale.compiler.asdoc.IPackageDITAParser;
import org.apache.royale.compiler.problems.FileInLibraryIOProblem;
import org.apache.royale.compiler.problems.FileInLibraryNotFoundProblem;
import org.apache.royale.compiler.problems.LibraryNotFoundProblem;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.SWC;
import org.apache.royale.swc.catalog.StAXCatalogReader;
import org.apache.royale.swc.dita.IDITAList;
import org.apache.royale.swc.io.ISWCReader;

public class SWCReader
implements ISWCReader {
    public static final String CATALOG_XML = "catalog.xml";
    private static final String DITA_MANIFEST = "docs/packages.dita";
    private static final String ANE_EXTENSION_XML = "META-INF/AIR/extension.xml";
    private final File swcFile;
    private StAXCatalogReader catalogReader;
    private final SWC swc;

    public SWCReader(String filename) {
        this(new File(filename), IPackageDITAParser.NIL_PARSER);
    }

    public SWCReader(File swcFile) {
        this(swcFile, IPackageDITAParser.NIL_PARSER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SWCReader(File swcFile, IPackageDITAParser packageDitaParser) {
        block27: {
            this.swcFile = swcFile;
            this.swc = new SWC(swcFile);
            if (!swcFile.exists() || !swcFile.isFile()) {
                this.swc.addProblem(new LibraryNotFoundProblem(swcFile.getAbsolutePath()));
                return;
            }
            ZipFile zipFile = null;
            this.catalogReader = null;
            zipFile = new ZipFile(swcFile, 1);
            InputStream catalogInputStream = SWCReader.getInputStream(zipFile, CATALOG_XML);
            if (catalogInputStream != null) break block24;
            this.swc.addProblem(new FileInLibraryNotFoundProblem(swcFile.getAbsolutePath(), CATALOG_XML));
            Object var9_7 = null;
            try {
                if (this.catalogReader != null) {
                    this.catalogReader.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                block26: {
                    block24: {
                        return;
                    }
                    try {
                        this.catalogReader = new StAXCatalogReader(new BufferedInputStream(catalogInputStream), this.swc);
                        this.catalogReader.parse();
                        this.catalogReader.close();
                        this.catalogReader = null;
                    }
                    catch (Exception e) {
                        this.swc.addProblem(new FileInLibraryIOProblem(CATALOG_XML, swcFile.getAbsolutePath(), e.getLocalizedMessage()));
                        Object var9_8 = null;
                        try {
                            if (this.catalogReader != null) {
                                this.catalogReader.close();
                            }
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    try {
                        InputStream ditaInputStream = SWCReader.getInputStream(zipFile, DITA_MANIFEST);
                        if (ditaInputStream == null) break block26;
                        try {
                            IDITAList list = packageDitaParser.parse(swcFile.getAbsolutePath(), ditaInputStream);
                            if (list != null) {
                                this.swc.setDITAList(list);
                            }
                            Object var7_16 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_17 = null;
                            ditaInputStream.close();
                            throw throwable;
                        }
                        ditaInputStream.close();
                        {
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.swc.setIsANE(zipFile.getEntry(ANE_EXTENSION_XML) != null);
            }
            Object var9_9 = null;
            try {
                if (this.catalogReader != null) {
                    this.catalogReader.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
                break block27;
            }
            catch (Exception exception) {}
            break block27;
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (this.catalogReader != null) {
                        this.catalogReader.close();
                    }
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public File getFile() {
        return this.swcFile;
    }

    public ISWC getSWC() {
        return this.swc;
    }

    public static InputStream getInputStream(ZipFile zipFile, String filename) throws IOException {
        ZipEntry zipEntry = null;
        Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
        while (entryEnum.hasMoreElements()) {
            ZipEntry entry = entryEnum.nextElement();
            if (!entry.getName().equals(filename)) continue;
            zipEntry = entry;
            break;
        }
        if (zipEntry == null) {
            return null;
        }
        return zipFile.getInputStream(zipEntry);
    }

    public static String getReportingPath(String swcPath, String libraryPath) {
        assert (swcPath != null && libraryPath != null);
        StringBuilder sb = new StringBuilder();
        sb.append(swcPath).append("(").append(libraryPath).append(")");
        return sb.toString();
    }
}

