/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swc;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.swc.ISWCScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWCScript
implements ISWCScript {
    private String name;
    private long lastModified;
    private String signatureChecksum;
    private byte[] abcData;
    private final Set<String> definitions = new HashSet<String>();
    private final SetMultimap<String, DependencyType> dependencies = HashMultimap.create();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getSignatureChecksum() {
        return this.signatureChecksum;
    }

    @Override
    public void addDefinition(String id) {
        this.definitions.add(id);
    }

    @Override
    public void addDependency(String id, DependencyType type) {
        this.dependencies.put((Object)id, (Object)type);
        this.removeUnnecessaryDependencies(id);
    }

    private void removeUnnecessaryDependencies(String id) {
        Set set = this.dependencies.get((Object)id);
        if (set.contains((Object)DependencyType.INHERITANCE)) {
            set.remove((Object)DependencyType.SIGNATURE);
            set.remove((Object)DependencyType.NAMESPACE);
            set.remove((Object)DependencyType.EXPRESSION);
        } else if (set.contains((Object)DependencyType.SIGNATURE) || set.contains((Object)DependencyType.NAMESPACE)) {
            set.remove((Object)DependencyType.EXPRESSION);
        }
    }

    @Override
    public Set<String> getDefinitions() {
        return this.definitions;
    }

    @Override
    public SetMultimap<String, DependencyType> getDependencies() {
        return this.dependencies;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setSignatureChecksum(String signatureChecksum) {
        this.signatureChecksum = signatureChecksum;
    }

    @Override
    public void setSource(byte[] abcData) {
        assert (abcData != null);
        this.abcData = abcData;
    }

    @Override
    public byte[] getSource() {
        return this.abcData;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name: ");
        sb.append(this.getName());
        sb.append('\n');
        sb.append("definitions:\n");
        Object[] defs = this.getDefinitions().toArray(new String[0]);
        Arrays.sort(defs);
        for (Object def : defs) {
            sb.append((String)def);
            sb.append('\n');
        }
        return sb.toString();
    }
}

