/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.royale.compiler.Messages;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.DependencyTypeSet;
import org.apache.royale.compiler.common.VersionInfo;
import org.apache.royale.compiler.config.CommandLineConfigurator;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.ConfigurationBuffer;
import org.apache.royale.compiler.config.ConfigurationPathResolver;
import org.apache.royale.compiler.config.ConfigurationValue;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.config.annotations.Arguments;
import org.apache.royale.compiler.internal.config.annotations.Config;
import org.apache.royale.compiler.internal.config.annotations.InfiniteArguments;
import org.apache.royale.compiler.internal.config.annotations.Mapping;
import org.apache.royale.compiler.internal.config.annotations.SoftPrerequisites;
import org.apache.royale.compiler.internal.config.localization.LocalizationManager;
import org.apache.royale.compiler.internal.projects.LibraryDependencyGraph;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.targets.SWFTarget;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ConfigurationProblem;
import org.apache.royale.compiler.problems.FileIOProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swc.catalog.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWCDepends {
    public static final String SWC_DEPENDENCY_ORDER_ELEMENT = "swc-dependency-order";
    public static final String SWC_DEPENDENCIES_ELEMENT = "swc-dependencies";
    public static final String SWC_ELEMENT = "swc";
    public static final String DEFINITION_DEPENDENCIES_ELEMENT = "definition-dependencies";
    public static final String DEFINITION_ELEMENT = "def";
    public static final String PATH_ATTRIBUTE = "path";
    public static final String ID_ATTRIBUTE = "id";
    static final String NEWLINE = System.getProperty("line.separator");
    private static final String DEFAULT_VAR = "no-default-arg";
    private static final String L10N_CONFIG_PREFIX = "org.apache.royale.compiler.internal.config.configuration";
    protected Workspace workspace = new Workspace();
    protected RoyaleProject project = new RoyaleProject(this.workspace);
    protected DependencyConfiguration config;
    protected ProblemQuery problems = new ProblemQuery();
    protected ConfigurationBuffer configBuffer;
    protected Configurator projectConfigurator;
    protected ICompilationUnit mainCU;
    protected SWFTarget target;
    protected ITargetSettings targetSettings;
    private List<String> dependencyOrder;

    public static void main(String[] args) {
        int exitCode = SWCDepends.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        SWCDepends swcDepends = new SWCDepends();
        return swcDepends.mainNoExit(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int mainNoExit(String[] args) {
        block17: {
            result = 0;
            if (this.configure(args)) {
                xmlWriter = null;
                try {
                    showSwcs = this.config.getShowSwcs();
                    dependencyTypes = this.getDependencyTypeSet();
                    graph = this.project.createLibraryDependencyGraph(dependencyTypes);
                    xmlWriter = new XMLFormatter(this.getXMLWriter());
                    xmlWriter.writeStartDocument();
                    xmlWriter.writeStartElement("swc-dependency-order");
                    this.dependencyOrder = graph.getDependencyOrder();
                    for (String swcName : this.dependencyOrder) {
                        if (!this.showSwc(swcName, showSwcs)) continue;
                        this.println(swcName + ":");
                        xmlWriter.writeStartElement("swc");
                        xmlWriter.writeAttribute("path", swcName);
                        this.printDependencies(swcName, xmlWriter, graph);
                        xmlWriter.writeEndElement();
                    }
                    xmlWriter.writeEndElement();
                    xmlWriter.writeEndDocument();
                    xmlWriter.flush();
                    xmlWriter.close();
                    var10_13 = null;
                    ** if (xmlWriter == null) goto lbl-1000
                }
                catch (Throwable var9_21) {
                    var10_16 = null;
                    if (xmlWriter != null) {
                        try {
                            xmlWriter.close();
                        }
                        catch (XMLStreamException var11_20) {
                            // empty catch block
                        }
                    }
                    throw var9_21;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        xmlWriter.close();
                    }
                    catch (XMLStreamException var11_17) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block17;
                    catch (IOException e) {
                        problem = new FileIOProblem(e);
                        this.problems.add(problem);
                        var10_14 = null;
                        if (xmlWriter != null) {
                            try {
                                xmlWriter.close();
                            }
                            catch (XMLStreamException var11_18) {}
                        }
                        break block17;
                    }
                    catch (Exception e) {
                        problem = new InternalCompilerProblem(e);
                        this.problems.add(problem);
                        var10_15 = null;
                        if (xmlWriter != null) {
                            try {
                                xmlWriter.close();
                            }
                            catch (XMLStreamException var11_19) {}
                        }
                        break block17;
                    }
                }
            }
            result = 1;
        }
        formatter = new WorkspaceProblemFormatter(this.workspace, null);
        printer = new ProblemPrinter(formatter, System.err);
        printer.printProblems(this.problems.getFilteredProblems());
        if (this.problems.hasErrors()) {
            result = 1;
        }
        return result;
    }

    private boolean showSwc(String swcName, List<String> swcs) {
        boolean show = true;
        if (swcs.size() != 0) {
            show = false;
            for (String showSwc : swcs) {
                if (!swcName.endsWith(showSwc)) continue;
                show = true;
                break;
            }
        }
        return show;
    }

    private void printDependencies(String swcName, XMLStreamWriter xmlWriter, LibraryDependencyGraph graph) throws XMLStreamException {
        Set<String> dependencies;
        if (this.config.getShowDependencyList() && (dependencies = graph.getDependencies(swcName)).size() > 0) {
            xmlWriter.writeStartElement(SWC_DEPENDENCIES_ELEMENT);
            ArrayList<String> swcDependencies = new ArrayList<String>(graph.getDependencies(swcName));
            Collections.sort(swcDependencies, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return SWCDepends.this.dependencyOrder.indexOf(o1) - SWCDepends.this.dependencyOrder.indexOf(o2);
                }
            });
            List<String> swcFilter = this.config.getShowDependentSwcs();
            for (String swcDependency : swcDependencies) {
                if (!this.showSwc(swcDependency, swcFilter)) continue;
                this.println("\t" + swcDependency);
                xmlWriter.writeStartElement(SWC_ELEMENT);
                xmlWriter.writeAttribute(PATH_ATTRIBUTE, swcDependency);
                this.printExterns(swcName, swcDependency, xmlWriter, graph);
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
    }

    private void printExterns(String swcName, String swcDependency, XMLStreamWriter xmlWriter, LibraryDependencyGraph graph) throws XMLStreamException {
        if (this.config.getShowExterns()) {
            xmlWriter.writeStartElement(DEFINITION_DEPENDENCIES_ELEMENT);
            Map<String, DependencyTypeSet> dependencyMap = graph.getDependencySet(swcName, swcDependency);
            for (Map.Entry<String, DependencyTypeSet> entry : dependencyMap.entrySet()) {
                xmlWriter.writeStartElement(DEFINITION_ELEMENT);
                xmlWriter.writeAttribute(ID_ATTRIBUTE, entry.getKey());
                if (this.config.getShowTypes()) {
                    System.out.print("\t\t" + entry.getKey() + "\t");
                    StringBuilder sb = new StringBuilder();
                    Iterator<DependencyType> iter = entry.getValue().iterator();
                    while (iter.hasNext()) {
                        DependencyType type = iter.next();
                        System.out.print(type.getSymbol());
                        sb.append(type.getSymbol());
                        if (!iter.hasNext()) continue;
                        sb.append(",");
                        System.out.print(" ");
                    }
                    this.println("");
                    xmlWriter.writeAttribute("types", sb.toString());
                } else {
                    this.println("\t\t" + entry.getKey());
                }
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
    }

    private XMLStreamWriter getXMLWriter() throws XMLStreamException, IOException {
        Writer writer = null;
        writer = this.config.getDependencyReport() != null ? new FileWriter(this.config.getDependencyReport()) : new StringWriter();
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        assert (xmlOutputFactory != null) : "Expect XMLOutputFactory implementation.";
        return xmlOutputFactory.createXMLStreamWriter(writer);
    }

    private DependencyTypeSet getDependencyTypeSet() {
        List<String> desiredDependencies = this.config.getDesiredScriptDependencyTypes();
        if (desiredDependencies != null) {
            DependencyTypeSet dependencySet = DependencyTypeSet.noneOf();
            ArrayList<String> validDependencies = new ArrayList<String>();
            for (DependencyType type : DependencyTypeSet.allOf()) {
                validDependencies.add(String.valueOf(type.getSymbol()));
            }
            for (String desiredDependency : desiredDependencies) {
                if (!validDependencies.contains(desiredDependency)) continue;
                dependencySet.add(DependencyType.get(desiredDependency.charAt(0)));
            }
            return dependencySet;
        }
        return DependencyTypeSet.allOf();
    }

    protected boolean configure(String[] args) {
        this.projectConfigurator = this.createConfigurator();
        try {
            ConfigurationPathResolver resolver = new ConfigurationPathResolver(System.getProperty("user.dir"));
            this.projectConfigurator.setConfigurationPathResolver(resolver);
            this.projectConfigurator.setConfiguration(args, this.getConfigurationDefaultVariable());
            this.projectConfigurator.applyToProject(this.project);
            this.problems = new ProblemQuery(this.projectConfigurator.getCompilerProblemSettings());
            this.config = (DependencyConfiguration)this.projectConfigurator.getConfiguration();
            Messages.setLocale(this.config.getToolsLocale());
            this.configBuffer = this.projectConfigurator.getConfigurationBuffer();
            this.problems.addAll(this.projectConfigurator.getConfigurationProblems());
            if (this.configBuffer.getVar("version") != null) {
                this.println(VersionInfo.buildMessage());
                return false;
            }
            List<ConfigurationValue> helpVar = this.configBuffer.getVar("help");
            if (helpVar != null) {
                this.processHelp(helpVar);
                return false;
            }
            for (String fileName : this.projectConfigurator.getLoadedConfigurationFiles()) {
                this.println(Messages.getString("MXMLC.Loading_configuration_format", Collections.singletonMap("configurationName", fileName)));
            }
            this.println("");
            return !this.problems.hasErrors();
        }
        catch (Exception e) {
            ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage());
            this.problems.add(problem);
            return false;
        }
    }

    private void processHelp(List<ConfigurationValue> helpVar) {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        for (ConfigurationValue val : helpVar) {
            Iterator<String> iterator = val.getArgs().iterator();
            while (iterator.hasNext()) {
                String element;
                String keyword = element = iterator.next();
                while (keyword.startsWith("-")) {
                    keyword = keyword.substring(1);
                }
                keywords.add(keyword);
            }
        }
        if (keywords.size() == 0) {
            keywords.add("help");
        }
        String usages = CommandLineConfigurator.usage(this.getProgramName(), DEFAULT_VAR, this.configBuffer, keywords, LocalizationManager.get(), L10N_CONFIG_PREFIX);
        this.println(this.getStartMessage());
        this.println(usages);
    }

    protected void println(String msg) {
        System.out.println(msg);
    }

    private String getStartMessage() {
        String message = "SWC Dependency utility (swcdepends)" + NEWLINE + VersionInfo.buildMessage() + NEWLINE;
        return message;
    }

    private String getConfigurationDefaultVariable() {
        return DEFAULT_VAR;
    }

    private Configurator createConfigurator() {
        return new Configurator(DependencyConfiguration.class);
    }

    private String getProgramName() {
        return "swcdepends";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DependencyConfiguration
    extends Configuration {
        private boolean showExterns = false;
        private boolean showDependencyList = true;
        private boolean showTypes = false;
        private List<String> desiredTypes = new LinkedList<String>();
        private List<String> showSwcs = new LinkedList<String>();
        private List<String> showDependentSwcs = new LinkedList<String>();
        private String dependencyReportFileName;

        public boolean getShowExterns() {
            return this.showExterns;
        }

        @Config
        @Mapping(value={"dependency", "show-external-classes"})
        public void setShowExternalClasses(ConfigurationValue cv, boolean showExterns) throws ConfigurationException {
            this.showExterns = showExterns;
        }

        public boolean getShowDependencyList() {
            return this.showDependencyList;
        }

        @Config
        @Mapping(value={"dependency", "show-dependency-list"})
        public void setShowDependencyList(ConfigurationValue cv, boolean showSwcDependencies) throws ConfigurationException {
            this.showDependencyList = showSwcDependencies;
        }

        public boolean getShowTypes() {
            return this.showTypes;
        }

        @Config
        @Mapping(value={"dependency", "show-types"})
        @SoftPrerequisites(value={"show-external-classes"})
        public void setShowTypes(ConfigurationValue cv, boolean showTypes) throws ConfigurationException {
            this.showTypes = showTypes;
            if (showTypes) {
                this.showExterns = true;
            }
        }

        public List<String> getDesiredScriptDependencyTypes() {
            return this.desiredTypes;
        }

        @Config(allowMultiple=true)
        @Mapping(value={"dependency", "types"})
        @Arguments(value={"type"})
        @InfiniteArguments
        public void setTypes(ConfigurationValue cfgval, String[] types) throws ConfigurationException {
            for (int i = 0; i < types.length; ++i) {
                this.desiredTypes.add(types[i]);
            }
        }

        public List<String> getShowSwcs() {
            return this.showSwcs;
        }

        @Config(allowMultiple=true)
        @Mapping(value={"dependency", "show-swcs"})
        @Arguments(value={"swc-name"})
        @InfiniteArguments
        public void setShowSwcs(ConfigurationValue cfgval, String[] swcs) throws ConfigurationException {
            for (int i = 0; i < swcs.length; ++i) {
                this.showSwcs.add(swcs[i]);
            }
        }

        public List<String> getShowDependentSwcs() {
            return this.showDependentSwcs;
        }

        @Config(allowMultiple=true)
        @Mapping(value={"dependency", "show-dependent-swcs"})
        @Arguments(value={"swc-name"})
        @InfiniteArguments
        public void setShowDependentSwcs(ConfigurationValue cfgval, String[] swcs) throws ConfigurationException {
            for (int i = 0; i < swcs.length; ++i) {
                this.showDependentSwcs.add(swcs[i]);
            }
        }

        @Config(removed=true)
        @Mapping(value={"dependency", "minimize-dependency-set"})
        public void setMinimizeDependencySet(ConfigurationValue cv, boolean minimumSet) throws ConfigurationException {
        }

        public File getDependencyReport() {
            return this.dependencyReportFileName != null ? new File(this.dependencyReportFileName) : null;
        }

        @Config
        @Mapping(value={"dependency", "dependency-report"})
        @Arguments(value={"filename"})
        public void setDependencyReport(ConfigurationValue cv, String filename) {
            this.dependencyReportFileName = this.getOutputPath(cv, filename);
        }
    }
}

