/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.units.requests;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.embedding.IEmbedData;
import org.apache.royale.compiler.internal.embedding.transcoders.TranscoderBase;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.royale.swf.SWFFrame;
import org.apache.royale.swf.tags.DoABCTag;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.ITag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWFTagsRequestResult
implements ISWFTagsRequestResult {
    private final byte[] abcData;
    private final String tagName;
    private final List<ITag> additionalTags;
    private final Map<String, ICharacterTag> assetTags;
    private final Collection<ICompilerProblem> problems;
    private DoABCTag doABC;

    public SWFTagsRequestResult(byte[] abcData, String tagName) {
        this(abcData, tagName, Collections.emptySet());
    }

    public SWFTagsRequestResult(byte[] abcData, String tagName, Collection<IEmbedData> embeddedAssets) {
        this.abcData = abcData;
        this.tagName = tagName;
        this.problems = new LinkedList<ICompilerProblem>();
        this.additionalTags = new LinkedList<ITag>();
        this.assetTags = new LinkedHashMap<String, ICharacterTag>();
        for (IEmbedData embedData : embeddedAssets) {
            TranscoderBase transcoder = (TranscoderBase)embedData.getTranscoder();
            Map<String, ICharacterTag> tags = transcoder.getTags(this.additionalTags, this.problems);
            if (tags == null) continue;
            this.assetTags.putAll(tags);
        }
    }

    @Override
    public ICompilerProblem[] getProblems() {
        return this.problems.toArray(new ICompilerProblem[this.problems.size()]);
    }

    @Override
    public boolean addToFrame(SWFFrame f) {
        if (this.abcData == null) {
            return false;
        }
        if (this.doABC == null) {
            this.doABC = new DoABCTag();
            this.doABC.setABCData(this.abcData);
            this.doABC.setName(this.tagName);
        }
        for (ITag iTag : this.additionalTags) {
            f.addTag(iTag);
        }
        f.addTag(this.doABC);
        for (Map.Entry entry : this.assetTags.entrySet()) {
            ICharacterTag assetTag = (ICharacterTag)entry.getValue();
            f.addTag(assetTag);
            f.defineSymbol(assetTag, (String)entry.getKey());
        }
        return true;
    }

    @Override
    public String getDoABCTagName() {
        return this.tagName;
    }

    @Override
    public DoABCTag getDoABCTag() {
        if (this.doABC == null) {
            this.doABC = new DoABCTag();
            this.doABC.setABCData(this.abcData);
            this.doABC.setName(this.tagName);
        }
        return this.doABC;
    }
}

