/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.units;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.royale.abc.ABCEmitter;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.Multiname;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.embedding.IEmbedData;
import org.apache.royale.compiler.internal.abc.ClassGeneratorHelper;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.units.CompilationUnitBase;
import org.apache.royale.compiler.internal.units.requests.ABCBytesRequestResult;
import org.apache.royale.compiler.internal.units.requests.FileScopeRequestResultBase;
import org.apache.royale.compiler.internal.units.requests.SWFTagsRequestResult;
import org.apache.royale.compiler.internal.units.requests.SyntaxTreeRequestResult;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IABCBytesRequestResult;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;
import org.apache.royale.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.royale.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.royale.compiler.units.requests.ISyntaxTreeRequestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceModuleCompilationUnit
extends CompilationUnitBase {
    private final String qname;
    private final Collection<ICompilationUnit> resourceBundleCompUnits;

    public ResourceModuleCompilationUnit(CompilerProject project, String qname, Collection<ICompilationUnit> resourceBundleCompUnits, DefinitionPriority.BasePriority basePriority) {
        super(project, null, basePriority, qname);
        this.resourceBundleCompUnits = resourceBundleCompUnits;
        this.qname = qname;
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.RESOURCE_UNIT;
    }

    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        return new SyntaxTreeRequestResult(-1L, Collections.<ICompilerProblem>emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        FileScopeRequestResultBase fileScopeRequestResultBase;
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        try {
            ASFileScope fileScope = new ASFileScope(this.getProject().getWorkspace(), null);
            Multiname mname = Multiname.crackDottedQName(this.getProject(), this.qname);
            INamespaceDefinition packageNS = (INamespaceDefinition)Iterables.getOnlyElement(mname.getNamespaceSet());
            ClassDefinition classDefinition = new ClassDefinition(mname.getBaseName(), (INamespaceReference)((Object)packageNS));
            fileScope.addDefinition(classDefinition);
            fileScopeRequestResultBase = new FileScopeRequestResultBase(Collections.<ICompilerProblem>emptySet(), (Collection<? extends IASScope>)ImmutableSet.of((Object)fileScope));
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
            throw throwable;
        }
        this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        return fileScopeRequestResultBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        final List problems = Collections.emptyList();
        try {
            try {
                RoyaleProject royaleProject = (RoyaleProject)this.getProject();
                ASProjectScope scope = royaleProject.getScope();
                IDefinition def = scope.findDefinitionByName(royaleProject.getResourceModuleBaseClass());
                ICompilationUnit resourceModuleBaseCompUnit = scope.getCompilationUnitForDefinition(def);
                royaleProject.addDependency((ICompilationUnit)this, resourceModuleBaseCompUnit, DependencyType.INHERITANCE, def.getQualifiedName());
                for (ICompilationUnit compUnit : this.resourceBundleCompUnits) {
                    royaleProject.addDependency(this, compUnit, DependencyType.EXPRESSION);
                }
                Object var9_9 = null;
            }
            catch (Exception t) {
                problems.add(new InternalCompilerProblem(t));
                Object var9_10 = null;
                this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
                return new IOutgoingDependenciesRequestResult(){

                    public ICompilerProblem[] getProblems() {
                        return problems.toArray(new ICompilerProblem[0]);
                    }
                };
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
            throw throwable;
        }
        this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        return new /* invalid duplicate definition of identical inner class */;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        ABCBytesRequestResult aBCBytesRequestResult;
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        try {
            RoyaleProject royaleProject = (RoyaleProject)this.getProject();
            LinkedList<InternalCompilerProblem> problems = new LinkedList<InternalCompilerProblem>();
            ABCEmitter emitter = new ABCEmitter();
            byte[] generatedBytes = null;
            try {
                IResolvedQualifiersReference resourceModuleBaseRef = ReferenceFactory.packageQualifiedReference(royaleProject.getWorkspace(), royaleProject.getResourceModuleBaseClass());
                InstructionList constructorInstructionList = new InstructionList();
                constructorInstructionList.addInstruction(208);
                constructorInstructionList.addInstruction(48);
                int resourceBundleCount = 0;
                for (ICompilationUnit compUnit : this.resourceBundleCompUnits) {
                    for (IDefinition def : compUnit.getDefinitionPromises()) {
                        constructorInstructionList.addInstruction(44, def.getQualifiedName());
                        ++resourceBundleCount;
                    }
                }
                constructorInstructionList.addInstruction(86, resourceBundleCount);
                constructorInstructionList.addInstruction(73, 1);
                constructorInstructionList.addInstruction(71);
                ClassGeneratorHelper classGen = new ClassGeneratorHelper(royaleProject, emitter, new Name(this.qname), (ClassDefinition)resourceModuleBaseRef.resolve(royaleProject), Collections.<Name>emptyList(), constructorInstructionList);
                classGen.finishScript();
                generatedBytes = emitter.emit();
            }
            catch (Exception ex) {
                problems.add(new InternalCompilerProblem(ex));
            }
            aBCBytesRequestResult = new ABCBytesRequestResult(generatedBytes, problems.toArray(new ICompilerProblem[0]), Collections.<IEmbedData>emptySet());
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
            throw throwable;
        }
        this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        return aBCBytesRequestResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        SWFTagsRequestResult sWFTagsRequestResult;
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        try {
            IABCBytesRequestResult abcResult = this.getABCBytesRequest().get();
            sWFTagsRequestResult = new SWFTagsRequestResult(abcResult.getABCBytes(), this.qname);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
            throw throwable;
        }
        this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        return sWFTagsRequestResult;
    }
}

