/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.units;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.as.codegen.CodeGeneratorManager;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.parsing.as.OffsetCue;
import org.apache.royale.compiler.internal.parsing.as.OffsetLookup;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLScopeBuilder;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.MXMLFileScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.internal.tree.mxml.MXMLDocumentNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLFileNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.units.CompilationUnitBase;
import org.apache.royale.compiler.internal.units.requests.ABCBytesRequestResult;
import org.apache.royale.compiler.internal.units.requests.ASFileScopeRequestResult;
import org.apache.royale.compiler.internal.units.requests.SWFTagsRequestResult;
import org.apache.royale.compiler.internal.units.requests.SyntaxTreeRequestResult;
import org.apache.royale.compiler.mxml.IMXMLData;
import org.apache.royale.compiler.mxml.IMXMLDataManager;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.compiler.tree.mxml.IMXMLFileNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStyleNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IABCBytesRequestResult;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;
import org.apache.royale.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.royale.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.royale.compiler.units.requests.ISyntaxTreeRequestResult;

public class MXMLCompilationUnit
extends CompilationUnitBase {
    private final String qname;

    public MXMLCompilationUnit(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority, int order, String qname) {
        super(project, path, basePriority, qname);
        this.qname = qname;
        ((DefinitionPriority)this.getDefinitionPriority()).setOrder(order);
    }

    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.MXML_UNIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        IMXMLFileNode fileNode;
        HashSet<ICompilerProblem> problems;
        MXMLFileScope fileScope;
        block5: {
            IFileScopeRequestResult fileScopeRequestResult = this.getFileScopeRequest().get();
            fileScope = (MXMLFileScope)fileScopeRequestResult.getScopes()[0];
            this.startProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
            IMXMLData mxmlData = this.getMXMLData();
            problems = new HashSet<ICompilerProblem>();
            MXMLTreeBuilder builder = new MXMLTreeBuilder(this, this.getFileSpecificationGetter(), this.qname, mxmlData, fileScope, problems);
            fileNode = builder.build();
            try {
                try {
                    ClassDefinition mainClassDefinition;
                    MXMLDocumentNode documentNode = (MXMLDocumentNode)fileNode.getDocumentNode();
                    if (documentNode != null && (mainClassDefinition = fileScope.getMainClassDefinition()) != null) {
                        TypeScope mainClassScope = (TypeScope)mainClassDefinition.getContainedScope();
                        documentNode.setScope(mainClassScope);
                    }
                    Function<IMXMLStyleNode, ICSSDocument> parseMXMLStyleNode = new Function<IMXMLStyleNode, ICSSDocument>(){

                        public ICSSDocument apply(IMXMLStyleNode mxmlStyleNode) {
                            return mxmlStyleNode.getCSSDocument(problems);
                        }
                    };
                    Collection cssDocumentList = Collections2.transform(fileNode.getStyleNodes(), (Function)parseMXMLStyleNode);
                    this.updateStyleCompilationUnitDependencies(fileNode.getCSSCompilationSession(), fileScope, cssDocumentList, problems);
                    fileNode.getCSSCompilationSession().cssDocuments.addAll(cssDocumentList);
                }
                catch (Exception e) {
                    problems.add(new UnexpectedExceptionProblem(e));
                    Object var11_12 = null;
                    this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
                    break block5;
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
                throw throwable;
            }
            this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        }
        this.getProject().addToASTCache(fileNode);
        return new SyntaxTreeRequestResult(fileNode, (ImmutableSet<String>)ImmutableSet.copyOf(fileScope.getSourceDependencies()), fileNode.getIncludeTreeLastModified(), problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        ASFileScopeRequestResult aSFileScopeRequestResult;
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        try {
            IMXMLData mxmlData = this.getMXMLData();
            MXMLScopeBuilder scopeBuilder = new MXMLScopeBuilder(this, this.getFileSpecificationGetter(), mxmlData, this.qname, this.getAbsoluteFilename());
            MXMLFileScope fileScope = scopeBuilder.build();
            ImmutableList<OffsetCue> offsetCueList = scopeBuilder.getIncludeHandler().getOffsetCueList();
            OffsetLookup offsetLookup = new OffsetLookup(offsetCueList);
            fileScope.setOffsetLookup(offsetLookup);
            Collection<ICompilerProblem> problemCollection = scopeBuilder.getProblems();
            IFileSpecification rootFileSpec = this.getRootFileSpecification();
            this.getProject().getWorkspace().addIncludedFilesToCompilationUnit(this, (Collection<String>)fileScope.getSourceDependencies());
            aSFileScopeRequestResult = new ASFileScopeRequestResult(this.getDefinitionPromises(), this.getDefinitionPriority(), problemCollection, fileScope, rootFileSpec);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
            throw throwable;
        }
        this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        return aSFileScopeRequestResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        ABCBytesRequestResult aBCBytesRequestResult;
        ISyntaxTreeRequestResult syntaxTreeRequestResult = this.getSyntaxTreeRequest().get();
        MXMLFileNode fileNode = (MXMLFileNode)syntaxTreeRequestResult.getAST();
        RoyaleProject project = this.getProject();
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        try {
            ABCBytesRequestResult result;
            aBCBytesRequestResult = result = CodeGeneratorManager.getCodeGenerator().generate(project.getWorkspace().getExecutorService(), project.getUseParallelCodeGeneration(), this.getFilenameNoPath(), fileNode, this.getProject(), this.isInvisible(), this.getEncodedDebugFiles());
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
            throw throwable;
        }
        this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        return aBCBytesRequestResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        SWFTagsRequestResult sWFTagsRequestResult;
        IABCBytesRequestResult abc = this.getABCBytesRequest().get();
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        try {
            sWFTagsRequestResult = new SWFTagsRequestResult(abc.getABCBytes(), this.qname, abc.getEmbeds());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
            throw throwable;
        }
        this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        return sWFTagsRequestResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        IOutgoingDependenciesRequestResult iOutgoingDependenciesRequestResult;
        ISyntaxTreeRequestResult syntaxTreeRequestResult = this.getSyntaxTreeRequest().get();
        MXMLFileNode fileNode = (MXMLFileNode)syntaxTreeRequestResult.getAST();
        this.startParsingImports(fileNode);
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        try {
            this.getABCBytesRequest().get();
            HashSet<ICompilerProblem> problems = new HashSet<ICompilerProblem>();
            this.updateEmbedCompilationUnitDependencies(fileNode.getEmbedNodes(), problems);
            this.getABCBytesRequest().get();
            iOutgoingDependenciesRequestResult = new IOutgoingDependenciesRequestResult(){

                public ICompilerProblem[] getProblems() {
                    return IOutgoingDependenciesRequestResult.NO_PROBLEMS;
                }
            };
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
            throw throwable;
        }
        this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        return iOutgoingDependenciesRequestResult;
    }

    private IMXMLData getMXMLData() {
        IMXMLDataManager mxmlDataManager = this.getProject().getWorkspace().getMXMLDataManager();
        IFileSpecification rootFileSpec = this.getRootFileSpecification();
        IMXMLData mxmlData = mxmlDataManager.get(rootFileSpec);
        return mxmlData;
    }

    public RoyaleProject getProject() {
        return (RoyaleProject)super.getProject();
    }
}

