/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.units;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.royale.compiler.common.IEmbedResolver;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.units.EmbedCompilationUnit;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IFileNodeAccumulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbedCompilationUnitFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmbedCompilationUnit getCompilationUnit(CompilerProject project, String containingSourceFilename, ISourceLocation location, IMetaTagAttribute[] attributes, Collection<ICompilerProblem> problems) throws InterruptedException {
        EmbedCompilationUnit embedCompilationUnit;
        EmbedData data;
        Workspace workspace;
        block6: {
            block5: {
                workspace = project.getWorkspace();
                workspace.embedLock.writeLock().lock();
                try {
                    data = EmbedCompilationUnitFactory.getEmbedData(project, null, containingSourceFilename, location, attributes, problems);
                    if (data != null) break block5;
                    EmbedCompilationUnit embedCompilationUnit2 = null;
                    Object var10_9 = null;
                    workspace.embedLock.writeLock().unlock();
                    return embedCompilationUnit2;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    workspace.embedLock.writeLock().unlock();
                    throw throwable;
                }
            }
            embedCompilationUnit = project.getCompilationUnit(data);
            if (embedCompilationUnit == null) break block6;
            EmbedCompilationUnit embedCompilationUnit3 = embedCompilationUnit;
            Object var10_10 = null;
            workspace.embedLock.writeLock().unlock();
            return embedCompilationUnit3;
        }
        assert (data == project.getWorkspace().getCanonicalEmbedData(data)) : "EmbedData has not been canonicalized";
        embedCompilationUnit = new EmbedCompilationUnit(project, data);
        project.addEmbedCompilationUnit(embedCompilationUnit);
        EmbedCompilationUnit embedCompilationUnit4 = embedCompilationUnit;
        Object var10_11 = null;
        workspace.embedLock.writeLock().unlock();
        return embedCompilationUnit4;
    }

    public static EmbedData getEmbedData(CompilerProject project, String specifiedQName, String containingSourceFilename, ISourceLocation location, IMetaTagAttribute[] attributes, Collection<ICompilerProblem> problems) {
        EmbedData data = new EmbedData(containingSourceFilename, specifiedQName);
        boolean hadError = false;
        for (IMetaTagAttribute attribute : attributes) {
            String value;
            String key = attribute.getKey();
            if (!data.addAttribute(project, location, key, value = attribute.getValue(), problems)) continue;
            hadError = true;
        }
        if (hadError || !data.createTranscoder(project, location, problems)) {
            return null;
        }
        return project.getWorkspace().getCanonicalEmbedData(data);
    }

    public static void collectEmbedDatas(ICompilerProject project, IFileNodeAccumulator fileNode, Set<EmbedData> embeds, Collection<ICompilerProblem> problems) throws InterruptedException {
        List<IEmbedResolver> embedNodes = fileNode.getEmbedNodes();
        for (IEmbedResolver embedNode : embedNodes) {
            EmbedCompilationUnit cu = (EmbedCompilationUnit)embedNode.resolveCompilationUnit(project);
            if (cu == null) continue;
            embeds.add(cu.getEmbedData());
        }
    }
}

