/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.MXMLFileScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLFactoryNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.MXMLSemanticProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLComponentNode;

class MXMLComponentNode
extends MXMLFactoryNode
implements IMXMLComponentNode {
    private String className;
    private MXMLClassDefinitionNode containedClassDefinitionNode;

    MXMLComponentNode(NodeBase parent) {
        super(parent);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLComponentID;
    }

    public String getName() {
        IClassDefinition classDefinition = this.getContainedClassDefinition();
        return classDefinition != null ? classDefinition.getBaseName() : "";
    }

    public int getChildCount() {
        return this.containedClassDefinitionNode != null ? 1 : 0;
    }

    public IASNode getChild(int i) {
        return i == 0 ? this.containedClassDefinitionNode : null;
    }

    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("className")) {
            String rawValue;
            if (this.className == null && (rawValue = attribute.getRawValue()) != null) {
                this.className = attribute.getMXMLDialect().trim(rawValue);
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        boolean handled = false;
        if (this.containedClassDefinitionNode == null) {
            IClassDefinition tagDefinition;
            MXMLSemanticProblem problem;
            this.containedClassDefinitionNode = new MXMLClassDefinitionNode(this);
            handled = true;
            RoyaleProject project = builder.getProject();
            IDefinition tagDef = builder.getFileScope().resolveTagToDefinition(childTag);
            if (tagDef == null) {
                problem = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem);
            }
            if (!(tagDef instanceof IClassDefinition)) {
                problem = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem);
            }
            if ((tagDefinition = (IClassDefinition)tagDef).isFinal()) {
                MXMLSemanticProblem problem2 = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem2);
            }
            MXMLFileScope fileScope = builder.getFileScope();
            ClassDefinition fxComponentClassDefinition = fileScope.getClassDefinitionForComponentTag(tag);
            assert (fxComponentClassDefinition != null) : "MXMLScopeBuilder failed to build a class for an fx:Component";
            TypeScope componentClassScope = (TypeScope)fxComponentClassDefinition.getContainedScope();
            this.containedClassDefinitionNode.setScope(componentClassScope);
            this.containedClassDefinitionNode.setClassReference(project, tagDefinition);
            this.containedClassDefinitionNode.setClassDefinition(fxComponentClassDefinition);
            int nameStart = fxComponentClassDefinition.getNameStart();
            int nameEnd = fxComponentClassDefinition.getNameEnd();
            fxComponentClassDefinition.setNode(this.containedClassDefinitionNode);
            fxComponentClassDefinition.setNameLocation(nameStart, nameEnd);
            this.containedClassDefinitionNode.initializeFromTag(builder, childTag);
        }
        if (!handled) {
            super.processChildTag(builder, tag, childTag, info);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public IMXMLClassDefinitionNode getContainedClassDefinitionNode() {
        return this.containedClassDefinitionNode;
    }

    public IClassDefinition getContainedClassDefinition() {
        return this.containedClassDefinitionNode != null ? this.containedClassDefinitionNode.getClassDefinition() : null;
    }
}

