/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import antlr.Token;
import org.apache.royale.compiler.common.SourceLocation;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.ILiteralNode;

public class LiteralNode
extends ExpressionNodeBase
implements ILiteralNode {
    protected ILiteralNode.LiteralType type;
    protected String value;
    private boolean synthetic;

    public LiteralNode(ILiteralNode.LiteralType type, String value) {
        this.type = type;
        this.value = value;
    }

    public LiteralNode(ILiteralNode.LiteralType type, Token t) {
        this(type, ((IASToken)((Object)t)).getText());
        this.span(t);
    }

    public LiteralNode(ILiteralNode.LiteralType type, String value, SourceLocation sourceLocation) {
        this(type, value);
        this.setSourceLocation(sourceLocation);
    }

    public LiteralNode(ASToken t, ILiteralNode.LiteralType type) {
        this(type, t.getText());
        this.value = t.getText();
        this.span(t);
    }

    protected LiteralNode(LiteralNode other) {
        super(other);
        this.type = other.type;
        this.value = other.value;
        this.synthetic = other.synthetic;
    }

    public ASTNodeID getNodeID() {
        switch (this.type) {
            case ARRAY: {
                return ASTNodeID.LiteralArrayID;
            }
            case BOOLEAN: {
                return ASTNodeID.LiteralBooleanID;
            }
            case NULL: {
                return ASTNodeID.LiteralNullID;
            }
            case NUMBER: {
                return ASTNodeID.LiteralNumberID;
            }
            case OBJECT: {
                return ASTNodeID.LiteralObjectID;
            }
            case REGEXP: {
                return ASTNodeID.LiteralRegexID;
            }
            case STRING: {
                return ASTNodeID.LiteralStringID;
            }
            case VOID: {
                return ASTNodeID.LiteralVoidID;
            }
            case XML: {
                return ASTNodeID.LiteralXMLID;
            }
        }
        return ASTNodeID.LiteralID;
    }

    public void normalize(boolean fillInOffsets) {
    }

    protected boolean buildInnerString(StringBuilder sb) {
        String type = this.getLiteralType().getType().getName();
        boolean isString = type.equals("String");
        sb.append(type);
        sb.append(' ');
        if (isString) {
            sb.append('\"');
        }
        sb.append(this.getValue());
        if (isString) {
            sb.append('\"');
        }
        return true;
    }

    public boolean isTerminal() {
        return true;
    }

    public ITypeDefinition resolveType(ICompilerProject project) {
        ILiteralNode.LiteralType l = this.getLiteralType();
        return project.getBuiltinType(l.getType());
    }

    protected LiteralNode copy() {
        return new LiteralNode(this);
    }

    public boolean isDynamicExpression(ICompilerProject project) {
        return false;
    }

    public ILiteralNode.LiteralType getLiteralType() {
        return this.type;
    }

    public String getValue() {
        return this.getValue(false);
    }

    public String getValue(boolean rawValue) {
        String retVal = this.value;
        if (this.type == ILiteralNode.LiteralType.STRING) {
            if (rawValue || retVal == null || retVal.length() == 0) {
                return retVal;
            }
            switch (retVal.charAt(0)) {
                case '\"': 
                case '\'': {
                    retVal = retVal.substring(1);
                }
            }
            if (retVal.length() >= 1) {
                switch (retVal.charAt(retVal.length() - 1)) {
                    case '\"': 
                    case '\'': {
                        retVal = retVal.substring(0, retVal.length() - 1);
                    }
                }
            } else {
                return "";
            }
        }
        return retVal;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }
}

