/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import java.util.ArrayList;
import org.apache.royale.compiler.internal.tree.as.ConditionalNode;
import org.apache.royale.compiler.internal.tree.as.TerminalNode;
import org.apache.royale.compiler.internal.tree.as.TreeNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IConditionalNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIfNode;
import org.apache.royale.compiler.tree.as.ITerminalNode;

public class IfNode
extends TreeNode
implements IIfNode {
    public IfNode(IASToken keyword) {
        if (keyword != null) {
            this.startBefore(keyword);
        }
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.IfStatementID;
    }

    public IASNode getStatementContentsNode() {
        return this;
    }

    public IExpressionNode getConditionalExpressionNode() {
        IASNode child = this.getChild(0);
        if (child instanceof ConditionalNode) {
            return ((ConditionalNode)child).getConditionalExpressionNode();
        }
        return null;
    }

    public IConditionalNode[] getElseIfNodes() {
        int childCount = this.getChildCount();
        ArrayList<IConditionalNode> retVal = new ArrayList<IConditionalNode>(childCount);
        for (int i = 1; i < childCount; ++i) {
            IASNode child = this.getChild(i);
            if (!(child instanceof IConditionalNode)) continue;
            retVal.add((IConditionalNode)child);
        }
        return retVal.toArray(new IConditionalNode[0]);
    }

    public ITerminalNode getElseNode() {
        int childCount = this.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            IASNode child = this.getChild(i);
            if (!(child instanceof ITerminalNode)) continue;
            return (ITerminalNode)child;
        }
        return null;
    }

    public void addBranch(ConditionalNode node) {
        this.addChild(node);
    }

    public void addBranch(TerminalNode node) {
        this.addChild(node);
    }
}

