/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IIdentifierNode;

public class FullNameNode
extends MemberAccessExpressionNode
implements IIdentifierNode {
    public static ExpressionNodeBase toMemberAccessExpressionNode(ExpressionNodeBase node) {
        if (node instanceof FullNameNode) {
            FullNameNode fullnameNode = (FullNameNode)node;
            ExpressionNodeBase left = FullNameNode.toMemberAccessExpressionNode(fullnameNode.leftOperandNode);
            ExpressionNodeBase right = FullNameNode.toMemberAccessExpressionNode(fullnameNode.rightOperandNode);
            MemberAccessExpressionNode result = new MemberAccessExpressionNode(left, null, right);
            result.operatorStart = fullnameNode.operatorStart;
            result.setHasParenthesis(fullnameNode.hasParenthesis());
            return result;
        }
        return node;
    }

    public FullNameNode(ExpressionNodeBase left, IASToken operator, ExpressionNodeBase right) {
        super(left, operator, right);
        if (right != null) {
            this.setEnd(right.getAbsoluteEnd());
        }
    }

    protected FullNameNode(MemberAccessExpressionNode node) {
        super(node.leftOperandNode, null, node.rightOperandNode);
        this.operatorStart = node.operatorStart;
        this.setHasParenthesis(node.hasParenthesis());
    }

    protected FullNameNode(FullNameNode other) {
        super(other);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.FullNameID;
    }

    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        return true;
    }

    protected FullNameNode copy() {
        return new FullNameNode(this);
    }

    public String computeSimpleReference() {
        return this.getName();
    }

    public void setRightOperandNode(ExpressionNodeBase right) {
        super.setRightOperandNode(right);
        if (right != null) {
            this.setEnd(right.getAbsoluteEnd());
        }
    }

    public String getName() {
        if (this.leftOperandNode != null && this.leftOperandNode != this && (this.leftOperandNode instanceof IdentifierNode || this.leftOperandNode instanceof FullNameNode) && this.rightOperandNode != null && this.rightOperandNode != this && (this.rightOperandNode instanceof IdentifierNode || this.rightOperandNode instanceof FullNameNode)) {
            StringBuilder builder = new StringBuilder();
            builder.append(((IIdentifierNode)((Object)this.leftOperandNode)).getName());
            builder.append(".");
            builder.append(((IIdentifierNode)((Object)this.rightOperandNode)).getName());
            return builder.toString();
        }
        return "";
    }

    public IIdentifierNode.IdentifierType getIdentifierType() {
        return IIdentifierNode.IdentifierType.FULLY_QUALIFIED_NAME;
    }
}

