/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.targets.RoyaleFrame1Info;
import org.apache.royale.compiler.internal.units.ASCompilationUnit;
import org.apache.royale.compiler.internal.units.MXMLCompilationUnit;
import org.apache.royale.compiler.problems.CompiledAsAComponentProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RoyaleApplicationFrame1Info
extends RoyaleFrame1Info {
    private final ITargetSettings targetSettings;
    private final IClassDefinition mainApplicationClassDefinition;
    private final boolean generateSystemManagerAndFlexInit;
    private final boolean isFlexInfo;
    private final ApplicationAndModuleDefinitions appAndModuleDefs;
    final TreeSet<String> mixinClassNames;
    final HashSet<String> contributingSWCs;

    RoyaleApplicationFrame1Info(RoyaleProject royaleProject, ITargetSettings targetSettings, IClassDefinition mainApplicationClassDefinition, boolean generateSystemManagerAndFlexInit, boolean isFlexInfo, ImmutableSet<ICompilationUnit> builtCompilationUnits) throws InterruptedException {
        super(royaleProject);
        this.targetSettings = targetSettings;
        this.mainApplicationClassDefinition = mainApplicationClassDefinition;
        this.generateSystemManagerAndFlexInit = generateSystemManagerAndFlexInit;
        this.isFlexInfo = isFlexInfo;
        this.mixinClassNames = new TreeSet();
        this.contributingSWCs = new HashSet();
        this.appAndModuleDefs = new ApplicationAndModuleDefinitions();
        this.collectFromCompilationUnits((Iterable<ICompilationUnit>)builtCompilationUnits);
    }

    @Override
    protected void collectFromCompilationUnit(ICompilationUnit cu) throws InterruptedException {
        super.collectFromCompilationUnit(cu);
        if (this.generateSystemManagerAndFlexInit) {
            RoyaleApplicationFrame1Info.collectMixinMetaData(this.mixinClassNames, cu);
            this.collectContributingSWCs(this.contributingSWCs, cu);
            this.checkForCompiledAsAComponentProblem(this.appAndModuleDefs, this.problems, cu);
        } else if (this.isFlexInfo) {
            RoyaleApplicationFrame1Info.collectMixinMetaData(this.mixinClassNames, cu);
        }
    }

    public static void collectMixinMetaData(TreeSet<String> mixinClassNames, ICompilationUnit compilationUnit) throws InterruptedException {
        IFileScopeRequestResult result = compilationUnit.getFileScopeRequest().get();
        for (IDefinition def : result.getExternallyVisibleDefinitions()) {
            IMetaTag md = def.getMetaTagByName("Mixin");
            if (md == null) continue;
            mixinClassNames.add(def.getQualifiedName());
        }
    }

    public static void collectRemoteClassMetaData(Map<String, String> remoteClassNames, ICompilationUnit compilationUnit) throws InterruptedException {
        IFileScopeRequestResult result = compilationUnit.getFileScopeRequest().get();
        for (IDefinition def : result.getExternallyVisibleDefinitions()) {
            IMetaTag md = def.getMetaTagByName("RemoteClass");
            if (md == null) continue;
            remoteClassNames.put(def.getQualifiedName(), md.getAttributeValue("alias"));
        }
    }

    private void collectContributingSWCs(HashSet<String> contributingSWCs, ICompilationUnit cu) {
        if (!this.targetSettings.removeUnusedRuntimeSharedLibraryPaths()) {
            return;
        }
        if (cu.getCompilationUnitType() == ICompilationUnit.UnitType.SWC_UNIT) {
            contributingSWCs.add(cu.getAbsoluteFilename());
        }
    }

    private void checkForCompiledAsAComponentProblem(ApplicationAndModuleDefinitions appAndModuleDefs, ArrayList<ICompilerProblem> problems, ICompilationUnit cu) throws InterruptedException {
        if (!(cu instanceof MXMLCompilationUnit) && !(cu instanceof ASCompilationUnit) || this.mainApplicationClassDefinition == null) {
            return;
        }
        IFileScopeRequestResult result = cu.getFileScopeRequest().get();
        for (IDefinition def : result.getExternallyVisibleDefinitions()) {
            if (!appAndModuleDefs.isApplicationOrModule(def)) continue;
            assert (def instanceof ITypeDefinition);
            ITypeDefinition typeDef = (ITypeDefinition)def;
            assert (this.mainApplicationClassDefinition instanceof ITypeDefinition);
            if (this.mainApplicationClassDefinition.isInstanceOf(typeDef, (ICompilerProject)this.royaleProject)) continue;
            problems.add(new CompiledAsAComponentProblem(cu.getName(), this.mainApplicationClassDefinition.getBaseName()));
        }
    }

    @Override
    Set<String> getMixins() {
        return this.mixinClassNames;
    }

    private class ApplicationAndModuleDefinitions {
        final ITypeDefinition sparkApplication;
        final ITypeDefinition haloApplication;
        final ITypeDefinition iModule;

        ApplicationAndModuleDefinitions() {
            IResolvedQualifiersReference sparkAppRef = ReferenceFactory.packageQualifiedReference(RoyaleApplicationFrame1Info.this.royaleProject.getWorkspace(), "spark.components.Application");
            IResolvedQualifiersReference haloAppRef = ReferenceFactory.packageQualifiedReference(RoyaleApplicationFrame1Info.this.royaleProject.getWorkspace(), "mx.core.Application");
            IResolvedQualifiersReference iModuleRef = ReferenceFactory.packageQualifiedReference(RoyaleApplicationFrame1Info.this.royaleProject.getWorkspace(), "mx.modules.IModule");
            this.sparkApplication = this.resolveType(sparkAppRef);
            this.haloApplication = this.resolveType(haloAppRef);
            this.iModule = this.resolveType(iModuleRef);
        }

        boolean isApplicationOrModule(IDefinition def) {
            if (!(def instanceof ITypeDefinition)) {
                return false;
            }
            ITypeDefinition typeDef = (ITypeDefinition)def;
            if (typeDef == this.sparkApplication || typeDef == this.iModule || typeDef == this.haloApplication) {
                return false;
            }
            return this.sparkApplication != null && typeDef.isInstanceOf(this.sparkApplication, (ICompilerProject)RoyaleApplicationFrame1Info.this.royaleProject) || this.iModule != null && typeDef.isInstanceOf(this.iModule, (ICompilerProject)RoyaleApplicationFrame1Info.this.royaleProject) || this.haloApplication != null && typeDef.isInstanceOf(this.iModule, (ICompilerProject)RoyaleApplicationFrame1Info.this.royaleProject);
        }

        private ITypeDefinition resolveType(IResolvedQualifiersReference ref) {
            IDefinition def = ref.resolve(RoyaleApplicationFrame1Info.this.royaleProject);
            if (!(def instanceof ITypeDefinition)) {
                return null;
            }
            return (ITypeDefinition)def;
        }
    }
}

