/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import java.util.Arrays;
import java.util.List;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.scopes.IDefinitionStore;
import org.apache.royale.compiler.internal.scopes.IMutableDefinitionSet;
import org.apache.royale.compiler.internal.scopes.LargeDefinitionSet;
import org.apache.royale.compiler.internal.scopes.SmallDefinitionSet;
import org.apache.royale.compiler.scopes.IDefinitionSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SmallDefinitionStoreBase
implements IDefinitionStore {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected static String getBaseName(IDefinitionSet definitionSet) {
        if (definitionSet == null || definitionSet.getSize() == 0) {
            return null;
        }
        IDefinition firstDefinition = definitionSet.getDefinition(0);
        return firstDefinition.getBaseName();
    }

    public static IDefinitionSet addDefinitionToSet(IDefinitionSet oldDefinitionSet, IDefinition definition) {
        assert (definition != null) : "Definition cannot be null";
        assert (SmallDefinitionStoreBase.getBaseName(oldDefinitionSet) == null || SmallDefinitionStoreBase.getBaseName(oldDefinitionSet).equals(definition.getBaseName())) : "Base name must match";
        IDefinitionSet newDefinitionSet = oldDefinitionSet;
        if (oldDefinitionSet == null) {
            newDefinitionSet = (DefinitionBase)definition;
        } else if (oldDefinitionSet.getMaxSize() == 1) {
            newDefinitionSet = new SmallDefinitionSet((IDefinition)((Object)oldDefinitionSet), definition);
        } else if (oldDefinitionSet.getMaxSize() == 2) {
            if (oldDefinitionSet.getSize() == oldDefinitionSet.getMaxSize()) {
                newDefinitionSet = new LargeDefinitionSet(oldDefinitionSet);
            }
            ((IMutableDefinitionSet)newDefinitionSet).addDefinition(definition);
        } else {
            ((LargeDefinitionSet)newDefinitionSet).addDefinition(definition);
        }
        return newDefinitionSet;
    }

    public static boolean removeDefinitionFromSet(IDefinitionSet definitionSet, IDefinition definition) {
        assert (definitionSet != null) : "Definition set cannot be null";
        assert (definition != null) : "Definition cannot be null";
        assert (definition.getBaseName().equals(SmallDefinitionStoreBase.getBaseName(definitionSet))) : "Base name must match";
        if (definitionSet.getMaxSize() == 1) {
            return true;
        }
        ((IMutableDefinitionSet)definitionSet).removeDefinition(definition);
        return definitionSet.isEmpty();
    }

    protected static void addBaseNameToList(List<String> list, IDefinitionSet definitionSet) {
        String baseName = SmallDefinitionStoreBase.getBaseName(definitionSet);
        if (baseName != null) {
            list.add(baseName);
        }
    }

    protected static void addDefinitionSetToList(List<IDefinitionSet> list, IDefinitionSet definitionSet) {
        if (definitionSet != null) {
            list.add(definitionSet);
        }
    }

    protected static void addDefinitionsToList(List<IDefinition> list, IDefinitionSet definitionSet) {
        if (definitionSet == null) {
            return;
        }
        int n = definitionSet.getSize();
        for (int i = 0; i < n; ++i) {
            IDefinition definition = definitionSet.getDefinition(i);
            list.add(definition);
        }
    }

    @Override
    public boolean add(IDefinition definition) {
        assert (definition != null) : "A null definition cannot be added to a store";
        String baseName = definition.getBaseName();
        int i = this.findIndexForBaseName(baseName);
        if (i == -1) {
            i = this.findAvailableIndex();
        }
        if (i == -1) {
            return false;
        }
        IDefinitionSet oldDefinitionSet = this.getDefinitionSet(i);
        IDefinitionSet newDefinitionSet = SmallDefinitionStoreBase.addDefinitionToSet(oldDefinitionSet, definition);
        if (newDefinitionSet != oldDefinitionSet) {
            this.setDefinitionSet(i, newDefinitionSet);
        }
        return true;
    }

    @Override
    public boolean remove(IDefinition definition) {
        assert (definition != null) : "A null definition cannot be removed from a store";
        String baseName = definition.getBaseName();
        int i = this.findIndexForBaseName(baseName);
        if (i == -1) {
            return false;
        }
        IDefinitionSet oldDefinitionSet = this.getDefinitionSet(i);
        if (SmallDefinitionStoreBase.removeDefinitionFromSet(oldDefinitionSet, definition)) {
            this.setDefinitionSet(i, null);
        }
        return true;
    }

    @Override
    public abstract IDefinitionSet getDefinitionSetByName(String var1);

    @Override
    public abstract int getCapacity();

    protected abstract IDefinitionSet getDefinitionSet(int var1);

    protected abstract void setDefinitionSet(int var1, IDefinitionSet var2);

    protected abstract int findIndexForBaseName(String var1);

    protected abstract int findAvailableIndex();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Object[] names = this.getAllNames().toArray(EMPTY_STRING_ARRAY);
        Arrays.sort(names);
        for (Object name : names) {
            sb.append((String)name);
            sb.append('\n');
            IDefinitionSet set = this.getDefinitionSetByName((String)name);
            int n = set.getSize();
            for (int i = 0; i < n; ++i) {
                IDefinition d = set.getDefinition(i);
                sb.append("  ");
                sb.append(d.toString());
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

