/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.royale.compiler.fxg.FXGVersion;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.GraphicNode;
import org.apache.royale.compiler.problems.FXGChildNodeNotSupportedProblem;
import org.apache.royale.compiler.problems.FXGInvalidChildNodeProblem;
import org.apache.royale.compiler.problems.FXGInvalidNodeAttributeProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFXGNode
implements IFXGNode {
    protected IFXGNode documentNode;
    protected String uri;
    protected int startLine;
    protected int startColumn;
    protected int endLine;
    protected int endColumn;
    public static final double ALPHA_MIN_INCLUSIVE = 0.0;
    public static final double ALPHA_MAX_INCLUSIVE = 1.0;
    public static final int COLOR_BLACK = -16777216;
    public static final int COLOR_WHITE = -1;
    public static final int COLOR_RED = -65536;
    public static final int GRADIENT_ENTRIES_MAX_INCLUSIVE = 15;
    public static final double EPSILON = 1.0E-5;

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child == null) {
            problems.add(new FXGChildNodeNotSupportedProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), this.getNodeName()));
        } else {
            problems.add(new FXGInvalidChildNodeProblem(this.getDocumentPath(), child.getStartLine(), child.getStartColumn(), child.getNodeName(), this.getNodeName()));
        }
    }

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> children = new ArrayList<IFXGNode>();
        return children;
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if (!this.isVersionGreaterThanCompiler()) {
            problems.add(new FXGInvalidNodeAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), name, this.getNodeName()));
        }
    }

    @Override
    public IFXGNode getDocumentNode() {
        return this.documentNode;
    }

    @Override
    public void setDocumentNode(IFXGNode root) {
        this.documentNode = root;
    }

    @Override
    public String getDocumentPath() {
        return ((GraphicNode)this.getDocumentNode()).getDocumentPath();
    }

    @Override
    public String getNodeURI() {
        return this.uri;
    }

    public void setNodeURI(String uri) {
        this.uri = uri;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public void setStartLine(int line) {
        this.startLine = line;
    }

    @Override
    public int getStartColumn() {
        return this.startColumn;
    }

    @Override
    public void setStartColumn(int column) {
        this.startColumn = column;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public void setEndLine(int line) {
        this.endLine = line;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    @Override
    public void setEndColumn(int column) {
        this.endColumn = column;
    }

    public boolean isVersionGreaterThanCompiler() {
        return ((GraphicNode)this.documentNode).isVersionGreaterThanCompiler();
    }

    public FXGVersion getFileVersion() {
        return ((GraphicNode)this.documentNode).getVersion();
    }
}

