/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.css.ICSSManager;
import org.apache.royale.compiler.css.ICSSRule;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.caches.CSSDocumentCache;
import org.apache.royale.compiler.internal.caches.CacheStoreKeyBase;
import org.apache.royale.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.royale.compiler.internal.css.semantics.CSSSemanticAnalyzer;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.units.EmbedCompilationUnit;
import org.apache.royale.compiler.problems.CSSUnresolvedClassReferenceProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCFileEntry;
import org.apache.royale.swc.ISWCManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSManager
implements ICSSManager {
    private final RoyaleProject royaleProject;

    static void getClassDefinitionDependencies(CSSCompilationSession session, RoyaleProject royaleProject, ImmutableSet<ICSSRule> cssRules, Set<IClassDefinition> classReferences, Set<EmbedCompilationUnit> embedCompilationUnits, Collection<ICompilerProblem> problems) {
        for (ICSSRule matchedRule : cssRules) {
            CSSSemanticAnalyzer.resolveDependencies(session.resolvedEmbedProperties, matchedRule, royaleProject, classReferences, embedCompilationUnits, problems);
        }
    }

    static ImmutableSet<ICompilationUnit> getCompilationUnitsForDefinitions(RoyaleProject royaleProject, Set<IClassDefinition> classDefinitions, Collection<ICompilerProblem> problems) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (IClassDefinition classDefinition : classDefinitions) {
            ASProjectScope scope = royaleProject.getScope();
            ICompilationUnit compilationUnit = scope.getCompilationUnitForDefinition(classDefinition);
            if (compilationUnit != null) {
                builder.add((Object)compilationUnit);
                continue;
            }
            assert (CSSManager.problemCreatedForUnresolvedClassReference(problems, classDefinition)) : "Can't find compilation unit for class '" + classDefinition.getQualifiedName() + "'. Expected a 'CSSUnresolvedClassReference'.";
        }
        return builder.build();
    }

    static boolean problemCreatedForUnresolvedClassReference(Collection<ICompilerProblem> problems, IClassDefinition classDefinition) {
        for (ICompilerProblem problem : problems) {
            if (!(problem instanceof CSSUnresolvedClassReferenceProblem)) continue;
            CSSUnresolvedClassReferenceProblem unresolved = (CSSUnresolvedClassReferenceProblem)problem;
            if (!unresolved.qname.equals(classDefinition.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public CSSManager(RoyaleProject royaleProject) {
        assert (royaleProject != null);
        this.royaleProject = royaleProject;
    }

    @Override
    public Collection<ICSSDocument> getCSSFromStyleModules() {
        return null;
    }

    @Override
    public Collection<ICSSDocument> getCSSFromSWCDefaultStyle() {
        ArrayList<ICSSDocument> result = new ArrayList<ICSSDocument>();
        for (ISWC swc : this.royaleProject.getLibraries()) {
            ICSSDocument css = this.getDefaultCSS(swc.getSWCFile());
            if (css == null) continue;
            result.add(css);
        }
        return result;
    }

    @Override
    public ICSSDocument getDefaultCSS(File swcFile) {
        ISWCManager swcManager = this.royaleProject.getWorkspace().getSWCManager();
        CSSDocumentCache cache = (CSSDocumentCache)swcManager.getCSSDocumentCache();
        ISWC swc = swcManager.get(swcFile);
        ITargetSettings ts = this.royaleProject.getTargetSettings();
        List<String> excludedCSSFiles = ts != null ? ts.getExcludeDefaultsCSSFiles() : null;
        String defaultsCSS = swcFile.getName() + ":defaults.css";
        if (excludedCSSFiles != null && excludedCSSFiles.contains(defaultsCSS)) {
            return null;
        }
        return cache.getDefaultsCSS(swc, this.royaleProject.getCompatibilityVersion());
    }

    @Override
    public Collection<ICompilationUnit> getDependentCompilationUnitsFromCSS(CSSCompilationSession session, ICSSDocument cssDocument, Collection<IDefinition> definitions, Collection<ICompilerProblem> problems) {
        assert (cssDocument != null) : "Expected CSS document to get CSS dependencies.";
        assert (definitions != null) : "Expected a set of definitions to activate CSS rules.";
        assert (problems != null) : "Expected problems collection. Do not ignore problems.";
        ImmutableSet qnames = CSSSemanticAnalyzer.buildQNameToDefinitionMap(CSSSemanticAnalyzer.getClassDefinitionSet(definitions)).keySet();
        ImmutableSet<ICSSRule> matchedRules = CSSSemanticAnalyzer.getMatchedRules(session, this.royaleProject, cssDocument, (ImmutableSet<String>)qnames, problems);
        HashSet<IClassDefinition> classReferences = new HashSet<IClassDefinition>();
        HashSet<EmbedCompilationUnit> embedCompilationUnits = new HashSet<EmbedCompilationUnit>();
        CSSManager.getClassDefinitionDependencies(session, this.royaleProject, matchedRules, classReferences, embedCompilationUnits, problems);
        ImmutableSet<ICompilationUnit> classReferenceCompilationUnits = CSSManager.getCompilationUnitsForDefinitions(this.royaleProject, classReferences, problems);
        for (ICSSRule rule : matchedRules) {
            session.activatedRules.add(rule);
        }
        return new ImmutableSet.Builder().addAll(classReferenceCompilationUnits).addAll(embedCompilationUnits).build();
    }

    @Override
    public Collection<ICSSDocument> getCSSFromThemes(Collection<ICompilerProblem> problems) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        ISWCManager swcManager = this.royaleProject.getWorkspace().getSWCManager();
        CSSDocumentCache cssCache = (CSSDocumentCache)swcManager.getCSSDocumentCache();
        ITargetSettings ts = this.royaleProject.getTargetSettings();
        List<String> excludedCSSFiles = ts != null ? ts.getExcludeDefaultsCSSFiles() : null;
        for (IFileSpecification themeFile : this.royaleProject.getThemeFiles()) {
            if (excludedCSSFiles != null && excludedCSSFiles.contains(themeFile.getPath())) continue;
            try {
                ICSSDocument css;
                ISWC swc;
                String extension = FilenameUtils.getExtension((String)themeFile.getPath());
                if ("swc".equalsIgnoreCase(extension)) {
                    swc = swcManager.get(new File(themeFile.getPath()));
                    css = cssCache.getDefaultsCSS(swc, this.royaleProject.getCompatibilityVersion());
                } else {
                    if (!"css".equalsIgnoreCase(extension)) continue;
                    CacheStoreKeyBase key = CSSDocumentCache.createKey(themeFile.getPath());
                    css = (ICSSDocument)cssCache.get(key);
                }
                if (css != null && css != CSSDocumentCache.EMPTY_CSS_DOCUMENT) {
                    builder.add((Object)css);
                }
                if (!"swc".equalsIgnoreCase(extension)) continue;
                swc = swcManager.get(new File(themeFile.getPath()));
                Map<String, ISWCFileEntry> files = swc.getFiles();
                Set<String> fileNames = files.keySet();
                for (String fileName : fileNames) {
                    String suffix = FilenameUtils.getExtension((String)fileName);
                    if (!"css".equalsIgnoreCase(suffix) || fileName.contains("default")) continue;
                    CacheStoreKeyBase key = CSSDocumentCache.createKey(swc, fileName);
                    ICSSDocument extracss = (ICSSDocument)cssCache.get(key);
                    builder.add((Object)extracss);
                }
            }
            catch (CSSDocumentCache.ProblemParsingCSSRuntimeException cssError) {
                problems.addAll(cssError.cssParserProblems);
            }
        }
        return builder.build();
    }

    @Override
    public boolean isFlex3CSS() {
        Integer compatibilityVersion = this.royaleProject.getCompatibilityVersion();
        if (compatibilityVersion == null) {
            return false;
        }
        return compatibilityVersion <= 0x3000000;
    }

    @Override
    public ICSSDocument getCSS(String cssFilename) {
        CacheStoreKeyBase key;
        CSSDocumentCache cache = (CSSDocumentCache)this.royaleProject.getWorkspace().getSWCManager().getCSSDocumentCache();
        ICSSDocument css = (ICSSDocument)cache.get(key = CSSDocumentCache.createKey(cssFilename));
        if (CSSDocumentCache.EMPTY_CSS_DOCUMENT == css) {
            return null;
        }
        return css;
    }
}

