/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.as.codegen;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.royale.compiler.internal.as.codegen.CmcEmitter;
import org.apache.royale.compiler.internal.as.codegen.UnknownTreeFinding;
import org.apache.royale.compiler.internal.as.codegen.UnknownTreeHandlerPatterns;
import org.apache.royale.compiler.problems.BURMPatternMatchFailureProblem;
import org.apache.royale.compiler.problems.CodegenInternalProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnknownTreeHandler {
    Collection<ICompilerProblem> problems;

    public UnknownTreeHandler(Collection<ICompilerProblem> problems) {
        this.problems = problems;
    }

    public void analyze(CmcEmitter.JBurgAnnotation root) {
        Collection<UnknownTreeFinding> findings = this.exploreSubtrees(root);
        if (findings.isEmpty()) {
            this.problems.add(new BURMPatternMatchFailureProblem(root.getNode()));
        } else {
            for (UnknownTreeFinding finding : findings) {
                this.problems.add(finding.problem);
            }
        }
    }

    Collection<UnknownTreeFinding> exploreSubtrees(CmcEmitter.JBurgAnnotation subtree_root) {
        ArrayList<UnknownTreeFinding> result = new ArrayList<UnknownTreeFinding>();
        ArrayList<UnknownTreeFinding> provisional_findings = new ArrayList<UnknownTreeFinding>();
        for (UnknownTreeFinding match : this.findMatches(subtree_root)) {
            if (match.provisional) {
                provisional_findings.add(match);
                continue;
            }
            result.add(match);
        }
        boolean definite_finding_at_level = !result.isEmpty();
        for (int i = 0; i < subtree_root.getArity(); ++i) {
            if (!definite_finding_at_level) {
                result.addAll(this.exploreSubtrees(subtree_root.getNthChild(i)));
                continue;
            }
            for (UnknownTreeFinding sub_finding : this.exploreSubtrees(subtree_root.getNthChild(i))) {
                if (sub_finding.provisional) continue;
                result.add(sub_finding);
            }
        }
        if (result.isEmpty()) {
            result = provisional_findings;
        }
        return result;
    }

    ArrayList<UnknownTreeFinding> findMatches(CmcEmitter.JBurgAnnotation annotation) {
        IASNode node = annotation.getNode();
        ArrayList candidates = new ArrayList();
        ArrayList<UnknownTreeFinding> result = new ArrayList<UnknownTreeFinding>();
        if (UnknownTreeHandlerPatterns.allTemplates.containsKey((Object)node.getNodeID())) {
            candidates.addAll(UnknownTreeHandlerPatterns.allTemplates.get((Object)node.getNodeID()));
        }
        if (UnknownTreeHandlerPatterns.allTemplates.containsKey((Object)ASTNodeID.UnknownID)) {
            candidates.addAll(UnknownTreeHandlerPatterns.allTemplates.get((Object)ASTNodeID.UnknownID));
        }
        for (UnknownTreeFinding.Template candidate : candidates) {
            if (!candidate.matches(annotation)) continue;
            try {
                result.add(candidate.createFinding(candidate.getInnermostMatchedNode(annotation)));
            }
            catch (Exception ex) {
                this.problems.add(new CodegenInternalProblem(node, ex));
            }
        }
        return result;
    }
}

