/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.flex.tools.FlexTool;
import org.apache.royale.compiler.Messages;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.common.VersionInfo;
import org.apache.royale.compiler.config.CommandLineConfigurator;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.ConfigurationBuffer;
import org.apache.royale.compiler.config.ConfigurationPathResolver;
import org.apache.royale.compiler.config.ConfigurationValue;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.config.IConfigurationFilter;
import org.apache.royale.compiler.internal.config.annotations.Arguments;
import org.apache.royale.compiler.internal.config.annotations.Config;
import org.apache.royale.compiler.internal.config.localization.LocalizationManager;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.targets.AppSWFTarget;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ConfigurationProblem;
import org.apache.royale.compiler.problems.FileNotFoundProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetProgressMonitor;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.swf.Header;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.io.SWFReader;
import org.apache.royale.swf.io.SizeReportWritingSWFWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Optimizer
implements FlexTool {
    static final String NEWLINE = System.getProperty("line.separator");
    private static final String DEFAULT_VAR = "input";
    private static final String L10N_CONFIG_PREFIX = "org.apache.royale.compiler.internal.config.configuration";
    private Workspace workspace = new Workspace();
    private RoyaleProject project = new RoyaleProject(this.workspace);
    private Configurator projectConfigurator;
    private OptimizerConfiguration config;
    private ITargetSettings targetSettings;
    private ProblemQuery problems = new ProblemQuery();
    protected ConfigurationBuffer configBuffer;

    public static void main(String[] args) {
        int exitCode = Optimizer.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        Optimizer optimizer = new Optimizer();
        return optimizer.mainNoExit(args);
    }

    public String getName() {
        return "OPTIMIZER";
    }

    public int execute(String[] args) {
        return this.mainNoExit(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int mainNoExit(String[] args) {
        block18: {
            result = 0;
            startTime = System.nanoTime();
            if (this.configure(args)) {
                targetSettings = this.getTargetSettings();
                inputFile = new File(this.getInputFilePath());
                outputFile = new File(this.config.getOutput());
                in = null;
                try {
                    block17: {
                        if (inputFile.exists()) {
                            in = new BufferedInputStream(new FileInputStream(inputFile));
                            reader = new SWFReader();
                            try {
                                swf = reader.readFrom(in, this.getInputFilePath());
                                this.problems.addAll(reader.getProblems());
                                linkProblems = new ArrayList<ICompilerProblem>();
                                target = new OptimizerSWFTarget(swf, this.project, targetSettings, null);
                                optimizedSWF = target.build(linkProblems);
                                this.problems.addAll(linkProblems);
                                if (!this.problems.hasErrors()) {
                                    compression = Header.decideCompression(true, swf.getVersion(), false);
                                    writerFactory = SizeReportWritingSWFWriter.getSWFWriterFactory(targetSettings.getSizeReport());
                                    writer = writerFactory.createSWFWriter(optimizedSWF, compression, targetSettings.isDebugEnabled(), targetSettings.isTelemetryEnabled());
                                    swfSize = writer.writeTo(outputFile);
                                    endTime = System.nanoTime();
                                    seconds = String.format("%5.3f", new Object[]{(double)(endTime - startTime) / 1.0E9});
                                    params = new HashMap<String, Object>();
                                    params.put("byteCount", swfSize);
                                    params.put("path", outputFile.getCanonicalPath());
                                    params.put("seconds", seconds);
                                    System.out.println(Messages.getString("MXMLC.bytes_written_to_file_in_seconds_format", params));
                                }
                                var23_22 = null;
                            }
                            catch (Throwable var22_24) {
                                var23_23 = null;
                                IOUtils.closeQuietly((Closeable)reader);
                                throw var22_24;
                            }
                            IOUtils.closeQuietly((Closeable)reader);
                            {
                                break block17;
                            }
                        }
                        this.problems.add(new FileNotFoundProblem(inputFile.getAbsolutePath()));
                    }
                    var25_25 = null;
                    ** if (in == null) goto lbl-1000
                }
                catch (Throwable var24_34) {
                    var25_27 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {
                            problem = new ConfigurationProblem(null, -1, -1, -1, -1, ioe.getMessage());
                            this.problems.add(problem);
                        }
                    }
                    throw var24_34;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        problem = new ConfigurationProblem(null, -1, -1, -1, -1, ioe.getMessage());
                        this.problems.add(problem);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block18;
                    catch (IOException ioe) {
                        problem = new ConfigurationProblem(null, -1, -1, -1, -1, ioe.getMessage());
                        this.problems.add(problem);
                        var25_26 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ioe) {
                                problem = new ConfigurationProblem(null, -1, -1, -1, -1, ioe.getMessage());
                                this.problems.add(problem);
                            }
                        }
                        break block18;
                    }
                }
            }
            result = 1;
        }
        formatter = new WorkspaceProblemFormatter(this.workspace, null);
        printer = new ProblemPrinter(formatter, System.err);
        printer.printProblems(this.problems.getFilteredProblems());
        if (this.problems.hasErrors()) {
            result = 1;
        }
        return result;
    }

    protected boolean configure(String[] args) {
        this.projectConfigurator = this.createConfigurator();
        try {
            if (args.length == 0) {
                String usage = CommandLineConfigurator.brief(this.getProgramName(), DEFAULT_VAR, LocalizationManager.get(), L10N_CONFIG_PREFIX);
                System.out.println(this.getStartMessage());
                if (usage != null) {
                    System.out.println(usage);
                }
                this.config = new OptimizerConfiguration();
                return false;
            }
            ConfigurationPathResolver resolver = new ConfigurationPathResolver(System.getProperty("user.dir"));
            this.projectConfigurator.setConfigurationPathResolver(resolver);
            this.projectConfigurator.setConfiguration(args, this.getConfigurationDefaultVariable());
            this.projectConfigurator.applyToProject(this.project);
            this.config = (OptimizerConfiguration)this.projectConfigurator.getConfiguration();
            this.configBuffer = this.projectConfigurator.getConfigurationBuffer();
            this.config.setCompilerOptimize(null, true);
            this.problems.addAll(this.projectConfigurator.getConfigurationProblems());
            if (this.configBuffer.getVar("version") != null) {
                System.out.println(VersionInfo.buildMessage());
                return false;
            }
            List<ConfigurationValue> helpVar = this.configBuffer.getVar("help");
            if (helpVar != null) {
                this.processHelp(helpVar);
                return false;
            }
            if (this.problems.hasErrors()) {
                return false;
            }
        }
        catch (Exception e) {
            ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage());
            this.problems.add(problem);
            return false;
        }
        return true;
    }

    private void processHelp(List<ConfigurationValue> helpVar) {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        for (ConfigurationValue val : helpVar) {
            Iterator<String> iterator = val.getArgs().iterator();
            while (iterator.hasNext()) {
                String element;
                String keyword = element = iterator.next();
                while (keyword.startsWith("-")) {
                    keyword = keyword.substring(1);
                }
                keywords.add(keyword);
            }
        }
        if (keywords.size() == 0) {
            keywords.add("help");
        }
        String usages = CommandLineConfigurator.usage(this.getProgramName(), DEFAULT_VAR, this.configBuffer, keywords, LocalizationManager.get(), L10N_CONFIG_PREFIX);
        System.out.println(this.getStartMessage());
        System.out.println(usages);
    }

    private String getStartMessage() {
        String message = "Apache ActionScript Compiler (optimizer)" + NEWLINE + VersionInfo.buildMessage() + NEWLINE;
        return message;
    }

    private String getInputFilePath() {
        return this.config.getInput();
    }

    private ITargetSettings getTargetSettings() {
        if (this.targetSettings == null) {
            this.targetSettings = this.projectConfigurator.getTargetSettings(this.getTargetType());
        }
        return this.targetSettings;
    }

    protected String getConfigurationDefaultVariable() {
        return DEFAULT_VAR;
    }

    protected Configurator createConfigurator() {
        return new OptimizerConfigurator(OptimizerConfiguration.class);
    }

    protected String getProgramName() {
        return "optimizer";
    }

    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWF;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OptimizerSWFTarget
    extends AppSWFTarget {
        private ISWF swf;

        @Override
        public ISWF build(Collection<ICompilerProblem> problems) {
            return this.linkSWF(this.swf);
        }

        public OptimizerSWFTarget(ISWF swf, CompilerProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) {
            super(project, targetSettings, progressMonitor);
            this.swf = swf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OptimizerConfigurator
    extends Configurator {
        private static Set<String> configVars = ImmutableSet.of((Object)"help", (Object)"version", (Object)"load-config", (Object)"input", (Object)"output", (Object)"compiler.keep-as3-metadata", (Object[])new String[]{"compiler.debug"});

        public OptimizerConfigurator(Class<? extends Configuration> configurationClass) {
            super(configurationClass);
        }

        protected IConfigurationFilter createConfigFilter() {
            return new IConfigurationFilter(){

                public boolean select(String name) {
                    return configVars.contains(name);
                }
            };
        }

        @Override
        protected ConfigurationBuffer createConfigurationBuffer(Class<? extends Configuration> configClass) {
            return new ConfigurationBuffer(configClass, Collections.<String, String>emptyMap(), this.createConfigFilter());
        }

        @Override
        protected void loadDefaults(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        }

        @Override
        protected void byPassConfigurationsRequiringFlexSDK() throws ConfigurationException {
        }
    }

    public static class OptimizerConfiguration
    extends Configuration {
        private String input;
        private String output = "output.swf";

        public String getInput() {
            return this.input;
        }

        @Config(isRequired=true)
        @Arguments(value={"filename"})
        public void setInput(ConfigurationValue val, String output) throws ConfigurationException {
            this.input = this.getOutputPath(val, output);
        }

        public String getOutput() {
            return this.output;
        }

        @Config
        @Arguments(value={"filename"})
        public void setOutput(ConfigurationValue val, String output) throws ConfigurationException {
            this.output = output;
        }
    }
}

