/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flash.swf.tags.SetBackgroundColor;
import flash.swf.types.Rect;
import flex2.compiler.CompilerException;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.PerformanceData;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.SimpleMovie;
import flex2.tools.ToolsConfiguration;
import flex2.tools.oem.ApplicationCache;
import flex2.tools.oem.Builder;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.LibraryCache;
import flex2.tools.oem.Logger;
import flex2.tools.oem.Message;
import flex2.tools.oem.PathResolver;
import flex2.tools.oem.ProgressMeter;
import flex2.tools.oem.Report;
import flex2.tools.oem.VirtualLocalFile;
import flex2.tools.oem.internal.ApplicationCompilerConfiguration;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMReport;
import flex2.tools.oem.internal.OEMUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.clients.MXMLJSC;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.problems.CompilerProblemSeverity;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.annotations.DefaultSeverity;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.types.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
implements Builder {
    private List<VirtualFile> files;
    private OEMConfiguration oemConfiguration;
    private Logger logger;
    private File output;
    private MimeMappings mimeMappings;
    private ProgressMeter meter;
    protected PathResolver resolver;
    private CompilerControl cc;
    private ApplicationCache applicationCache;
    private LibraryCache libraryCache;
    private String cacheName;
    private String configurationReport;
    private List<Message> messages;
    private boolean setOutputCalled;
    private int loaded = 0;
    private MXMLJSC mxmljsc = new MXMLJSC();
    private List<Source> sources;
    private SimpleMovie movie;
    private SourceList sourceList;

    public Application(File file) throws FileNotFoundException {
        this(file, null);
    }

    public Application(File file, LibraryCache libraryCache) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(FileUtil.getCanonicalPath(file));
        }
        this.init(new VirtualFile[]{new LocalFile(FileUtil.getCanonicalFile(file))});
        this.libraryCache = libraryCache;
    }

    public Application(VirtualLocalFile file) {
        this.init(new VirtualFile[]{file});
    }

    public Application(VirtualLocalFile[] files) {
        this.init(files);
    }

    public Application() {
        this.init(new VirtualFile[0]);
    }

    private void init(VirtualFile[] files) {
        this.files = new ArrayList<VirtualFile>(files.length);
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            this.files.add(files[i]);
        }
        this.oemConfiguration = null;
        this.logger = null;
        this.output = null;
        this.mimeMappings = new MimeMappings();
        this.meter = null;
        this.resolver = null;
        this.cc = new CompilerControl();
        this.cacheName = null;
        this.configurationReport = null;
        this.messages = new ArrayList<Message>();
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.oemConfiguration = (OEMConfiguration)configuration;
    }

    @Override
    public Configuration getDefaultConfiguration() {
        return this.getDefaultConfiguration(false);
    }

    private Configuration getDefaultConfiguration(boolean processDefaults) {
        return OEMUtil.getApplicationConfiguration(this.constructCommandLine(null), false, false, OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings, processDefaults);
    }

    @Override
    public Map<String, PerformanceData[]> getCompilerBenchmarks() {
        return null;
    }

    @Override
    public Benchmark getBenchmark() {
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.oemConfiguration;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public void setOutput(File output) {
        this.setOutputCalled = true;
        this.output = output;
    }

    @Override
    public File getOutput() {
        return this.output;
    }

    @Override
    public void setSupportedFileExtensions(String mimeType, String[] extensions) {
        this.mimeMappings.set(mimeType, extensions);
    }

    @Override
    public void setProgressMeter(ProgressMeter meter) {
        this.meter = meter;
    }

    @Override
    public void setPathResolver(PathResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long build(boolean incremental) throws IOException {
        if (this.output != null) {
            InputStream tempIn = null;
            ByteArrayOutputStream tempOut = null;
            OutputStream out = null;
            long size = 0L;
            try {
                int result = this.compile(incremental);
                long l = size;
                return l;
            }
            catch (Exception e) {
                ThreadLocalToolkit.logError(e.getLocalizedMessage());
                long l = 0L;
                return l;
            }
            finally {
                if (tempIn != null) {
                    try {
                        tempIn.close();
                    }
                    catch (Exception exception) {}
                }
                if (tempOut != null) {
                    try {
                        tempOut.close();
                    }
                    catch (Exception exception) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
                this.clean(false, false, false, true, false, true);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long build(OutputStream out, boolean incremental) throws IOException {
        try {
            int result = this.compile(incremental);
            long l = 0L;
            return l;
        }
        finally {
            this.clean(false, false, false, true, false, true);
        }
    }

    @Override
    public void stop() {
        this.cc.stop();
    }

    @Override
    public void clean() {
        this.setOutputCalled = false;
    }

    @Override
    public void load(InputStream in) throws IOException {
        ++this.loaded;
    }

    @Override
    public long save(OutputStream out) throws IOException {
        --this.loaded;
        return 1L;
    }

    @Override
    public Report getReport() {
        return new OEMReport(this.sources, this.movie, null, this.sourceList, this.configurationReport, this.messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int compile(boolean incremental) {
        try {
            this.messages.clear();
            OEMConfiguration tempOEMConfiguration = this.oemConfiguration == null ? (OEMConfiguration)this.getDefaultConfiguration(true) : OEMUtil.getApplicationConfiguration(this.constructCommandLine(this.oemConfiguration), this.oemConfiguration.keepLinkReport(), this.oemConfiguration.keepSizeReport(), OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings);
            if (tempOEMConfiguration == null) {
                this.clean(false, false, false, true, false, false);
                int n = -1;
                return n;
            }
            if (this.oemConfiguration != null && this.oemConfiguration.keepConfigurationReport()) {
                this.configurationReport = OEMUtil.formatConfigurationBuffer(tempOEMConfiguration.cfgbuf);
            }
            if (this.oemConfiguration != null) {
                this.oemConfiguration.cfgbuf = tempOEMConfiguration.cfgbuf;
            }
            this.cc.run();
            OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
            this.mxmljsc = new MXMLJSC();
            this.mxmljsc.noLink = true;
            int returnValue = this.mxmljsc.mainNoExit(this.constructCommandLine(this.oemConfiguration), null, true);
            returnValue = returnValue == 0 || returnValue == 2 ? 1 : -1;
            this.processMXMLCReport(this.mxmljsc, tempOEMConfiguration);
            this.clean(returnValue == -1, false, false, true, false, false);
            int n = returnValue;
            return n;
        }
        finally {
            OEMUtil.clean();
        }
    }

    public long link(OutputStream output) {
        return this.mxmljsc.writeSWF(output);
    }

    void processMXMLCReport(MXMLJSC mxmljsc, OEMConfiguration config) {
        ApplicationCompilerConfiguration acc = (ApplicationCompilerConfiguration)config.configuration;
        this.sources = new ArrayList<Source>();
        VirtualFile[] sourcePaths = acc.getCompilerConfiguration().getSourcePath();
        List<String> sourceFiles = mxmljsc.getSourceList();
        String mainFile = mxmljsc.getMainSource();
        VirtualFile mainVirtualFile = null;
        for (String sourceFile : sourceFiles) {
            for (VirtualFile sourcePath : sourcePaths) {
                Annotation[] pathName = sourcePath.getName();
                if (sourceFile.indexOf((String)pathName) != 0) continue;
                String relPath = sourceFile.substring(pathName.length());
                int lastSep = relPath.lastIndexOf(File.separator);
                String shortName = relPath.substring(lastSep + 1);
                relPath = relPath.substring(0, lastSep);
                boolean isRoot = sourceFile.equals(mainFile);
                Source source = new Source(sourcePath, relPath, shortName, null, false, isRoot);
                this.sources.add(source);
                if (!pathName.equals(mainFile)) continue;
                mainVirtualFile = sourcePath;
            }
        }
        try {
            this.sourceList = new SourceList(new ArrayList<VirtualFile>(), sourcePaths, mainVirtualFile, new String[0]);
        }
        catch (CompilerException e2) {
            e2.printStackTrace();
        }
        ProblemQuery pq = mxmljsc.getProblemQuery();
        List probs = pq.getProblems();
        block17: for (ICompilerProblem prob : probs) {
            Annotation[] annotations;
            Class<?> aClass = prob.getClass();
            for (Annotation annotation : annotations = aClass.getAnnotations()) {
                String level;
                if (!(annotation instanceof DefaultSeverity)) continue;
                DefaultSeverity myAnnotation = (DefaultSeverity)annotation;
                CompilerProblemSeverity cps = myAnnotation.value();
                if (cps.equals((Object)CompilerProblemSeverity.ERROR)) {
                    level = "error";
                } else {
                    if (!cps.equals((Object)CompilerProblemSeverity.WARNING)) continue block17;
                    level = "warning";
                }
                CompilerMessage msg = new CompilerMessage(level, prob.getSourcePath(), prob.getLine() + 1, prob.getColumn());
                try {
                    String errText = ProblemFormatter.DEFAULT_FORMATTER.format(prob);
                    msg.setMessage(errText);
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                this.messages.add(msg);
                try {
                    this.logger.log(msg, aClass.getField("errorCode").getInt(null), prob.getSourcePath());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    try {
                        this.logger.log(msg, aClass.getField("warningCode").getInt(null), prob.getSourcePath());
                    }
                    catch (IllegalArgumentException e1) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e1) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e1) {
                        e.printStackTrace();
                    }
                    catch (NoSuchFieldException e1) {
                        e.printStackTrace();
                    }
                }
            }
        }
        ISWF swf = mxmljsc.getSWFTarget();
        this.movie = new SimpleMovie(null);
        org.apache.royale.swf.types.Rect r = swf.getFrameSize();
        Rect fr = new Rect();
        fr.xMin = r.xMin();
        fr.yMin = r.yMin();
        fr.xMax = r.xMax();
        fr.yMax = r.yMax();
        this.movie.size = fr;
        RGB bg = swf.getBackgroundColor();
        int red = bg.getRed();
        int green = bg.getGreen();
        short blue = bg.getBlue();
        this.movie.bgcolor = new SetBackgroundColor((red <<= 16) + (green <<= 8) + blue);
        this.movie.topLevelClass = swf.getTopLevelClass();
    }

    private void clean(boolean cleanData, boolean cleanCache, boolean cleanOutput, boolean cleanConfig, boolean cleanMessages, boolean cleanThreadLocals) {
        if (cleanThreadLocals) {
            OEMUtil.clean();
        }
        if (this.oemConfiguration != null && cleanConfig) {
            this.oemConfiguration.reset();
        }
        if (cleanData) {
            this.configurationReport = null;
        }
        if (cleanCache && this.cacheName != null) {
            File dead = FileUtil.openFile(this.cacheName);
            if (dead != null && dead.exists()) {
                dead.delete();
            }
            this.cacheName = null;
        }
        if (cleanOutput && this.output != null && this.output.exists()) {
            this.output.delete();
        }
        if (cleanMessages) {
            this.messages.clear();
        }
    }

    private String[] constructCommandLine(OEMConfiguration localOEMConfiguration) {
        String[] options = localOEMConfiguration != null ? localOEMConfiguration.getCompilerOptions() : new String[]{};
        String[] args = new String[options.length + this.files.size() + 1];
        System.arraycopy(options, 0, args, 0, options.length);
        args[options.length] = "--file-specs";
        int size = this.files.size();
        for (int i = 0; i < size; ++i) {
            args[options.length + 1 + i] = this.files.get(i).getName();
        }
        return args;
    }

    private String[] constructCommandLine2(ToolsConfiguration localToolsConfiguration) {
        String[] options = localToolsConfiguration != null ? this.processToolsConfig(localToolsConfiguration) : new String[]{};
        String[] args = new String[options.length + this.files.size() + 1];
        System.arraycopy(options, 0, args, 0, options.length);
        args[options.length] = "--file-specs";
        int size = this.files.size();
        for (int i = 0; i < size; ++i) {
            args[options.length + 1 + i] = this.files.get(i).getName();
        }
        return args;
    }

    private String[] processToolsConfig(ToolsConfiguration tc) {
        String[] results = new String[]{"-debug=" + (tc.debug() ? "true" : "false")};
        return results;
    }

    public ApplicationCache getApplicationCache() {
        return this.applicationCache;
    }

    @Override
    public void setApplicationCache(ApplicationCache applicationCache) {
        this.applicationCache = applicationCache;
    }

    public LibraryCache getSwcCache() {
        return this.libraryCache;
    }

    @Override
    public void setSwcCache(LibraryCache libraryCache) {
        this.libraryCache = libraryCache;
    }

    static {
        int len;
        File[] list = null;
        try {
            File tempDir = File.createTempFile("Flex2_", "").getParentFile();
            list = tempDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("Flex2_");
                }
            });
        }
        catch (Exception tempDir) {
            // empty catch block
        }
        int n = len = list == null ? 0 : list.length;
        for (int i = 0; i < len; ++i) {
            try {
                list[i].delete();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        URL url = Application.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            File f = new File(new URI(url.toExternalForm()));
            if (f.getAbsolutePath().endsWith("flex-compiler-oem.jar")) {
                String applicationHome = f.getParentFile().getParent();
                System.setProperty("application.home", applicationHome);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

