/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.SourcePathBase;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class SourcePath
extends SourcePathBase
implements SinglePathResolver {
    protected final List<File> directories = new LinkedList<File>();

    public SourcePath(VirtualFile[] classPath, VirtualFile appPath, String[] mimeTypes, boolean allowSourcePathOverlap) {
        this(mimeTypes, allowSourcePathOverlap);
        SourcePath.addApplicationParentToSourcePath(appPath, classPath, this.directories);
        SourcePath.addPathElements(classPath, this.directories, allowSourcePathOverlap, this.warnings);
    }

    public SourcePath(String[] mimeTypes, boolean allowSourcePathOverlap) {
        super(mimeTypes, allowSourcePathOverlap);
    }

    public void addPathElements(VirtualFile[] classPath) {
        SourcePath.addPathElements(classPath, this.directories, this.allowSourcePathOverlap, this.warnings);
    }

    public VirtualFile resolve(String path) {
        if (path.charAt(0) == '/') {
            String relativePath = path.substring(1);
            for (File directory : this.directories) {
                File file = FileUtil.openFile(directory, relativePath);
                if (file == null || !file.exists()) continue;
                return new LocalFile(file);
            }
        }
        return null;
    }
}

