/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.problems;

import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.RecognitionException;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.common.SourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CSSParserProblem
extends CompilerProblem {
    public static String DESCRIPTION = "${reason}";
    public static final int errorCode = 1324;
    public final String reason;
    public final Class<? extends BaseRecognizer> type;

    private CSSParserProblem(ISourceLocation site, String reason, Class<? extends BaseRecognizer> type) {
        super(site);
        this.reason = reason;
        this.type = type;
    }

    public static CSSParserProblem create(BaseRecognizer baseRecognizer, String[] tokenNames, RecognitionException e) {
        String messageHeader = baseRecognizer.getErrorHeader(e);
        String messageBody = baseRecognizer.getErrorMessage(e, tokenNames);
        String reason = String.format("%s %s", messageHeader, CSSParserProblem.makeNice(messageBody));
        SourceLocation location = new SourceLocation(e.input.getSourceName(), -1, -1, e.line, e.charPositionInLine);
        return new CSSParserProblem(location, reason, baseRecognizer.getClass());
    }

    private static String makeNice(String s) {
        int c;
        if (s.contains("mismatched tree node: <mismatched token") && (c = s.indexOf("expecting")) != -1) {
            String expecting = s.substring(c);
            expecting = expecting.replace("I_DECL", "CSS property name");
            c = s.indexOf("resync");
            if (c != -1) {
                s = s.substring(0, c);
            }
            String token = s.replaceFirst("mismatched tree node: <mismatched token: \\[\\@([^=]+)=([^,]+),<([^>]+)>.*$", "unexpected token $2");
            s = token + " " + expecting;
        }
        return s;
    }
}

