/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.workspaces;

import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.royale.compiler.asdoc.IASDocDelegate;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.filespecs.FileSpecification;
import org.apache.royale.compiler.filespecs.IBinaryFileSpecification;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.caches.PackageNamespaceDefinitionCache;
import org.apache.royale.compiler.internal.definitions.references.ReferenceCache;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.mxml.MXMLDataManager;
import org.apache.royale.compiler.internal.parsing.as.NilASDocDelegate;
import org.apache.royale.compiler.internal.projects.ASProject;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DependencyGraph;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.units.CompilationUnitBase;
import org.apache.royale.compiler.internal.units.StringToCompilationUnitMap;
import org.apache.royale.compiler.mxml.IMXMLDataManager;
import org.apache.royale.compiler.projects.IASProject;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;
import org.apache.royale.compiler.workspaces.IInvalidationListener;
import org.apache.royale.compiler.workspaces.IWorkspace;
import org.apache.royale.compiler.workspaces.IWorkspaceProfilingDelegate;
import org.apache.royale.swc.ISWCManager;
import org.apache.royale.swc.SWCManager;
import org.apache.royale.utils.FilenameNormalization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Workspace
implements IWorkspace {
    private static boolean assertionsEnabled = false;
    private ExecutorService executorService;
    protected final Map<CompilerProject, Object> projects;
    private IWorkspaceProfilingDelegate profilingDelegate;
    private final Set<IInvalidationListener> invalidationListeners;
    private final SWCManager swcManager;
    private final MXMLDataManager mxmlDataManager;
    private final PackageNamespaceDefinitionCache packageNamespaceDefinitionCache;
    private final Map<String, IFileSpecification> pathToFileSpecMap;
    private final StringToCompilationUnitMap pathToCompilationUnitMapping;
    private final StringToCompilationUnitMap includeFilesToIncludingCompilationUnitMapping;
    private final Map<EmbedData, EmbedData> embedDataCache;
    private final FinalizableReferenceQueue invisibleCompilationUnitReferenceQueue;
    public final ReadWriteLock embedLock;
    private final BuildSynchronizationState buildSync;
    private IASDocDelegate asDocDelegate;
    private ReferenceCache refCache = new ReferenceCache();

    public Workspace() {
        this(new ThreadPoolExecutor(0, Workspace.getNumberOfThreadToUse(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy()));
    }

    public Workspace(ExecutorService es) {
        this.executorService = es;
        this.profilingDelegate = null;
        this.invalidationListeners = new LinkedHashSet<IInvalidationListener>();
        this.swcManager = new SWCManager(this);
        this.mxmlDataManager = new MXMLDataManager();
        this.projects = new MapMaker().weakKeys().makeMap();
        this.pathToFileSpecMap = new HashMap<String, IFileSpecification>();
        this.pathToCompilationUnitMapping = new StringToCompilationUnitMap();
        this.includeFilesToIncludingCompilationUnitMapping = new StringToCompilationUnitMap();
        this.packageNamespaceDefinitionCache = new PackageNamespaceDefinitionCache();
        this.embedDataCache = new WeakHashMap<EmbedData, EmbedData>();
        this.embedLock = new ReentrantReadWriteLock();
        this.invisibleCompilationUnitReferenceQueue = new FinalizableReferenceQueue();
        this.asDocDelegate = NilASDocDelegate.get();
        this.buildSync = new BuildSynchronizationState();
    }

    private static int getNumberOfThreadToUse() {
        return 16;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    private CompilerProject[] getProjects() {
        return this.projects.keySet().toArray(new CompilerProject[0]);
    }

    @Override
    public void startIdleState() {
        this.buildSync.startIdleState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endIdleState(Map<ICompilerProject, Set<ICompilationUnit>> cusToUpdate) {
        this.buildSync.startAllowingFileScopeRequests();
        try {
            for (Map.Entry<ICompilerProject, Set<ICompilationUnit>> e : cusToUpdate.entrySet()) {
                ((CompilerProject)e.getKey()).updatePublicAndInternalDefinitions((Collection<ICompilationUnit>)e.getValue());
            }
        }
        catch (InterruptedException e1) {
            assert (false) : "unlockAndUpdateCompilationUnits() should not be interrupted";
        }
        finally {
            this.buildSync.endAllowingFileScopeRequests();
            this.buildSync.endIdleState();
        }
    }

    @Override
    public void startBuilding() {
        this.buildSync.startRequest(false);
    }

    @Override
    public void doneBuilding() {
        this.buildSync.endRequest();
    }

    public void startRequest(boolean requestNeededForFileScope) {
        this.buildSync.startRequest(requestNeededForFileScope);
    }

    public void endRequest() {
        this.buildSync.endRequest();
    }

    public boolean isBuilding() {
        return this.buildSync.isBuilding();
    }

    @Override
    public void setProfilingDelegate(IWorkspaceProfilingDelegate profilingDelegate) {
        this.profilingDelegate = profilingDelegate;
    }

    @Override
    public IWorkspaceProfilingDelegate getProfilingDelegate() {
        return this.profilingDelegate;
    }

    @Override
    public void addInvalidationListener(IInvalidationListener invalidationListner) {
        this.invalidationListeners.add(invalidationListner);
    }

    @Override
    public void removeInvalidationListener(IInvalidationListener invalidationListner) {
        this.invalidationListeners.remove(invalidationListner);
    }

    @Override
    public ISWCManager getSWCManager() {
        return this.swcManager;
    }

    public PackageNamespaceDefinitionCache getPackageNamespaceDefinitionCache() {
        return this.packageNamespaceDefinitionCache;
    }

    public void close() {
        this.executorService.shutdown();
        this.executorService = null;
    }

    private final Collection<ICompilationUnit> collectAssociatedCompilationUnits(IFileSpecification file) {
        String filename = file.getPath();
        Collection<WeakReference<ICompilationUnit>> relatedCompilationUnits = this.pathToCompilationUnitMapping.getVisibleAndInvisible(filename);
        assert (relatedCompilationUnits != null) : "relatedCompilationUnits should never be null";
        Collection<WeakReference<ICompilationUnit>> includingCompilationUnits = this.includeFilesToIncludingCompilationUnitMapping.get(filename);
        HashSet<WeakReference<ICompilationUnit>> allRelatedCompilationUnits = new HashSet<WeakReference<ICompilationUnit>>();
        allRelatedCompilationUnits.addAll(relatedCompilationUnits);
        allRelatedCompilationUnits.addAll(includingCompilationUnits);
        HashSet<ICompilationUnit> associatedCompilationUnits = new HashSet<ICompilationUnit>();
        for (WeakReference weakReference : allRelatedCompilationUnits) {
            ICompilationUnit relatedCU = (ICompilationUnit)weakReference.get();
            if (relatedCU == null) continue;
            associatedCompilationUnits.add(relatedCU);
        }
        Set<ICompilationUnit> associatedCompilationUnitsAccountingForConflictingDefinitions = ASProjectScope.getCompilationUnitsWithConflictingDefinitions(this, associatedCompilationUnits);
        return associatedCompilationUnitsAccountingForConflictingDefinitions;
    }

    private final void invalidate(IFileSpecification fileSpec, Collection<ICompilationUnit> compilationUnits, Map<ICompilerProject, Set<ICompilationUnit>> cusToUpdate) {
        this.mxmlDataManager.invalidate(fileSpec);
        this.getSWCManager().remove(new File(fileSpec.getPath()));
        if (compilationUnits.size() == 0) {
            return;
        }
        HashSet<ICompilationUnit> unitsToInvalidate = new HashSet<ICompilationUnit>();
        unitsToInvalidate.addAll(compilationUnits);
        Sets.SetView unitsToClean = Sets.union(DependencyGraph.computeInvalidationSet(unitsToInvalidate), this.getCompilationUnitsDependingOnMissingDefinitions(unitsToInvalidate));
        this.notifyInvalidationListener((Collection<ICompilationUnit>)unitsToClean);
        HashMap<ICompilerProject, Set<File>> invalidatedSWCFiles = new HashMap<ICompilerProject, Set<File>>();
        for (ICompilationUnit iCompilationUnit : unitsToClean) {
            boolean clearCUFileScope = unitsToInvalidate.contains(iCompilationUnit);
            iCompilationUnit.clean(invalidatedSWCFiles, cusToUpdate, clearCUFileScope);
        }
        for (Map.Entry entry : invalidatedSWCFiles.entrySet()) {
            if (!(entry.getKey() instanceof IASProject)) continue;
            ((IASProject)entry.getKey()).invalidateLibraries((Collection)entry.getValue());
        }
    }

    private void notifyInvalidationListener(Collection<ICompilationUnit> unitsToClean) {
        if (this.invalidationListeners.isEmpty()) {
            return;
        }
        HashMap<ICompilerProject, Collection<IInvalidationListener.InvalidatedDefinition>> invalidationMap = new HashMap<ICompilerProject, Collection<IInvalidationListener.InvalidatedDefinition>>();
        for (ICompilationUnit compilationUnit : unitsToClean) {
            Collection<IDefinition> definitions;
            block8: {
                definitions = compilationUnit.getDefinitionPromises();
                if (definitions.size() == 0) {
                    try {
                        IFileScopeRequestResult fsr = compilationUnit.getFileScopeRequest().get();
                        definitions = fsr.getExternallyVisibleDefinitions();
                    }
                    catch (InterruptedException e1) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError((Object)"Since this is a single threaded method, we should never be interrupted");
                    }
                }
            }
            if (definitions.size() <= 0) continue;
            LinkedList<IInvalidationListener.InvalidatedDefinition> invalidatedDefinitions = (LinkedList<IInvalidationListener.InvalidatedDefinition>)invalidationMap.get(compilationUnit.getProject());
            if (invalidatedDefinitions == null) {
                invalidatedDefinitions = new LinkedList<IInvalidationListener.InvalidatedDefinition>();
                invalidationMap.put(compilationUnit.getProject(), invalidatedDefinitions);
            }
            String filename = compilationUnit.getAbsoluteFilename();
            for (IDefinition definition : definitions) {
                String qName = definition.getQualifiedName();
                IInvalidationListener.InvalidatedDefinition invalidatedDefinition = new IInvalidationListener.InvalidatedDefinition(qName, filename);
                invalidatedDefinitions.add(invalidatedDefinition);
            }
        }
        for (IInvalidationListener listener : this.invalidationListeners) {
            listener.definitionsChanged(invalidationMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swcChanged(Collection<ICompilationUnit> unitsRemoved, Collection<ICompilationUnit> unitsAdded, Runnable runWhileIdle) {
        HashMap<ICompilerProject, Set<ICompilationUnit>> cusToUpdate = new HashMap<ICompilerProject, Set<ICompilationUnit>>();
        ImmutableSet unitsRemoveSet = ImmutableSet.copyOf(unitsRemoved);
        this.startIdleState();
        try {
            Set<ICompilationUnit> unitsDependingOnMissingDefinitions = this.getCompilationUnitsDependingOnMissingDefinitions(unitsAdded);
            Set<ICompilationUnit> unitsToInvalidate = DependencyGraph.computeInvalidationSet(Iterables.concat(unitsRemoved, unitsDependingOnMissingDefinitions));
            this.notifyInvalidationListener(unitsToInvalidate);
            HashMap<ICompilerProject, Set<File>> invalidatedSWCFiles = new HashMap<ICompilerProject, Set<File>>();
            for (ICompilationUnit compilationUnit : unitsToInvalidate) {
                compilationUnit.clean(invalidatedSWCFiles, cusToUpdate, unitsRemoveSet.contains(compilationUnit));
            }
            runWhileIdle.run();
        }
        finally {
            this.endIdleState(cusToUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(IFileSpecification changedFile) {
        assert (changedFile.getPath().equals(FilenameNormalization.normalize(changedFile.getPath()))) : "Path not normalized";
        HashMap<ICompilerProject, Set<ICompilationUnit>> cusToUpdate = new HashMap<ICompilerProject, Set<ICompilationUnit>>();
        this.startIdleState();
        try {
            Collection<ICompilationUnit> relatedCompilationUnits = this.collectAssociatedCompilationUnits(changedFile);
            HashSet<ICompilationUnit> compilationUnitsToInvalidate = new HashSet<ICompilationUnit>();
            compilationUnitsToInvalidate.addAll(relatedCompilationUnits);
            this.invalidate(changedFile, relatedCompilationUnits, cusToUpdate);
            this.pathToFileSpecMap.put(changedFile.getPath(), changedFile);
        }
        finally {
            this.endIdleState(cusToUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileRemoved(IFileSpecification removedFile) {
        File f22;
        assert (removedFile.getPath().equals(FilenameNormalization.normalize(removedFile.getPath()))) : "Path not normalized";
        String path = removedFile.getPath();
        HashSet<ASProject> affectedProjects = new HashSet<ASProject>();
        HashMap<ICompilerProject, Set<ICompilationUnit>> cusToUpdate = new HashMap<ICompilerProject, Set<ICompilationUnit>>();
        Collection<Object> relatedCompilationUnits = Collections.emptyList();
        this.startIdleState();
        try {
            relatedCompilationUnits = this.collectAssociatedCompilationUnits(removedFile);
            for (ICompilationUnit iCompilationUnit : relatedCompilationUnits) {
                if (iCompilationUnit == null) continue;
                ICompilerProject containingProject = iCompilationUnit.getProject();
                assert (containingProject instanceof ASProject);
                affectedProjects.add((ASProject)containingProject);
            }
            this.invalidate(removedFile, relatedCompilationUnits, cusToUpdate);
            Object var10_9 = null;
            f22 = new File(path);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            File f22 = new File(path);
            for (ASProject aSProject : affectedProjects) {
                aSProject.removeSourceFile(f22);
            }
            for (ICompilationUnit iCompilationUnit : relatedCompilationUnits) {
                if (iCompilationUnit.getCompilationUnitType() == ICompilationUnit.UnitType.SWC_UNIT) continue;
                this.pathToCompilationUnitMapping.remove(path, iCompilationUnit);
                this.includeFilesToIncludingCompilationUnitMapping.remove(path, iCompilationUnit);
            }
            this.pathToFileSpecMap.remove(path);
            this.endIdleState(cusToUpdate);
            throw throwable;
        }
        for (ASProject aSProject : affectedProjects) {
            aSProject.removeSourceFile(f22);
        }
        for (ICompilationUnit iCompilationUnit : relatedCompilationUnits) {
            if (iCompilationUnit.getCompilationUnitType() == ICompilationUnit.UnitType.SWC_UNIT) continue;
            this.pathToCompilationUnitMapping.remove(path, iCompilationUnit);
            this.includeFilesToIncludingCompilationUnitMapping.remove(path, iCompilationUnit);
        }
        {
        }
        this.pathToFileSpecMap.remove(path);
        this.endIdleState(cusToUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileAdded(IFileSpecification addedFile) {
        assert (addedFile.getPath().equals(FilenameNormalization.normalize(addedFile.getPath()))) : "Path not normalized";
        HashMap<ICompilerProject, Set<ICompilationUnit>> cusToUpdate = new HashMap<ICompilerProject, Set<ICompilationUnit>>();
        this.startIdleState();
        try {
            String path = addedFile.getPath();
            this.pathToFileSpecMap.put(path, addedFile);
            this.getSWCManager().remove(new File(path));
            File f = new File(path);
            CompilerProject[] projects = this.getProjects();
            boolean compilationUnitAdded = false;
            for (CompilerProject project : projects) {
                boolean bl = compilationUnitAdded = project.handleAddedFile(f) || compilationUnitAdded;
                if (!(project instanceof ASProject)) continue;
                compilationUnitAdded = ((ASProject)project).invalidateLibraries(Collections.singleton(f)) || compilationUnitAdded;
            }
            HashSet<ICompilationUnit> compilationUnitsToInvalidate = new HashSet<ICompilationUnit>();
            if (compilationUnitAdded) {
                Collection<ICompilationUnit> relatedCompilationUnits = this.collectAssociatedCompilationUnits(addedFile);
                compilationUnitsToInvalidate.addAll(relatedCompilationUnits);
                compilationUnitsToInvalidate.addAll(this.getCompilationUnitsDependingOnMissingDefinitions(relatedCompilationUnits));
            }
            for (CompilerProject project : projects) {
                compilationUnitsToInvalidate.addAll(project.getDependenciesOnUnfoundReferencedSourceFile(addedFile.getPath()));
            }
            this.invalidate(addedFile, compilationUnitsToInvalidate, cusToUpdate);
            Object var13_15 = null;
            this.endIdleState(cusToUpdate);
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.endIdleState(cusToUpdate);
            throw throwable;
        }
    }

    private Set<ICompilationUnit> getCompilationUnitsDependingOnMissingDefinitions(Collection<ICompilationUnit> addedUnits) {
        HashSet<ICompilationUnit> compilationUnitsToInvalidate = new HashSet<ICompilationUnit>();
        for (ICompilationUnit addedCompilationUnit : addedUnits) {
            try {
                CompilerProject project = (CompilerProject)addedCompilationUnit.getProject();
                List<String> newIdentifierNames = addedCompilationUnit.getShortNames();
                for (String newIdentifierName : newIdentifierNames) {
                    compilationUnitsToInvalidate.addAll(project.getDependenciesOnUnfoundDefinition(newIdentifierName));
                    compilationUnitsToInvalidate.addAll(project.getDependenciesOnDefinition(newIdentifierName));
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return compilationUnitsToInvalidate;
    }

    private boolean isKnownFile(IFileSpecification fileSpecification) {
        if (!assertionsEnabled) {
            throw new RuntimeException("isKnownFile() should only ever be called from an assert");
        }
        assert (fileSpecification.getPath().equals(FilenameNormalization.normalize(fileSpecification.getPath()))) : "Path not normalized";
        Collection<WeakReference<ICompilationUnit>> relatedCompilationUnits = this.pathToCompilationUnitMapping.get(fileSpecification.getPath());
        return relatedCompilationUnits != null && relatedCompilationUnits.size() > 0;
    }

    public IFileSpecification getFileSpecificationForCompilationUnit(ICompilationUnit compilationUnit) {
        String path = compilationUnit.getAbsoluteFilename();
        assert (path.equals(FilenameNormalization.normalize(path))) : "Path not normalized";
        assert (this.pathToCompilationUnitMapping.get(path) != null);
        return this.getFileSpecification(path);
    }

    public void addCompilationUnit(ICompilationUnit compilationUnit) {
        String path = compilationUnit.getAbsoluteFilename();
        assert (path.equals(FilenameNormalization.normalize(path))) : "Path not normalized";
        this.pathToCompilationUnitMapping.add(path, compilationUnit);
    }

    public void addIncludedFilesToCompilationUnit(ICompilationUnit includingCompilationUnit, Collection<String> includedFiles) {
        this.includeFilesToIncludingCompilationUnitMapping.add(includedFiles.toArray(new String[includedFiles.size()]), includingCompilationUnit);
    }

    public void removeIncludedFilesToCompilationUnit(ICompilationUnit includingCompilationUnit, Collection<String> includedFiles) {
        for (String includedFile : includedFiles) {
            this.includeFilesToIncludingCompilationUnitMapping.remove(includedFile, includingCompilationUnit);
        }
    }

    public void removeCompilationUnit(ICompilationUnit compilationUnit) {
        String path = compilationUnit.getAbsoluteFilename();
        assert (path.equals(FilenameNormalization.normalize(path))) : "Path not normalized";
        this.pathToCompilationUnitMapping.remove(path, compilationUnit);
        ((CompilationUnitBase)compilationUnit).clearIncludedFilesFromWorkspace();
        if (this.pathToCompilationUnitMapping.get(path).isEmpty() && this.includeFilesToIncludingCompilationUnitMapping.get(path).isEmpty()) {
            this.pathToFileSpecMap.remove(path);
        }
    }

    public Collection<WeakReference<ICompilationUnit>> getCompilationUnits(String path) {
        assert (path.equals(FilenameNormalization.normalize(path))) : "Path not normalized";
        return this.pathToCompilationUnitMapping.get(path);
    }

    public Collection<WeakReference<ICompilationUnit>> getInvisibleCompilationUnits(String path) {
        assert (path.equals(FilenameNormalization.normalize(path))) : "Path not normalized";
        return this.pathToCompilationUnitMapping.getInvisible(path);
    }

    private static Collection<ICompilationUnit> getCompilationUnits(StringToCompilationUnitMap compilationUnitMap, String sortKey, ICompilerProject project) {
        Collection<WeakReference<ICompilationUnit>> compilationUnitRefs = compilationUnitMap.get(sortKey, project);
        ArrayList<ICompilationUnit> compilationUnits = new ArrayList<ICompilationUnit>(compilationUnitRefs.size());
        for (WeakReference<ICompilationUnit> cuRef : compilationUnitRefs) {
            ICompilationUnit cu = (ICompilationUnit)cuRef.get();
            assert (cu != null) : "ICompilerProject's dependency graph should be pinning all the compilation units in the collection.";
            compilationUnits.add(cu);
        }
        return compilationUnits;
    }

    private static Collection<ICompilationUnit> getInvisibleCompilationUnits(StringToCompilationUnitMap compilationUnitMap, String sortKey, ICompilerProject project) {
        Collection<WeakReference<ICompilationUnit>> compilationUnitRefs = compilationUnitMap.getInvisible(sortKey, project);
        ArrayList<ICompilationUnit> compilationUnits = new ArrayList<ICompilationUnit>(compilationUnitRefs.size());
        for (WeakReference<ICompilationUnit> cuRef : compilationUnitRefs) {
            ICompilationUnit cu = (ICompilationUnit)cuRef.get();
            if (cu == null) continue;
            assert (cu.isInvisible()) : "StringToCompilationUnitMap.getInvisible returned a visible compilation unit.";
            compilationUnits.add(cu);
        }
        return compilationUnits;
    }

    @Override
    public Collection<ICompilationUnit> getCompilationUnits(String path, ICompilerProject project) {
        assert (path.equals(FilenameNormalization.normalize(path))) : "Path not normalized";
        return Workspace.getCompilationUnits(this.pathToCompilationUnitMapping, path, project);
    }

    private static Iterable<ICompilationUnit> getInvisibleAndVisibleCompilationUnits(final StringToCompilationUnitMap compilationUnitMap, final String sortKey, ICompilerProject project) {
        Set<ICompilerProject> projectIterable = Collections.singleton(project);
        Iterable invisibleIterableIterable = Iterables.transform(projectIterable, (Function)new Function<ICompilerProject, Iterable<ICompilationUnit>>(){

            public Iterable<ICompilationUnit> apply(ICompilerProject input) {
                return Workspace.getInvisibleCompilationUnits(compilationUnitMap, sortKey, input);
            }
        });
        Iterable visibleIterableIterable = Iterables.transform(projectIterable, (Function)new Function<ICompilerProject, Iterable<ICompilationUnit>>(){

            public Iterable<ICompilationUnit> apply(ICompilerProject input) {
                return Workspace.getCompilationUnits(compilationUnitMap, sortKey, input);
            }
        });
        return Iterables.concat((Iterable)Iterables.concat((Iterable)invisibleIterableIterable, (Iterable)visibleIterableIterable));
    }

    @Override
    public Iterable<ICompilationUnit> getInvisibleAndVisibleCompilationUnits(String path, ICompilerProject project) {
        assert (path.equals(FilenameNormalization.normalize(path))) : "Path not normalized";
        return Workspace.getInvisibleAndVisibleCompilationUnits(this.pathToCompilationUnitMapping, path, project);
    }

    public Collection<ICompilationUnit> getIncludingCompilationUnits(String path, ICompilerProject project) {
        assert (path.equals(FilenameNormalization.normalize(path))) : "Path not normalized";
        return Workspace.getCompilationUnits(this.includeFilesToIncludingCompilationUnitMapping, path, project);
    }

    public EmbedData getCanonicalEmbedData(EmbedData data) {
        EmbedData cachedData = this.embedDataCache.get(data);
        if (cachedData != null) {
            return cachedData;
        }
        this.embedDataCache.put(data, data);
        return data;
    }

    public Map<EmbedData, EmbedData> getEmbedDatas() {
        return this.embedDataCache;
    }

    public FinalizableReferenceQueue getInvisibleCompilationUnitReferenceQueue() {
        return this.invisibleCompilationUnitReferenceQueue;
    }

    @Override
    public IMXMLDataManager getMXMLDataManager() {
        return this.mxmlDataManager;
    }

    @Override
    public synchronized IFileSpecification getFileSpecification(String path) {
        assert (path.equals(FilenameNormalization.normalize(path))) : "Path not normalized";
        IFileSpecification fileSpec = this.pathToFileSpecMap.get(path);
        if (fileSpec == null) {
            fileSpec = new FileSpecification(path);
            this.pathToFileSpecMap.put(path, fileSpec);
        }
        return fileSpec;
    }

    @Override
    public IWorkspace getWorkspace() {
        return this;
    }

    public synchronized IBinaryFileSpecification getLatestBinaryFileSpecification(String path) {
        IFileSpecification fileSpec = this.getFileSpecification(path);
        IBinaryFileSpecification binaryFileSpec = null;
        if (fileSpec instanceof IBinaryFileSpecification) {
            binaryFileSpec = (IBinaryFileSpecification)fileSpec;
        } else assert (false) : "requesting binary fileSpec but existing fileSpec not of binary type";
        return binaryFileSpec;
    }

    public ReferenceCache getReferenceCache() {
        return this.refCache;
    }

    public void deleteProject(ICompilerProject compilerProject) {
        this.projects.remove(compilerProject);
    }

    @Override
    public IASDocDelegate getASDocDelegate() {
        return this.asDocDelegate;
    }

    @Override
    public void setASDocDelegate(IASDocDelegate asDocDelegate) {
        assert (asDocDelegate != null) : "ASDoc delegate can not be null, use default implementation instead!";
        this.asDocDelegate = asDocDelegate;
    }

    public void addProject(CompilerProject project) {
        this.projects.put(project, Object.class);
    }

    static {
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }

    private static final class BuildSynchronizationState {
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private int idleStateCount;
        private int activitiyCount;
        private boolean allowFileScopeRequests;
        private final LinkedList<Thread> threadsRequestingIdle = new LinkedList();

        BuildSynchronizationState() {
        }

        void startRequest(boolean isFileScopeRequest) {
            this.lock.lock();
            try {
                while (!this.canStartRequest(isFileScopeRequest)) {
                    this.condition.awaitUninterruptibly();
                }
                ++this.activitiyCount;
            }
            finally {
                this.lock.unlock();
            }
        }

        void endRequest() {
            this.lock.lock();
            try {
                assert (this.activitiyCount > 0);
                --this.activitiyCount;
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        void startIdleState() {
            this.lock.lock();
            try {
                Thread currentThread = Thread.currentThread();
                Thread currentIdleThread = this.threadsRequestingIdle.peekFirst();
                if (currentIdleThread == currentThread) {
                    assert (this.idleStateCount > 0);
                    ++this.idleStateCount;
                    assert (this.idleStateCount > 0);
                    return;
                }
                this.threadsRequestingIdle.add(currentThread);
                while (this.activitiyCount > 0 || this.threadsRequestingIdle.getFirst() != currentThread) {
                    this.condition.awaitUninterruptibly();
                }
                assert (this.idleStateCount == 0);
                assert (this.activitiyCount == 0);
                assert (this.threadsRequestingIdle.getFirst() == currentThread);
                this.idleStateCount = 1;
            }
            finally {
                this.lock.unlock();
            }
        }

        void startAllowingFileScopeRequests() {
            this.lock.lock();
            try {
                Thread currentThread = Thread.currentThread();
                Thread currentIdleThread = this.threadsRequestingIdle.peekFirst();
                assert (currentThread == currentIdleThread);
                assert (!this.allowFileScopeRequests);
                this.allowFileScopeRequests = true;
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        void endAllowingFileScopeRequests() {
            this.lock.lock();
            try {
                Thread currentThread = Thread.currentThread();
                Thread currentIdleThread = this.threadsRequestingIdle.peekFirst();
                assert (currentThread == currentIdleThread);
                assert (this.allowFileScopeRequests);
                while (this.activitiyCount > 0) {
                    this.condition.awaitUninterruptibly();
                }
                this.allowFileScopeRequests = false;
            }
            finally {
                this.lock.unlock();
            }
        }

        void endIdleState() {
            this.lock.lock();
            try {
                Thread currentThread = Thread.currentThread();
                assert (currentThread == this.threadsRequestingIdle.getFirst());
                assert (!this.allowFileScopeRequests);
                assert (this.idleStateCount > 0);
                assert (this.activitiyCount == 0);
                --this.idleStateCount;
                assert (this.idleStateCount >= 0);
                if (this.idleStateCount == 0) {
                    this.threadsRequestingIdle.remove();
                    assert (currentThread != this.threadsRequestingIdle.peekFirst());
                    this.condition.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        boolean isBuilding() {
            this.lock.lock();
            try {
                boolean bl = !this.allowFileScopeRequests && this.activitiyCount > 0;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private boolean canStartRequest(boolean isFileScopeRequest) {
            if (this.allowFileScopeRequests) {
                assert (this.idleStateCount > 0) : "workspace must be in an idle state if only file scope requests are allowed to proceed.";
                assert (!this.threadsRequestingIdle.isEmpty());
                return isFileScopeRequest;
            }
            return this.activitiyCount > 0 || this.threadsRequestingIdle.isEmpty();
        }
    }
}

