/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.units.requests;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.units.requests.IRequest;
import org.apache.royale.compiler.units.requests.IRequestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestMaker<ResultType extends IRequestResult, RequesteeInterfaceType, RequesteeType extends RequesteeInterfaceType> {
    private static final boolean THROW_ASSERTIONS = System.getProperty("throw.assertions", "false").equals("true");

    public final IRequest<ResultType, RequesteeInterfaceType> getRequest(RequesteeType u, AtomicReference<IRequest<ResultType, RequesteeInterfaceType>> atomicRef, Workspace workspace, boolean isNeededForFileScope) {
        IRequest<ResultType, RequesteeInterfaceType> existingRequest = atomicRef.get();
        if (existingRequest == null) {
            workspace.startRequest(isNeededForFileScope);
            Request request = new Request(u);
            if (atomicRef.compareAndSet(null, request)) {
                ExecutorService exec = workspace.getExecutorService();
                request.setFuture(exec.submit(this.wrapCallable(u, this.getCallable(u), workspace)));
            } else {
                workspace.endRequest();
            }
            assert (atomicRef.get() != null);
            return atomicRef.get();
        }
        return existingRequest;
    }

    private Callable<ResultType> wrapCallable(final RequesteeType u, final Callable<ResultType> c, final Workspace workspace) {
        return new Callable<ResultType>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ResultType call() throws InterruptedException {
                try {
                    try {
                        IRequestResult iRequestResult = (IRequestResult)c.call();
                        Object var4_5 = null;
                        workspace.endRequest();
                        return iRequestResult;
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (AssertionError ae) {
                        if (THROW_ASSERTIONS) {
                            throw ae;
                        }
                        Object ResultType = RequestMaker.this.getResultForThrowable(u, (Throwable)((Object)ae));
                        Object var4_6 = null;
                        workspace.endRequest();
                        return ResultType;
                    }
                    catch (Exception e) {
                        Object ResultType = RequestMaker.this.getResultForThrowable(u, e);
                        Object var4_7 = null;
                        workspace.endRequest();
                        return ResultType;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    workspace.endRequest();
                    throw throwable;
                }
            }
        };
    }

    protected abstract Callable<ResultType> getCallable(RequesteeType var1);

    protected abstract ResultType getResultForThrowable(RequesteeType var1, Throwable var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Request<V extends IRequestResult, W>
    implements IRequest<V, W> {
        private Future<V> future;
        private Lock lock = new ReentrantLock();
        private Condition haveFuture = this.lock.newCondition();
        private final long timestamp = System.currentTimeMillis();
        private final W requestee;

        public Request(W requestee) {
            this.requestee = requestee;
        }

        @Override
        public V get() throws InterruptedException {
            IRequestResult result = null;
            try {
                result = (IRequestResult)this.getFuture().get();
            }
            catch (ExecutionException executionException) {
                Throwable cause = executionException.getCause();
                if (THROW_ASSERTIONS && cause instanceof AssertionError) {
                    throw (AssertionError)((Object)cause);
                }
                assert (false) : "Unexpected ExecutionException!";
                executionException.printStackTrace();
            }
            return (V)result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            block3: {
                this.lock.lock();
                try {
                    if (this.future != null) break block3;
                    boolean bl = false;
                    Object var3_3 = null;
                    this.lock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
            boolean bl = this.future.isDone();
            Object var3_4 = null;
            this.lock.unlock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Future<V> getFuture() {
            this.lock.lock();
            try {
                while (this.future == null) {
                    this.haveFuture.awaitUninterruptibly();
                }
                Future<V> future = this.future;
                Object var3_2 = null;
                this.lock.unlock();
                return future;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFuture(Future<V> future) {
            this.lock.lock();
            try {
                this.future = future;
                this.haveFuture.signalAll();
                Object var3_2 = null;
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.lock.unlock();
                throw throwable;
            }
        }

        @Override
        public long getTimeStamp() {
            return this.timestamp;
        }

        @Override
        public W getRequestee() {
            return this.requestee;
        }
    }
}

